/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageID;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExtendedKeyUsageExtension
extends X509CertificateExtension {
    public static final OID EXTENDED_KEY_USAGE_OID = new OID("2.5.29.37");
    private static final long serialVersionUID = -8208115548961483723L;
    private final Set<OID> keyPurposeIDs;

    ExtendedKeyUsageExtension(boolean isCritical, List<OID> keyPurposeIDs) throws CertException {
        super(EXTENDED_KEY_USAGE_OID, isCritical, ExtendedKeyUsageExtension.encodeValue(keyPurposeIDs));
        this.keyPurposeIDs = Collections.unmodifiableSet(new LinkedHashSet<OID>(keyPurposeIDs));
    }

    ExtendedKeyUsageExtension(X509CertificateExtension extension) throws CertException {
        super(extension);
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(extension.getValue()).elements();
            LinkedHashSet<OID> ids = new LinkedHashSet<OID>(StaticUtils.computeMapCapacity(elements.length));
            for (ASN1Element e : elements) {
                ids.add(e.decodeAsObjectIdentifier().getOID());
            }
            this.keyPurposeIDs = Collections.unmodifiableSet(ids);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_EXTENDED_KEY_USAGE_EXTENSION_CANNOT_PARSE.get(String.valueOf(extension), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static byte[] encodeValue(List<OID> keyPurposeIDs) throws CertException {
        try {
            ArrayList<ASN1ObjectIdentifier> elements = new ArrayList<ASN1ObjectIdentifier>(keyPurposeIDs.size());
            for (OID oid : keyPurposeIDs) {
                elements.add(new ASN1ObjectIdentifier(oid));
            }
            return new ASN1Sequence(elements).encode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_EXTENDED_KEY_USAGE_EXTENSION_CANNOT_ENCODE.get(String.valueOf(keyPurposeIDs), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public Set<OID> getKeyPurposeIDs() {
        return this.keyPurposeIDs;
    }

    @Override
    public String getExtensionName() {
        return CertMessages.INFO_EXTENDED_KEY_USAGE_EXTENSION_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedKeyUsageExtension(oid='");
        buffer.append(this.getOID());
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", keyPurposeIDs={");
        Iterator<OID> oidIterator = this.keyPurposeIDs.iterator();
        while (oidIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(ExtendedKeyUsageID.getNameOrOID(oidIterator.next()));
            buffer.append('\'');
            if (!oidIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

