/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.redis;

import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.PropertiesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisDBUtil {
    private static JedisDBUtil instance;
    private JedisPool jedisPool;
    private Logger log = null;
    private final String READONLY = "readonly";
    private final String REDIS_IP = "redis.ip";
    private final String REDIS_PORT = "redis.port";
    private final String REDIS_TIMEOUT = "redis.timeout";
    private final String REDIS_AUTH = "redis.auth";
    Properties properties = null;
    boolean readonly = false;
    String redis_ip = null;
    int redis_port = 0;
    String redis_auth = null;
    int redis_timeout = 500;
    int minIdle = 50;
    int maxIdle = 500;
    int maxTotal = 10000;
    long maxWaitMillis = 30000L;
    long minEvictableIdleTimeMillis = 1800000L;
    int numTestsPerEvictionRun = 3;
    long softMinEvictableIdleTimeMillis = 1800000L;
    boolean testOnBorrow = false;
    boolean testOnReturn = true;
    boolean testWhileIdle = false;
    int timeBetweenEvictionRunsMillis = -1;
    boolean blockWhenExhausted = true;
    String evictionPolicyClassName = "org.apache.commons.pool2.impl.DefaultEvictionPolicy";
    boolean jmxEnabled = true;

    public static synchronized JedisDBUtil getInstance() {
        if (instance == null) {
            instance = new JedisDBUtil();
        }
        return instance;
    }

    public JedisDBUtil() {
        this.initial();
    }

    private void initial() {
        this.initialProperty();
        this.initialJedisPool();
        this.log = Logger.getLogger();
    }

    private void initialProperty() {
        InputStream is = null;
        try {
            this.properties = PropertiesUtils.getRedisProperties();
            this.readonly = this.getBooleanValue("readonly");
            this.redis_ip = this.getStringValue("redis.ip");
            this.redis_port = this.getIntegerValue("redis.port");
            this.redis_timeout = this.getIntegerValue("redis.timeout");
            this.redis_auth = this.getStringValue("redis.auth");
            this.minIdle = this.getIntegerValue("jedis.pool.minIdle");
            this.maxIdle = this.getIntegerValue("jedis.pool.maxIdle");
            this.maxTotal = this.getIntegerValue("jedis.pool.maxTotal");
            this.maxWaitMillis = this.getLongValue("jedis.pool.maxWaitMillis");
            this.minEvictableIdleTimeMillis = this.getLongValue("jedis.pool.minEvictableIdleTimeMillis");
            this.numTestsPerEvictionRun = this.getIntegerValue("jedis.pool.numTestsPerEvictionRun");
            this.softMinEvictableIdleTimeMillis = this.getLongValue("jedis.pool.softMinEvictableIdleTimeMillis");
            this.testOnBorrow = this.getBooleanValue("jedis.pool.testOnBorrow");
            this.testOnReturn = this.getBooleanValue("jedis.pool.testOnReturn");
            this.testWhileIdle = this.getBooleanValue("jedis.pool.testWhileIdle");
            this.timeBetweenEvictionRunsMillis = this.getIntegerValue("jedis.pool.timeBetweenEvictionRunsMillis");
            this.blockWhenExhausted = this.getBooleanValue("jedis.pool.blockWhenExhausted");
            this.evictionPolicyClassName = this.getStringValue("jedis.pool.evictionPolicyClassName");
            this.jmxEnabled = this.getBooleanValue("jedis.pool.jmxEnabled");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getIntegerValue(String key) {
        int value = 0;
        if (this.properties.containsKey(key)) {
            value = Integer.parseInt(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public long getLongValue(String key) {
        long value = 0L;
        if (this.properties.containsKey(key)) {
            value = Long.parseLong(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public String getStringValue(String key) {
        String value = "";
        if (this.properties.containsKey(key)) {
            value = this.properties.getProperty(key).trim();
        }
        return value;
    }

    public boolean getBooleanValue(String key) {
        boolean value = false;
        if (this.properties.containsKey(key)) {
            value = Boolean.parseBoolean(this.properties.getProperty(key).trim());
        }
        return value;
    }

    private void initialJedisPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(this.minIdle);
        config.setMaxIdle(this.maxIdle);
        config.setMaxTotal(this.maxTotal);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        config.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestWhileIdle(this.testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        config.setBlockWhenExhausted(this.blockWhenExhausted);
        config.setEvictionPolicyClassName(this.evictionPolicyClassName);
        config.setJmxEnabled(this.jmxEnabled);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, this.redis_ip, this.redis_port, this.redis_timeout, this.redis_auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(int db, String key, String value) {
        Jedis jedis = null;
        String s = "";
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                s = jedis.set(key, value);
            }
            catch (Exception e) {
                this.log.writeErrorLog("set \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(int db, String key) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            s = jedis.get(key);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(int db, String key) {
        boolean bl = false;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            bl = jedis.exists(key);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(int db, String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            l = jedis.del(key);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(int db, String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            l = jedis.incr(key);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSN(int db, String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            l = jedis.incr(key);
            if (jedis.ttl(key) == -1L) {
                jedis.expire(key, 31536000);
            }
            l %= 65535L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setex(int db, String key, int timeout, String value) {
        if (!this.readonly) {
            Jedis jedis = null;
            long t = System.nanoTime();
            String s = "";
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                s = jedis.setex(t + "~" + key, timeout, value);
            }
            catch (Exception e) {
                this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int llen(int db, String key) {
        int i = -1;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            i = jedis.keys("*" + key).size();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> getkeys(int db) {
        Set keySet = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            keySet = jedis.keys("*".getBytes());
        }
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> getkeys(int db, String pattern) {
        Set keySet = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            keySet = jedis.keys(pattern.getBytes());
        }
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> getkeys(int db, byte[] pattern) {
        Set keySet = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            keySet = jedis.keys(pattern);
        }
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] keys(int db) {
        Jedis jedis = null;
        Set keySet = null;
        byte[][] keys = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            keySet = jedis.keys("*".getBytes());
            keys = (byte[][])keySet.toArray((T[])new byte[keySet.size()][]);
        }
        catch (Exception e) {
            this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] vals(int db) {
        Jedis jedis = null;
        Set keySet = null;
        byte[][] values = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            keySet = jedis.keys("*".getBytes());
            byte[][] keys = (byte[][])keySet.toArray((T[])new byte[keySet.size()][]);
            values = (byte[][])jedis.mget(keys).toArray((T[])new byte[keySet.size()][]);
        }
        catch (Exception e) {
            this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap kvs(int db) {
        HashMap<String, byte[][]> hm = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            Set keySet = jedis.keys("*".getBytes());
            byte[][] keys = (byte[][])keySet.toArray((T[])new byte[keySet.size()][]);
            hm = new HashMap<String, byte[][]>();
            hm.put("key", keys);
            byte[][] values = null;
            System.out.println("keys:" + keys);
            if (keys != null) {
                values = (byte[][])jedis.mget(keys).toArray((T[])new byte[keySet.size()][]);
            }
            hm.put("value", values);
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getex(int db, String key, Long maxId) {
        Jedis jedis = null;
        ArrayList<String> ls = new ArrayList<String>();
        long ltimemillis = 0L;
        try {
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            for (String iKey : jedis.keys("*" + key)) {
                String timemillis;
                int inx;
                if (!JedisDBUtil.isNotBlank(iKey) || (inx = iKey.indexOf("~")) <= 0 || (ltimemillis = Long.parseLong(timemillis = iKey.substring(0, inx))) <= maxId) continue;
                ls.add(jedis.get(iKey));
                JedisDBUtil.setLongValue(maxId, ltimemillis);
            }
        }
        catch (Exception e) {
            this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrange(int db, String key, Long maxId) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            ls = jedis.lrange(key, 0L, jedis.llen(key).longValue());
            int start = 0;
            int idx = 0;
            long ltimemillis = 0L;
            Iterator iterator = ls.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (!JedisDBUtil.isNotBlank(s)) continue;
                int inx = s.indexOf("~");
                Long ll = System.nanoTime();
                if (inx <= 0) continue;
                String timemillis = s.substring(0, inx);
                ltimemillis = Long.parseLong(timemillis);
                if (ltimemillis <= maxId) {
                    iterator.remove();
                }
                ++idx;
                if (ltimemillis >= ll) continue;
                ++start;
            }
            JedisDBUtil.setLongValue(maxId, ltimemillis);
            if (start > 0) {
                jedis.ltrim(key, (long)start, jedis.llen(key).longValue());
            }
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lrange(int db, String key, long maxId, List<String> ls) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            ls.addAll(jedis.lrange(key, 0L, jedis.llen(key).longValue()));
            int start = 0;
            int idx = 0;
            long ltimemillis = 0L;
            Iterator<String> iterator = ls.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                if (!JedisDBUtil.isNotBlank(s)) continue;
                int inx = s.indexOf("~");
                Long ll = System.nanoTime();
                if (inx <= 0) continue;
                String timemillis = s.substring(0, inx);
                ltimemillis = Long.parseLong(timemillis);
                if (ltimemillis <= maxId) {
                    iterator.remove();
                }
                ++idx;
                if (ltimemillis >= ll) continue;
                ++start;
            }
            maxId = ltimemillis;
            if (start > 0) {
                jedis.ltrim(key, (long)start, jedis.llen(key).longValue());
            }
        }
        return maxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(int db, String key, String field, String value) {
        Jedis jedis = null;
        long l = -1L;
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                l = jedis.hset(key, field, value);
            }
            catch (Exception e) {
                this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(int db, String key, String field) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            s = jedis.hget(key, field);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hexists(int db, String key, String field) {
        boolean bl = false;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            bl = jedis.hexists(key, field);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(int db, String key, String ... fields) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            l = jedis.hdel(key, fields);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(int db, String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            l = jedis.hlen(key);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(int db, String key) {
        Set st = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            st = jedis.hkeys(key);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(int db, String key) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            ls = jedis.hvals(key);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> configGet(int db, String key) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            ls = jedis.configGet(key);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(int db, String key, Map<String, String> hash) {
        Jedis jedis = null;
        String s = "";
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                s = jedis.hmset(key, hash);
            }
            catch (Exception e) {
                this.log.writeErrorLog("hkeys \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(int db, String key, String ... fields) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            ls = jedis.hmget(key, fields);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(int db, String key, String ... members) {
        Jedis jedis = null;
        long l = -1L;
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                l = jedis.sadd(key, members);
            }
            catch (Exception e) {
                this.log.writeErrorLog("hkeys \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(int db, String key) {
        Set st = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.select(db);
            st = jedis.smembers(key);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(int db, String key, String ... members) {
        Jedis jedis = null;
        long l = -1L;
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                l = jedis.srem(key, members);
            }
            catch (Exception e) {
                this.log.writeErrorLog("hkeys \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return l;
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0 || "null".equalsIgnoreCase(str)) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean setLongValue(Long oldValue, long newValue) {
        try {
            Field field = Long.class.getDeclaredField("value");
            field.setAccessible(true);
            field.setLong(oldValue, newValue);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String flushDB(int db) {
        Jedis jedis = null;
        String s = "";
        if (!this.readonly) {
            try {
                jedis = this.jedisPool.getResource();
                jedis.select(db);
                s = jedis.flushDB();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.writeErrorLog("hkeys \u5f02\u5e38:" + e.getStackTrace());
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                }
            }
        }
        return s;
    }

    public static String byte2hex(byte[] buffer) {
        String h = "0x";
        for (byte aBuffer : buffer) {
            String temp = Integer.toHexString(aBuffer & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    public static String HexToStr(byte[] data, int offset, int length) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (length == 0) {
            return "";
        }
        char[] ch = new char[length * 2];
        try {
            int tLength = length + offset;
            int index = 0;
            for (int i = offset; i < tLength; ++i) {
                byte sByte = data[i];
                ch[index++] = hexChar[sByte >> 4 & 0xF];
                ch[index++] = hexChar[sByte & 0xF];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ch);
    }

    public static String hexStringToEncodeString(String s, String Encoding) {
        byte[] baKeyword = new byte[s.length() / 2];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            s = new String(baKeyword, Encoding);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String hexToEncode(byte[] bty) {
        String s = "";
        try {
            s = new String(bty, 0, bty.length, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String hexToEncode(byte[] bty, String Encoding) {
        String s = "";
        try {
            s = new String(bty, 0, bty.length, Encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) {
        JedisDBUtil JedisUtilBean = JedisDBUtil.getInstance();
        int db = 15;
        long end = JedisUtilBean.incr(db, "incr");
        System.out.println("end:" + end);
    }
}

