/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.redis;

import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.PropertiesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisUtil {
    private static JedisUtil instance;
    private JedisPool jedisPool;
    private Logger log = null;
    private final String REDIS_IP = "redis.ip";
    private final String REDIS_PORT = "redis.port";
    private final String REDIS_TIMEOUT = "redis.timeout";
    private final String REDIS_AUTH = "redis.auth";
    Properties properties = null;
    String redis_ip = null;
    int redis_port = 0;
    String redis_auth = null;
    int redis_timeout = 500;
    int minIdle = 50;
    int maxIdle = 500;
    int maxTotal = 10000;
    long maxWaitMillis = 30000L;
    long minEvictableIdleTimeMillis = 1800000L;
    int numTestsPerEvictionRun = 3;
    long softMinEvictableIdleTimeMillis = 1800000L;
    boolean testOnBorrow = false;
    boolean testOnReturn = true;
    boolean testWhileIdle = false;
    int timeBetweenEvictionRunsMillis = -1;
    boolean blockWhenExhausted = true;
    String evictionPolicyClassName = "org.apache.commons.pool2.impl.DefaultEvictionPolicy";
    boolean jmxEnabled = true;

    public static synchronized JedisUtil getInstance() {
        if (instance == null) {
            instance = new JedisUtil();
        } else {
            try {
                instance.get("unitInfoUpdateStamp");
            }
            catch (Exception e) {
                JedisUtil.instance.log.writeErrorLog("Redis \u8fde\u63a5\u5f02\u5e38,\u91cd\u65b0\u8fde\u63a5!" + e.getMessage());
                e.printStackTrace();
                instance = new JedisUtil();
            }
        }
        return instance;
    }

    public JedisUtil() {
        this.initial();
    }

    private void initial() {
        this.initialProperty();
        this.initialJedisPool();
        this.log = Logger.getLogger();
    }

    private void initialProperty() {
        InputStream is = null;
        try {
            this.properties = PropertiesUtils.getRedisProperties();
            this.redis_ip = this.properties.getProperty("redis.ip");
            this.redis_port = this.getIntegerValue("redis.port");
            this.redis_timeout = this.getIntegerValue("redis.timeout");
            this.redis_auth = this.properties.getProperty("redis.auth");
            this.minIdle = this.getIntegerValue("jedis.pool.minIdle");
            this.maxIdle = this.getIntegerValue("jedis.pool.maxIdle");
            this.maxTotal = this.getIntegerValue("jedis.pool.maxTotal");
            this.maxWaitMillis = this.getLongValue("jedis.pool.maxWaitMillis");
            this.minEvictableIdleTimeMillis = this.getLongValue("jedis.pool.minEvictableIdleTimeMillis");
            this.numTestsPerEvictionRun = this.getIntegerValue("jedis.pool.numTestsPerEvictionRun");
            this.softMinEvictableIdleTimeMillis = this.getLongValue("jedis.pool.softMinEvictableIdleTimeMillis");
            this.testOnBorrow = this.getBooleanValue("jedis.pool.testOnBorrow");
            this.testOnReturn = this.getBooleanValue("jedis.pool.testOnReturn");
            this.testWhileIdle = this.getBooleanValue("jedis.pool.testWhileIdle");
            this.timeBetweenEvictionRunsMillis = this.getIntegerValue("jedis.pool.timeBetweenEvictionRunsMillis");
            this.blockWhenExhausted = this.getBooleanValue("jedis.pool.blockWhenExhausted");
            this.evictionPolicyClassName = this.getStringValue("jedis.pool.evictionPolicyClassName");
            this.jmxEnabled = this.getBooleanValue("jedis.pool.jmxEnabled");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getIntegerValue(String key) {
        int value = 0;
        if (this.properties.containsKey(key)) {
            value = Integer.parseInt(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public long getLongValue(String key) {
        long value = 0L;
        if (this.properties.containsKey(key)) {
            value = Long.parseLong(this.properties.getProperty(key).trim());
        }
        return value;
    }

    public String getStringValue(String key) {
        String value = "";
        if (this.properties.containsKey(key)) {
            value = this.properties.getProperty(key).trim();
        }
        return value;
    }

    public boolean getBooleanValue(String key) {
        boolean value = false;
        if (this.properties.containsKey(key)) {
            value = Boolean.parseBoolean(this.properties.getProperty(key).trim());
        }
        return value;
    }

    private void initialJedisPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(this.minIdle);
        config.setMaxIdle(this.maxIdle);
        config.setMaxTotal(this.maxTotal);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        config.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        config.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestWhileIdle(this.testWhileIdle);
        config.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        config.setBlockWhenExhausted(this.blockWhenExhausted);
        config.setEvictionPolicyClassName(this.evictionPolicyClassName);
        config.setJmxEnabled(this.jmxEnabled);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, this.redis_ip, this.redis_port, this.redis_timeout, this.redis_auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            s = jedis.set(key, value);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            s = jedis.get(key);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        boolean bl = false;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            bl = jedis.exists(key);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.del(key);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setex(String key, int timeout, String value) {
        Jedis jedis = null;
        long t = System.nanoTime();
        String s = "";
        try {
            jedis = this.jedisPool.getResource();
            s = jedis.setex(t + "~" + key, timeout, value);
        }
        catch (Exception e) {
            this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int llen(String key) {
        int i = -1;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            i = jedis.keys("*" + key).size();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getex(String key, Long maxId) {
        Jedis jedis = null;
        ArrayList<String> ls = new ArrayList<String>();
        long ltimemillis = 0L;
        try {
            jedis = this.jedisPool.getResource();
            for (String iKey : jedis.keys("*" + key)) {
                String timemillis;
                int inx;
                if (!JedisUtil.isNotBlank(iKey) || (inx = iKey.indexOf("~")) <= 0 || (ltimemillis = Long.parseLong(timemillis = iKey.substring(0, inx))) <= maxId) continue;
                ls.add(jedis.get(iKey));
                JedisUtil.setLongValue(maxId, ltimemillis);
            }
        }
        catch (Exception e) {
            this.log.writeErrorLog("exists \u5f02\u5e38:" + e.getStackTrace());
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrange(String key, Long maxId) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            ls = jedis.lrange(key, 0L, jedis.llen(key).longValue());
            int start = 0;
            int idx = 0;
            long ltimemillis = 0L;
            Iterator iterator = ls.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                if (!JedisUtil.isNotBlank(s)) continue;
                int inx = s.indexOf("~");
                Long ll = System.nanoTime();
                if (inx <= 0) continue;
                String timemillis = s.substring(0, inx);
                ltimemillis = Long.parseLong(timemillis);
                if (ltimemillis <= maxId) {
                    iterator.remove();
                }
                ++idx;
                if (ltimemillis >= ll) continue;
                ++start;
            }
            JedisUtil.setLongValue(maxId, ltimemillis);
            if (start > 0) {
                jedis.ltrim(key, (long)start, jedis.llen(key).longValue());
            }
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lrange(String key, long maxId, List<String> ls) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            ls.addAll(jedis.lrange(key, 0L, jedis.llen(key).longValue()));
            int start = 0;
            int idx = 0;
            long ltimemillis = 0L;
            Iterator<String> iterator = ls.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                if (!JedisUtil.isNotBlank(s)) continue;
                int inx = s.indexOf("~");
                Long ll = System.nanoTime();
                if (inx <= 0) continue;
                String timemillis = s.substring(0, inx);
                ltimemillis = Long.parseLong(timemillis);
                if (ltimemillis <= maxId) {
                    iterator.remove();
                }
                ++idx;
                if (ltimemillis >= ll) continue;
                ++start;
            }
            maxId = ltimemillis;
            if (start > 0) {
                jedis.ltrim(key, (long)start, jedis.llen(key).longValue());
            }
        }
        return maxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.hset(key, field, value);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            s = jedis.hget(key, field);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hexists(String key, String field) {
        boolean bl = false;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            bl = jedis.hexists(key, field);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String ... fields) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.hdel(key, fields);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(String key) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.hlen(key);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(String key) {
        Set st = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            st = jedis.hkeys(key);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(String key) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            ls = jedis.hvals(key);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(String key, Map<String, String> hash) {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            s = jedis.hmset(key, hash);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String key, String ... fields) {
        List ls = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            ls = jedis.hmget(key, fields);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String ... members) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.sadd(key, members);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        Set st = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            st = jedis.smembers(key);
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String ... members) {
        long l = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            l = jedis.srem(key, members);
        }
        return l;
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0 || "null".equalsIgnoreCase(str)) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean setLongValue(Long oldValue, long newValue) {
        try {
            Field field = Long.class.getDeclaredField("value");
            field.setAccessible(true);
            field.setLong(oldValue, newValue);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String flushDB() {
        String s = "";
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            s = jedis.flushDB();
        }
        return s;
    }

    public static void main(String[] args) {
        JedisUtil JedisUtilBean = new JedisUtil();
        System.out.println("\u53d6\u503c\uff1a" + JedisUtilBean.get("unitInfoUpdateStamp"));
    }
}

