/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.redis;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisUtil {
    private static RedisUtil instance;
    private Jedis jedis;
    private JedisPool jedisPool;
    private ShardedJedis shardedJedis;
    private ShardedJedisPool shardedJedisPool;
    private final String REDIS_IP = "redis.ip";
    private final String REDIS_PORT = "redis.port";
    private final String REDIS_AUTH = "redis.auth";
    private final String REDIS_PROPERTIES_FILE_PATH = "/redis.properties";
    Properties properties = null;
    String redis_ip = null;
    int redis_port = 0;
    String redis_auth = null;

    public static synchronized RedisUtil getInstance() {
        if (instance == null) {
            instance = new RedisUtil();
        }
        return instance;
    }

    public RedisUtil() {
        this.initial();
    }

    private void initial() {
        this.initialProperty();
        this.initialPool();
        this.initialShardedPool();
        this.shardedJedis = this.shardedJedisPool.getResource();
        this.jedis = this.jedisPool.getResource();
        this.jedis.auth(this.redis_auth);
    }

    private void initialProperty() {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/redis.properties");
            this.properties = new Properties();
            this.properties.load(is);
            this.redis_ip = this.properties.getProperty("redis.ip");
            this.redis_port = this.getIntegerValue("redis.port");
            this.redis_auth = this.properties.getProperty("redis.auth");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getIntegerValue(String key) {
        int value = 0;
        if (this.properties.containsKey(key)) {
            value = Integer.parseInt(this.properties.getProperty(key).trim());
        }
        return value;
    }

    private void initialPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(5);
        config.setTestOnBorrow(false);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, this.redis_ip, this.redis_port);
    }

    private void initialShardedPool() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(5);
        config.setTestOnBorrow(false);
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo si = new JedisShardInfo(this.redis_ip, this.redis_port);
        si.setPassword(this.redis_auth);
        shards.add(si);
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, shards);
    }

    public void rpush(String key, String value, long timeout) {
        long t = 0L;
        t = timeout > 0L ? System.nanoTime() + timeout * 1000000000L : Long.MAX_VALUE;
        this.shardedJedis.rpush(key, new String[]{t + "~" + value});
    }

    public Long llen(String key) {
        return this.shardedJedis.llen(key);
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0 || "null".equalsIgnoreCase(str)) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public List<String> lrange(String key, Long maxId) {
        List ls = this.shardedJedis.lrange(key, 0L, this.shardedJedis.llen(key).longValue());
        System.out.println("111111111ls.size():" + ls.size());
        System.out.println("\u4f20\u8fdb\u6765\u7684maxId:" + maxId);
        int start = 0;
        int idx = 0;
        long ltimemillis = 0L;
        Iterator iterator = ls.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!RedisUtil.isNotBlank(s)) continue;
            int inx = s.indexOf("~");
            Long ll = System.nanoTime();
            if (inx <= 0) continue;
            String timemillis = s.substring(0, inx);
            ltimemillis = Long.parseLong(timemillis);
            if (ltimemillis <= maxId) {
                iterator.remove();
                System.out.println("\u79fb\u9664:" + s);
            }
            ++idx;
            if (ltimemillis >= ll) continue;
            ++start;
        }
        RedisUtil.setLongValue(maxId, ltimemillis);
        System.out.println("\u4f20\u51fa\u53bb\u7684maxId:" + maxId);
        System.out.println("2222222222ls.size():" + ls.size());
        if (start > 0) {
            this.shardedJedis.ltrim(key, (long)start, this.shardedJedis.llen(key).longValue());
            System.out.println("\u79fb\u9664\u8fc7\u671f\u6570\u636e0-" + start);
        }
        return ls;
    }

    private static boolean setLongValue(Long oldValue, long newValue) {
        try {
            Field field = Long.class.getDeclaredField("value");
            field.setAccessible(true);
            field.setLong(oldValue, newValue);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lrange(String key, long maxId, List<String> ls) {
        ls.addAll(this.shardedJedis.lrange(key, 0L, this.shardedJedis.llen(key).longValue()));
        System.out.println("111111111ls.size():" + ls.size());
        System.out.println("\u4f20\u8fdb\u6765\u7684maxId:" + maxId);
        int start = 0;
        int idx = 0;
        long ltimemillis = 0L;
        Iterator<String> iterator = ls.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!RedisUtil.isNotBlank(s)) continue;
            int inx = s.indexOf("~");
            Long ll = System.nanoTime();
            if (inx <= 0) continue;
            String timemillis = s.substring(0, inx);
            ltimemillis = Long.parseLong(timemillis);
            if (ltimemillis <= maxId) {
                iterator.remove();
                System.out.println("\u79fb\u9664:" + s);
            }
            ++idx;
            if (ltimemillis >= ll) continue;
            ++start;
        }
        maxId = ltimemillis;
        System.out.println("\u4f20\u51fa\u53bb\u7684maxId:" + maxId);
        System.out.println("2222222222ls.size():" + ls.size());
        if (start > 0) {
            this.shardedJedis.ltrim(key, (long)start, this.shardedJedis.llen(key).longValue());
            System.out.println("\u79fb\u9664\u8fc7\u671f\u6570\u636e0-" + start);
        }
        return maxId;
    }

    public String flushDB() {
        return this.jedis.flushDB();
    }

    public void returnResource() {
        this.jedisPool.returnResource(this.jedis);
        this.shardedJedisPool.returnResource(this.shardedJedis);
    }

    public static void main(String[] args) {
        RedisUtil JedisUtilBean = new RedisUtil();
    }
}

