/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb;

import com.vcarecity.savedb.cache.DataCache;
import com.vcarecity.savedb.cache.DefaultDataCache;
import com.vcarecity.savedb.log.LogManager;
import com.vcarecity.savedb.mq.DefaultActiveMQReader;
import com.vcarecity.savedb.mq.MQManager;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.OracleWriter;
import com.vcarecity.savedb.writer.OracleWriterFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.StringUtil;

public class BatchSaveDB {
    private Logger logger_exception = Logger.getLogger((String)"nameException");
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<DataCache> cacheList = new ArrayList<DataCache>();
    private List<OracleWriter> writerList = new ArrayList<OracleWriter>();
    private Map producerMap = new HashMap();

    public void exceptionCaught(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        this.logger_exception.info((Object)bos.toString());
    }

    public void startService() throws Exception {
        String[] mqs;
        LogManager.init();
        MQManager.init();
        for (String queue_name : mqs = PropertiesUtils.getMqProperty("queues").split(";")) {
            int queue_direction;
            String o = PropertiesUtils.getMqProperty("queue_direction_" + queue_name);
            if (!StringUtil.isNotBlank((String)o) || (queue_direction = Integer.valueOf(o).intValue()) != 1) continue;
            this.startOne(queue_name);
        }
        System.out.println("[" + TimeUtil.getLocalTime() + "]BatchSaveDB ready!");
    }

    private void startOne(String typeName) throws Exception {
        String queue_name = PropertiesUtils.getMqProperty("queue_name_" + typeName);
        int cache_size = Integer.valueOf(PropertiesUtils.getMqProperty("cache_size_" + typeName));
        int queue_type = Integer.valueOf(PropertiesUtils.getMqProperty("queue_type_" + typeName));
        int batch_size = Integer.valueOf(PropertiesUtils.getMqProperty("batch_size_" + typeName));
        int queue_direction = Integer.valueOf(PropertiesUtils.getMqProperty("queue_direction_" + typeName, "1"));
        try {
            DefaultDataCache cache = new DefaultDataCache();
            cache.setName(typeName + " Cache");
            cache.setMaxCacheSize(cache_size);
            this.cacheList.add(cache);
            DefaultActiveMQReader reader = new DefaultActiveMQReader(typeName + " Reader");
            reader.setBatchSave(this);
            reader.setDataCache(cache);
            reader.setQueueName(queue_name);
            reader.setQueueType(queue_type);
            reader.init();
            reader.startRead();
            System.out.println("[" + this.sdf.format(new Date()) + "] " + typeName + " Reader start");
            for (int thread_size = Integer.valueOf(PropertiesUtils.getMqProperty(new StringBuilder().append("thread_size_").append(typeName).toString(), "1")).intValue(); thread_size > 0; --thread_size) {
                OracleWriter writer = OracleWriterFactory.getWriter(typeName);
                writer.setBatchSize(batch_size);
                writer.setName(typeName + " Writer" + thread_size);
                writer.setBatchSave(this);
                writer.setDataCache(cache);
                writer.init();
                writer.startWrite();
                this.writerList.add(writer);
                System.out.println("[" + this.sdf.format(new Date()) + "] " + typeName + " Writer" + thread_size + " start");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<OracleWriter> getWriterList() {
        return this.writerList;
    }

    public List<DataCache> getCacheList() {
        return this.cacheList;
    }

    public Map getProducerMap() {
        return this.producerMap;
    }
}

