/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.data;

import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TimeUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import net.sf.json.JSONObject;

public class Cache {
    Logger logger = Logger.getLogger();
    JedisDBUtil JedisUtil = JedisDBUtil.getInstance();

    public void freshNewDataToRedis() {
        Timestamp t1 = TimeUtil.getTimestamp();
        Timestamp tt = TimeUtil.getTimestamp("1999-01-01 01:01:01");
        this.JedisUtil = JedisDBUtil.getInstance();
        tt = this.JedisUtil.exists(2, "lastUpdateTime") != false ? TimeUtil.getTimestamp(this.JedisUtil.get(2, "lastUpdateTime")) : TimeUtil.getTimestamp("1999-01-01 01:01:01");
        String dateTime = ((Date)tt).toString();
        dateTime = dateTime.substring(0, dateTime.length() - 2);
        this.JedisUtil.set(2, "lastUpdateTime", ((Date)t1).toString());
        this.cacheAnalogValue(this.JedisUtil, dateTime);
        this.clearCacheAnalogValue(this.JedisUtil, dateTime);
        this.cacheNBUnit(this.JedisUtil, dateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheAnalogValue(JedisDBUtil JedisUtil2, String tt) {
        Connection conn = null;
        PreparedStatement pstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        int count = 0;
        SQLStr.append(" SELECT T.PUSER_CODE,                                                                          ");
        SQLStr.append("        ROUND(IFNULL(T.ANALOG_VALUE_LOWER, -99999999) * UT.PRECISIONS) AS ANALOG_VALUE_LOWER,  ");
        SQLStr.append("        ROUND(IFNULL(T.ANALOG_VALUE_TOP, 99999999) * UT.PRECISIONS) AS ANALOG_VALUE_TOP,       ");
        SQLStr.append("        UT.PRECISIONS                                                                          ");
        SQLStr.append("   FROM T_UNIT T, T_UNIT_TYPE UT                                                               ");
        SQLStr.append("  WHERE ((T.ANALOG_VALUE_TOP IS NOT NULL) OR (T.ANALOG_VALUE_TOP IS NOT NULL))                 ");
        SQLStr.append("  AND T.UNIT_TYPE_ID = UT.UNIT_TYPE_ID                                                         ");
        SQLStr.append("   AND T.UPDATESTAMP >= DATE_FORMAT(?,'%Y-%m-%d %h:%i:%s')                    ");
        SQLStr.append("  AND T.ISDELETED = 0                                                                          ");
        SQLStr.append("  AND T.UNIT_TYPE_ID=131                                                                       ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            pstam.setString(1, tt);
            rs = pstam.executeQuery();
            while (rs.next()) {
                JedisUtil2.hset(2, "UnitAnalogValue", rs.getString("PUSER_CODE"), rs.getString("ANALOG_VALUE_LOWER") + "," + rs.getString("ANALOG_VALUE_TOP"));
                ++count;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clearCacheAnalogValue(JedisDBUtil JedisUtil2, String tt) {
        Connection conn = null;
        PreparedStatement pstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        int count = 0;
        SQLStr.append(" SELECT                                                                                  ");
        SQLStr.append("   T.PUSER_CODE,                                                                         ");
        SQLStr.append("   ROUND(IFNULL(T.ANALOG_VALUE_LOWER, -99999999) * UT.PRECISIONS) AS ANALOG_VALUE_LOWER, ");
        SQLStr.append("   ROUND(IFNULL(T.ANALOG_VALUE_TOP, 99999999) * UT.PRECISIONS) AS ANALOG_VALUE_TOP,      ");
        SQLStr.append("   UT.PRECISIONS                                                                         ");
        SQLStr.append(" FROM T_UNIT T,                                                                          ");
        SQLStr.append("      T_UNIT_TYPE UT                                                                     ");
        SQLStr.append(" WHERE ((T.ANALOG_VALUE_TOP IS NOT NULL)                                                 ");
        SQLStr.append(" OR (T.ANALOG_VALUE_TOP IS NOT NULL))                                                    ");
        SQLStr.append(" AND T.UNIT_TYPE_ID = UT.UNIT_TYPE_ID                                                    ");
        SQLStr.append(" AND T.UPDATESTAMP >= DATE_FORMAT(?, '%Y-%m-%d %h:%i:%s')               ");
        SQLStr.append(" AND T.ISDELETED = 1                                                                     ");
        SQLStr.append(" AND T.UNIT_TYPE_ID = 131                                                                ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            pstam.setString(1, tt);
            rs = pstam.executeQuery();
            while (rs.next()) {
                JedisUtil2.hdel(2, "UnitAnalogValue", rs.getString("PUSER_CODE"));
                ++count;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheNBUnit(JedisDBUtil JedisUtil2, String tt) {
        Connection conn = null;
        PreparedStatement pstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        int count = 0;
        SQLStr.append(" SELECT                                                                  ");
        SQLStr.append("   T.UNIT_CODE,                                                          ");
        SQLStr.append("   T.USER_CODE,                                                          ");
        SQLStr.append("   IFNULL(T.REMAINING_BATTERY, 0) AS REMAINING_BATTERY,                  ");
        SQLStr.append("   IFNULL(T.SIGNAL_STRENGTH, 0) AS SIGNAL_STRENGTH                       ");
        SQLStr.append(" FROM T_UNIT T                                                           ");
        SQLStr.append(" WHERE T.IMEI IS NOT NULL                                                ");
        SQLStr.append(" AND T.ISDELETED = 0                                                     ");
        SQLStr.append(" AND T.UPDATESTAMP >= DATE_FORMAT(?,'%Y-%m-%d %h:%i:%s')");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            pstam.setString(1, tt);
            rs = pstam.executeQuery();
            while (rs.next()) {
                JedisUtil2.hset(2, "NBUnit", rs.getString("UNIT_CODE"), rs.getString("USER_CODE") + "," + rs.getString("REMAINING_BATTERY") + "," + rs.getString("SIGNAL_STRENGTH"));
                ++count;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return count;
    }

    public static void main(String[] args) {
    }
}

