/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.data;

import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TimeUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class Unit {
    Logger logger = null;
    Date tt = TimeUtil.getTimestamp("1999-01-01 01:01:01");
    JedisDBUtil JedisUtil = null;

    public Unit() {
        this.logger = Logger.getLogger();
        this.JedisUtil = JedisDBUtil.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getOnLineCheckData() {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT T.USER_CODE AS UNITNO,                               ");
        SQLStr.append("        T.EQUIPMENT_NO AS EQUIPMENTNO,                       ");
        SQLStr.append("        IF(T.GATEWAY_NO=NULL, 0, T.GATEWAY_NO) AS GATEWAYNO  ");
        SQLStr.append("   FROM T_UNIT T                                             ");
        SQLStr.append("  WHERE FN_STR_PCOUNT(T.PUSER_CODE, '/') < 4                 ");
        SQLStr.append("    AND T.ISDELETED = 0                                      ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            JSONObject obj = new JSONObject();
            JSONArray arr = new JSONArray();
            while (rs.next()) {
                obj = new JSONObject();
                obj.put((Object)"unitNo", (Object)rs.getString("UNITNO"));
                obj.put((Object)"equipmentNo", (Object)rs.getString("EQUIPMENTNO"));
                obj.put((Object)"gatewayNo", (Object)rs.getString("GATEWAYNO"));
                arr.add((Object)obj);
            }
            reObj.put((Object)"units", (Object)arr);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        this.logger.writeDebugLog("reObj.toString():" + reObj.toString());
        return reObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject waterRegister(String ccid) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_INSERTT_UNIT_REGINFO(?,?)} ");
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, ccid);
            cstam.registerOutParameter(2, 12);
            cstam.execute();
            String deviceId = cstam.getString(2);
            String status = "01";
            if (StringUtils.isBlank((String)deviceId) || deviceId.length() < 8) {
                status = "01";
                deviceId = ccid;
            } else {
                status = "00";
            }
            reObj.put((Object)"ccid", (Object)ccid);
            reObj.put((Object)"deviceId", (Object)deviceId);
            reObj.put((Object)"status", (Object)status);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, cstam, conn);
        }
        IOUtil.closeDB(rs, cstam, conn);
        return reObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject dtuRegister(String user_code, String imei) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_INSERTT_DTU_REGINFO(?,?,?)} ");
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, user_code);
            cstam.setString(2, imei);
            cstam.registerOutParameter(3, 12);
            cstam.execute();
            int is_reg = cstam.getInt(3);
            reObj.put((Object)"status", (Object)String.valueOf(is_reg));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, cstam, conn);
        }
        IOUtil.closeDB(rs, cstam, conn);
        return reObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateUnitCcid(String ccid, String unitno, String protocolNo) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_UPDATE_UNIT_LOGIN(?,?,?,?)} ");
        SQLStr.append(" UPDATE T_UNIT T                   ");
        SQLStr.append(" SET T.CCID = ?,              ");
        SQLStr.append("     T.PROTOCOL_NO = ?  ");
        SQLStr.append(" WHERE T.USER_CODE = ?   ");
        SQLStr.append(" AND T.ISDELETED = 0;              ");
        int ret = 1;
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, ccid);
            cstam.setString(2, protocolNo);
            cstam.setString(3, unitno);
            cstam.registerOutParameter(4, 12);
            cstam.executeUpdate();
            ret = cstam.getInt(4);
            reObj.put((Object)"ret", (Object)String.valueOf(ret));
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, cstam, conn);
        }
        IOUtil.closeDB(rs, cstam, conn);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateUnitCCID(String ccid, String unitno, String protocolNo) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" UPDATE T_UNIT T                   ");
        SQLStr.append(" SET T.CCID = ?,              ");
        SQLStr.append("     T.PROTOCOL_NO = ?  ");
        SQLStr.append(" WHERE T.USER_CODE = ?   ");
        SQLStr.append(" AND T.ISDELETED = 0;              ");
        int ret = 1;
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, ccid);
            cstam.setString(2, protocolNo);
            cstam.setString(3, unitno);
            cstam.executeUpdate();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, cstam, conn);
        }
        IOUtil.closeDB(rs, cstam, conn);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnitCCID(String unitno) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        Object rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_UPDATE_UNIT_CCID(?)} ");
        try {
            conn = ConnectionManager.openConnection();
            conn.setAutoCommit(true);
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, unitno);
            cstam.execute();
            IOUtil.closeDB(null, cstam, conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.closeDB(null, cstam, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnitOnline(String user_code, int is_online) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        Object rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_UPDATE_UNIT_ONLINE_BY_DTU_NO(?,?)} ");
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, user_code);
            cstam.setInt(2, is_online);
            cstam.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
        IOUtil.closeDB(null, cstam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnitOnline(String gateway_no, String protocol_no, String equipment_no, String user_code, String is_online) {
        Connection conn = null;
        Object pstam = null;
        CallableStatement cstam = null;
        Object rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" {call P_UPDATE_UNIT_ONLINE(?,?,?,?,?,?)} ");
        try {
            conn = ConnectionManager.openConnection();
            cstam = conn.prepareCall(SQLStr.toString());
            cstam.setString(1, gateway_no);
            cstam.setString(2, protocol_no);
            cstam.setString(3, equipment_no);
            cstam.setString(4, user_code);
            cstam.setString(5, is_online);
            cstam.setLong(6, this.getUnitId(user_code));
            cstam.execute();
        }
        catch (Exception e) {
            try {
                System.out.println("user_code:" + user_code);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, cstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, cstam, conn);
        }
        IOUtil.closeDB(null, cstam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheOnLineStatus() {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT                                                                     ");
        SQLStr.append("   T.USER_CODE,                                                             ");
        SQLStr.append("   T.IS_ONLINE,                                                             ");
        SQLStr.append("   IFNULL(T.CHANGE_TIME,DATE_SUB(now(),INTERVAL 2 DAY)) AS CHANGE_TIME, ");
        SQLStr.append("   T.GATEWAY_NO                                                             ");
        SQLStr.append(" FROM T_UNIT T                                                              ");
        SQLStr.append(" WHERE T.PID < 0                                                            ");
        SQLStr.append(" AND T.ISDELETED = 0                                                        ");
        SQLStr.append(" AND T.GATEWAY_NO IS NOT NULL                                               ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                this.JedisUtil.set(1, rs.getString("user_code"), rs.getString("gateway_no") + "," + rs.getString("is_online") + "," + TimeUtil.getTimeMillis(rs.getString("CHANGE_TIME")) + "," + rs.getString("CHANGE_TIME"));
                this.JedisUtil.set(7, rs.getString("user_code"), rs.getString("gateway_no") + "," + rs.getString("is_online") + "," + TimeUtil.getTimeMillis(rs.getString("CHANGE_TIME")) + "," + rs.getString("CHANGE_TIME"));
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cacheOnLineStatus(String datetime) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        System.out.println("datetime:" + datetime);
        SQLStr.append(" SELECT                                                                                                    ");
        SQLStr.append("   T.USER_CODE,                                                                                            ");
        SQLStr.append("   T.IS_ONLINE,                                                                                            ");
        SQLStr.append("   DATE_FORMAT(IFNULL(T.CHANGE_TIME, DATE_SUB(now(),INTERVAL 2 DAY)),'%Y-%m-%d %H:%i:%s')AS UPDATESTAMP,   ");
        SQLStr.append("   T.GATEWAY_NO                                                                                            ");
        SQLStr.append(" FROM T_UNIT T                                                                                             ");
        SQLStr.append(" WHERE T.PID < 0                                                                                           ");
        SQLStr.append(" AND T.ISDELETED = 0                                                                                       ");
        SQLStr.append(" AND T.GATEWAY_NO IS NOT NULL                                                                              ");
        SQLStr.append(" AND T.CHANGE_TIME > DATE_FORMAT('" + datetime + "', '%Y-%m-%d %H:%i:%s')                                      ");
        SQLStr.append(" ORDER BY T.CHANGE_TIME                                                                                    ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                this.JedisUtil.set(1, rs.getString("USER_CODE"), rs.getString("GATEWAY_NO") + "," + rs.getString("IS_ONLINE") + "," + TimeUtil.getTimeMillis(rs.getString("UPDATESTAMP")) + "," + rs.getString("UPDATESTAMP"));
                this.JedisUtil.set(7, rs.getString("USER_CODE"), rs.getString("GATEWAY_NO") + "," + rs.getString("IS_ONLINE") + "," + TimeUtil.getTimeMillis(rs.getString("UPDATESTAMP")) + "," + rs.getString("UPDATESTAMP"));
                datetime = rs.getString("UPDATESTAMP");
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return datetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheIPCOnLineStatus() {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT T.USER_CODE,T.IS_ONLINE,T.CHANGE_TIME,T.GATEWAY_NO FROM T_UNIT T WHERE T.PID<0 AND  REGEXP_LIKE(T.USER_CODE, '^[A-Z]{3}[0-9]{0,50}') AND T.ISDELETED=0 AND T.GATEWAY_NO IS NOT NULL ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                long l = System.currentTimeMillis();
                this.JedisUtil.set(1, rs.getString("USER_CODE"), rs.getString("GATEWAY_NO") + "," + 1 + "," + l + "," + rs.getString("CHANGE_TIME"));
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectUnitId(String puser_code, String user_code) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT MAX(U.UNIT_ID)    FROM T_UNIT U    WHERE PUSER_CODE = " + puser_code + "     AND ISDELETED = 0 ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long selectUnitId(String puser_code) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT IFNULL(MAX(U.UNIT_ID),0)    FROM T_UNIT U    WHERE PUSER_CODE = '" + puser_code + "'     AND ISDELETED = 0 ");
        Long id = 0L;
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnitPath(String user_code) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT T.PUSER_CODE FROM T_UNIT T WHERE T.USER_CODE = '" + user_code + "' AND T.ISDELETED=0 ");
        String unitPath = "";
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                unitPath = rs.getString("PUSER_CODE");
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return unitPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnitId(String user_code) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        ResultSet rs = null;
        JSONObject reObj = new JSONObject();
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" SELECT MAX(T.UNIT_ID) FROM T_UNIT T WHERE T.USER_CODE = '" + user_code + "' AND T.ISDELETED=0 ");
        long unit_id = 0L;
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            rs = pstam.executeQuery();
            while (rs.next()) {
                unit_id = rs.getLong(1);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(rs, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(rs, pstam, conn);
        }
        IOUtil.closeDB(rs, pstam, conn);
        return unit_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnitEleFire(String dtu_no, JSONObject data) {
        Connection conn = null;
        PreparedStatement pstam = null;
        Object cstam = null;
        Object rs = null;
        long unit_id = this.getUnitId(dtu_no);
        if (data == null || unit_id == 0L) {
            return;
        }
        int v_phase3_under_thr = 0;
        if (data.has("phase3UnderThr")) {
            v_phase3_under_thr = data.getInt("phase3UnderThr");
        }
        int v_phase3_over_thr = 0;
        if (data.has("phase3OverThr")) {
            v_phase3_over_thr = data.getInt("phase3OverThr");
        }
        int v_current_alarm_thr = 0;
        if (data.has("currentAlarmThr")) {
            v_current_alarm_thr = data.getInt("currentAlarmThr");
        }
        int v_remain_current_warn_thr1 = 0;
        if (data.has("remainCurrentWarnThr")) {
            v_remain_current_warn_thr1 = data.getInt("remainCurrentWarnThr");
        }
        int v_remain_current_warn_thr2 = 0;
        if (data.has("remainCurrentWarnThr2")) {
            v_remain_current_warn_thr2 = data.getInt("remainCurrentWarnThr2");
        }
        int v_remain_current_warn_thr3 = 0;
        if (data.has("remainCurrentWarnThr3")) {
            v_remain_current_warn_thr3 = data.getInt("remainCurrentWarnThr3");
        }
        int v_remain_current_warn_thr4 = 0;
        if (data.has("remainCurrentWarnThr4")) {
            v_remain_current_warn_thr4 = data.getInt("remainCurrentWarnThr4");
        }
        int v_remain_current_alarm_thr1 = 0;
        if (data.has("remainCurrentAlarmThr")) {
            v_remain_current_alarm_thr1 = data.getInt("remainCurrentAlarmThr");
        }
        int v_remain_current_alarm_thr2 = 0;
        if (data.has("remainCurrentAlarmThr2")) {
            v_remain_current_alarm_thr2 = data.getInt("remainCurrentAlarmThr2");
        }
        int v_remain_current_alarm_thr3 = 0;
        if (data.has("remainCurrentAlarmThr3")) {
            v_remain_current_alarm_thr3 = data.getInt("remainCurrentAlarmThr3");
        }
        int v_remain_current_alarm_thr4 = 0;
        if (data.has("remainCurrentAlarmThr4")) {
            v_remain_current_alarm_thr4 = data.getInt("remainCurrentAlarmThr4");
        }
        int v_temp_warn_thr1 = 0;
        if (data.has("tempWarnThr")) {
            v_temp_warn_thr1 = data.getInt("tempWarnThr");
        }
        int v_temp_warn_thr2 = 0;
        if (data.has("tempWarnThr2")) {
            v_temp_warn_thr2 = data.getInt("tempWarnThr2");
        }
        int v_temp_warn_thr3 = 0;
        if (data.has("tempWarnThr3")) {
            v_temp_warn_thr3 = data.getInt("tempWarnThr3");
        }
        int v_temp_warn_thr4 = 0;
        if (data.has("tempWarnThr4")) {
            v_temp_warn_thr4 = data.getInt("tempWarnThr4");
        }
        int v_temp_alarm_thr1 = 0;
        if (data.has("tempAlarmThr")) {
            v_temp_alarm_thr1 = data.getInt("tempAlarmThr");
        }
        int v_temp_alarm_thr2 = 0;
        if (data.has("tempAlarmThr2")) {
            v_temp_alarm_thr2 = data.getInt("tempAlarmThr2");
        }
        int v_temp_alarm_thr3 = 0;
        if (data.has("tempAlarmThr3")) {
            v_temp_alarm_thr3 = data.getInt("tempAlarmThr3");
        }
        int v_temp_alarm_thr4 = 0;
        if (data.has("tempAlarmThr4")) {
            v_temp_alarm_thr4 = data.getInt("tempAlarmThr4");
        }
        StringBuffer SQLStr = new StringBuffer();
        SQLStr.append(" REPLACE INTO T_UNIT_ELE_FIRE      ");
        SQLStr.append(" (UNIT_ID,                         ");
        SQLStr.append("  DTU_NO,                          ");
        SQLStr.append("  PHASE3_UNDER_THR,                ");
        SQLStr.append("  PHASE3_OVER_THR,                 ");
        SQLStr.append("  CURRENT_ALARM_THR,               ");
        SQLStr.append("  STAMP,                           ");
        SQLStr.append("  REMAIN_CURRENT_WARN_THR1,        ");
        SQLStr.append("  REMAIN_CURRENT_WARN_THR2,        ");
        SQLStr.append("  REMAIN_CURRENT_WARN_THR3,        ");
        SQLStr.append("  REMAIN_CURRENT_WARN_THR4,        ");
        SQLStr.append("  REMAIN_CURRENT_ALARM_THR1,       ");
        SQLStr.append("  REMAIN_CURRENT_ALARM_THR2,       ");
        SQLStr.append("  REMAIN_CURRENT_ALARM_THR3,       ");
        SQLStr.append("  REMAIN_CURRENT_ALARM_THR4,       ");
        SQLStr.append("  TEMP_WARN_THR1,                  ");
        SQLStr.append("  TEMP_WARN_THR2,                  ");
        SQLStr.append("  TEMP_WARN_THR3,                  ");
        SQLStr.append("  TEMP_WARN_THR4,                  ");
        SQLStr.append("  TEMP_ALARM_THR1,                 ");
        SQLStr.append("  TEMP_ALARM_THR2,                 ");
        SQLStr.append("  TEMP_ALARM_THR3,                 ");
        SQLStr.append("  TEMP_ALARM_THR4)                 ");
        SQLStr.append(" VALUES                            ");
        SQLStr.append(" (" + unit_id + ",                     ");
        SQLStr.append("  '" + dtu_no + "',                    ");
        SQLStr.append("  " + v_phase3_under_thr + ",          ");
        SQLStr.append("  " + v_phase3_over_thr + ",           ");
        SQLStr.append("  " + v_current_alarm_thr + ",         ");
        SQLStr.append("  now(),                           ");
        SQLStr.append("  " + v_remain_current_warn_thr1 + ",  ");
        SQLStr.append("  " + v_remain_current_warn_thr2 + ",  ");
        SQLStr.append("  " + v_remain_current_warn_thr3 + ",  ");
        SQLStr.append("  " + v_remain_current_warn_thr4 + ",  ");
        SQLStr.append("  " + v_remain_current_alarm_thr1 + ", ");
        SQLStr.append("  " + v_remain_current_alarm_thr2 + ", ");
        SQLStr.append("  " + v_remain_current_alarm_thr3 + ", ");
        SQLStr.append("  " + v_remain_current_alarm_thr4 + ", ");
        SQLStr.append("  " + v_temp_warn_thr1 + ",            ");
        SQLStr.append("  " + v_temp_warn_thr2 + ",            ");
        SQLStr.append("  " + v_temp_warn_thr3 + ",            ");
        SQLStr.append("  " + v_temp_warn_thr4 + ",            ");
        SQLStr.append("  " + v_temp_alarm_thr1 + ",           ");
        SQLStr.append("  " + v_temp_alarm_thr2 + ",           ");
        SQLStr.append("  " + v_temp_alarm_thr3 + ",           ");
        SQLStr.append("  " + v_temp_alarm_thr4 + ")           ");
        try {
            conn = ConnectionManager.openConnection();
            pstam = conn.prepareStatement(SQLStr.toString());
            pstam.execute();
        }
        catch (Exception e) {
            try {
                System.out.println("updateUnitEleFire SQLStr: " + SQLStr.toString());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.closeDB(null, pstam, conn);
                throw throwable;
            }
            IOUtil.closeDB(null, pstam, conn);
        }
        IOUtil.closeDB(null, pstam, conn);
    }

    public static void main(String[] args) {
        Unit databean = new Unit();
        long id = databean.getUnitId("865462045289549");
        System.out.println("id:" + id);
    }
}

