/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.decode;

import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.savedb.data.CmdRecord;
import com.vcarecity.savedb.data.DtuHistory;
import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.data.UnitDataParsingRule;
import com.vcarecity.savedb.decode.DecodeProtocolNo1;
import com.vcarecity.savedb.decode.DecodeProtocolNo10;
import com.vcarecity.savedb.decode.DecodeProtocolNo1001;
import com.vcarecity.savedb.decode.DecodeProtocolNo1002;
import com.vcarecity.savedb.decode.DecodeProtocolNo1003;
import com.vcarecity.savedb.decode.DecodeProtocolNo1004;
import com.vcarecity.savedb.decode.DecodeProtocolNo1101;
import com.vcarecity.savedb.decode.DecodeProtocolNo14;
import com.vcarecity.savedb.decode.DecodeProtocolNo15;
import com.vcarecity.savedb.decode.DecodeProtocolNo16;
import com.vcarecity.savedb.decode.DecodeProtocolNo2;
import com.vcarecity.savedb.decode.DecodeProtocolNo3;
import com.vcarecity.savedb.decode.DecodeProtocolNo4;
import com.vcarecity.savedb.mq.MQItem;
import com.vcarecity.savedb.util.HttpRequestUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class Decode {
    Logger log = Logger.getLogger();
    HashMap<String, Decode> DecodeFactorys = new HashMap();
    JedisDBUtil JedisUtil = JedisDBUtil.getInstance();
    CmdRecord cmdR = new CmdRecord();
    Unit unitbean = new Unit();
    UnitDataParsingRule unitDataParsingRuleBean = new UnitDataParsingRule();
    DtuHistory dtuHistoryBean = new DtuHistory();
    HttpRequestUtil httpRequest = HttpRequestUtil.getHttpRequest();

    public void AddDecode() {
        this.DecodeFactorys.put("1", new DecodeProtocolNo1());
        this.DecodeFactorys.put("11", new DecodeProtocolNo1());
        this.DecodeFactorys.put("2", new DecodeProtocolNo2());
        this.DecodeFactorys.put("3", new DecodeProtocolNo3());
        this.DecodeFactorys.put("4", new DecodeProtocolNo4());
        this.DecodeFactorys.put("1001", new DecodeProtocolNo1001());
        this.DecodeFactorys.put("1002", new DecodeProtocolNo1002());
        this.DecodeFactorys.put("1003", new DecodeProtocolNo1003());
        this.DecodeFactorys.put("1004", new DecodeProtocolNo1004());
        this.DecodeFactorys.put("14", new DecodeProtocolNo14());
        this.DecodeFactorys.put("10", new DecodeProtocolNo10());
        this.DecodeFactorys.put("15", new DecodeProtocolNo15());
        this.DecodeFactorys.put("16", new DecodeProtocolNo16());
        this.DecodeFactorys.put("1101", new DecodeProtocolNo1101());
        this.DecodeFactorys.put("1006", new DecodeProtocolNo16());
    }

    public Decode getDecode(String protocolNo) {
        return this.DecodeFactorys.get(protocolNo);
    }

    public boolean deCode(PreparedStatement pst, String gatewayNo, String protocolNo, String unitNo, String equipmentNo, int id, int pIndex, long count, StringBuffer devicePath, JSONObject dataItem, JSONObject data, JSONObject msg) throws SQLException {
        return false;
    }

    public void writeWaterData(JSONObject obj) {
        MQItem mitem = new MQItem();
        mitem.setQueueName("waterData");
        mitem.setData(obj);
    }

    public JSONArray dataDeal(String str) {
        Logger.writeConsleLog("-------------------------------------------------");
        Logger.writeConsleLog("\u8fc7\u6ee4\u524dstr:" + str);
        str = StringUtils.StringFilterSpecificCharacter(StringUtils.qj2bj(str.trim()));
        str = StringUtils.replaceMultiToOneSpace(str.trim());
        str = StringUtils.filterInvisibleCharacter(str.trim());
        Logger.writeConsleLog("\u8fc7\u6ee4\u540estr:" + str);
        Pattern p = Pattern.compile("\\d{2}/\\d{2} \\d{2}:\\d{2}");
        Matcher m = p.matcher(str);
        String findedstr = "";
        String indexs = "";
        int firstIndex = -1;
        boolean secondIndex = false;
        int lastIndex = 0;
        boolean datePos = false;
        boolean splitFlag = false;
        int dateCount = 0;
        int deviceidCount = 0;
        int matcheCount = 0;
        StringUtils.Regexp exp = new StringUtils.Regexp();
        String format = "";
        JSONObject obj = new JSONObject();
        JSONArray jarr = new JSONArray();
        exp = StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp());
        dateCount = exp.getCount();
        if (dateCount < 1) {
            this.log.writeLog("\u65e0\u6cd5\u5339\u914d\u5230\u65f6\u95f4: " + str);
            exp = StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp());
            deviceidCount = exp.getCount();
        }
        if (dateCount + deviceidCount < 1) {
            this.log.writeLog("\u65e0\u6cd5\u5339\u914d\u5230\u65f6\u95f4\u6216\u8bbe\u5907\u53f7:" + str);
            return jarr;
        }
        matcheCount = dateCount + deviceidCount;
        if (matcheCount == 1) {
            obj = this.singleDataAnalysis(str);
            jarr.add((Object)obj);
        } else if (matcheCount > 1) {
            String regexp;
            p = Pattern.compile(exp.getRegexp());
            m = p.matcher(str);
            if (m.find()) {
                findedstr = m.group();
                String newStr = findedstr.replace("-", "/");
                str = str.replace(findedstr, newStr);
            }
            if ((m = (p = Pattern.compile(StringUtils.getDateRegExp())).matcher(str)).lookingAt()) {
                format = StringUtils.getDateRegExp();
                firstIndex = 0;
            }
            if (StringUtils.isBlank(format) && (m = (p = Pattern.compile(regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDeviceIdRegExp()))).matcher(str)).lookingAt()) {
                format = regexp;
                firstIndex = 0;
            }
            if (StringUtils.isBlank(format)) {
                regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDateRegExp());
                p = Pattern.compile(regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    String datetime = m.group();
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = regexp;
                }
            }
            if (StringUtils.isBlank(format)) {
                regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDeviceIdRegExp());
                p = Pattern.compile(regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = regexp;
                }
            }
            if (dateCount > 0 && StringUtils.isBlank(format)) {
                p = Pattern.compile(exp.getRegexp());
                m = p.matcher(str);
                firstIndex = 0;
                if (m.find()) {
                    firstIndex = m.start();
                    findedstr = m.group();
                    str = str.substring(firstIndex) + str.substring(0, firstIndex);
                    Logger.writeConsleLog("str===========:" + str);
                }
                return this.dataDeal(str);
            }
            if (deviceidCount > 0 && StringUtils.isBlank(format)) {
                p = Pattern.compile(exp.getRegexp());
                m = p.matcher(str);
                firstIndex = 0;
                if (m.find()) {
                    firstIndex = m.start();
                    findedstr = m.group();
                    str = str.substring(firstIndex) + str.substring(0, firstIndex);
                    Logger.writeConsleLog("str===========:" + str);
                }
                return this.dataDeal(str);
            }
            if (StringUtils.isBlank(format)) {
                return jarr;
            }
            if (firstIndex == 0) {
                p = Pattern.compile(format);
                m = p.matcher(str);
                while (m.find()) {
                    findedstr = m.group();
                    indexs = indexs + m.start() + ",";
                    lastIndex = m.end();
                }
                indexs = indexs + str.length();
            }
            if (lastIndex == str.length()) {
                indexs = "0,";
                m = p.matcher(str);
                while (m.find()) {
                    findedstr = m.group();
                }
                datePos = true;
            }
            String[] tmpArr = indexs.split(",");
            Logger.writeConsleLog("tmpArr:" + tmpArr.length);
            if (tmpArr.length > 2) {
                for (int i = 0; i < tmpArr.length - 1; ++i) {
                    String data = str.substring(Integer.parseInt(tmpArr[i]), Integer.parseInt(tmpArr[i + 1]));
                    Logger.writeConsleLog("data:" + data);
                    obj = this.singleDataAnalysis(data);
                    jarr.add((Object)obj);
                }
            } else if (tmpArr.length == 2) {
                obj = this.singleDataAnalysis(str);
                jarr.add((Object)obj);
            }
        }
        return jarr;
    }

    public JSONObject singleDataAnalysis(String data) {
        String date = TimeUtil.getLocalTime();
        String stamp = TimeUtil.getLocalTime();
        String deviceid = "0";
        String eventTypeName = "\u6570\u636e\u4f20\u8f93";
        String unitTypeName = "\u6d88\u9632\u4e3b\u673a";
        String eventType = "228";
        String unitType = "0";
        String postion = ".";
        Object p = null;
        Object m = null;
        JSONObject obj = new JSONObject();
        String[] dataDictionaryState = null;
        String[] unitTypes = null;
        dataDictionaryState = StringUtils.Set2Array(this.JedisUtil.hkeys(0, "dataDictionaryState"));
        unitTypes = StringUtils.Set2Array(this.JedisUtil.hkeys(0, "unitType"));
        HashMap hm = StringUtils.getOptimalMatchingDate(data);
        if (hm.size() > 0) {
            date = hm.get("value").toString();
            stamp = TimeUtil.getFullDateTimeString(hm.get("value").toString(), hm.get("regexp").toString()).toString();
        }
        Logger.writeConsleLog("dealData stamp:" + stamp);
        if (StringUtils.isBlank(stamp)) {
            stamp = TimeUtil.getLocalTime();
        }
        for (String item : dataDictionaryState) {
            if (data.indexOf(item.toString()) <= -1) continue;
            eventTypeName = item.toString();
            eventType = this.JedisUtil.hget(0, "dataDictionaryState", eventTypeName);
            break;
        }
        Logger.writeConsleLog("eventTypeName:" + eventTypeName);
        for (String it : unitTypes) {
            if (data.indexOf(it.toString()) <= -1) continue;
            unitTypeName = it.toString();
            unitType = this.JedisUtil.hget(0, "unitType", unitTypeName);
            break;
        }
        Logger.writeConsleLog("unitTypeName:" + unitTypeName);
        String tmpStr = data.replaceAll(date, "").replaceAll(eventTypeName, "").replaceAll(unitTypeName, "");
        hm = StringUtils.getOptimalMatchingDeviceId(StringUtils.getFilterDate(tmpStr));
        if (hm.size() > 0) {
            deviceid = hm.get("value").toString();
        }
        Logger.writeConsleLog("deviceid:" + deviceid);
        if (StringUtils.isBlank(deviceid)) {
            deviceid = "0";
        }
        postion = StringUtils.StringFilterNoStarAndQuestionAndBlankMark(StringUtils.compareStrWithSub(data.replaceAll(date, ""), eventTypeName, unitTypeName, true).replaceAll(deviceid, ""));
        Logger.writeConsleLog("postion:" + postion);
        Logger.writeConsleLog("===================================================");
        if (StringUtils.isBlank(postion)) {
            postion = unitTypeName;
        }
        obj.put((Object)"stamp", (Object)stamp);
        obj.put((Object)"unitTypeName", (Object)unitTypeName);
        obj.put((Object)"unitType", (Object)unitType);
        obj.put((Object)"postion", (Object)postion);
        obj.put((Object)"eventTypeName", (Object)eventTypeName);
        obj.put((Object)"eventType", (Object)eventType);
        obj.put((Object)"deviceid", (Object)deviceid);
        return obj;
    }
}

