/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.decode;

import com.vcarecity.savedb.data.UnitParsingError;
import com.vcarecity.savedb.decode.Decode;
import com.vcarecity.savedb.util.DigitalTransUtil;
import com.vcarecity.savedb.util.HexUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.PropertiesUtil;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class DecodeProtocolNo1
extends Decode {
    private String deviceId = "";
    private Timestamp tm = null;
    private int system_no = 0;

    public DecodeProtocolNo1() {
        try {
            this.system_no = Integer.parseInt(PropertiesUtil.getValue("config/sys.properties", "system_no"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deCode(PreparedStatement pst, String gatewayNo, String protocolNo, String unitNo, String equipmentNo, int id, int pIndex, long count, StringBuffer devicePath, JSONObject dataItem, JSONObject data, JSONObject msg) throws SQLException {
        boolean bl = false;
        try {
            switch (id) {
                case 1537: {
                    this.deviceId = data.getString("deviceId");
                    if (StringUtil.isNotBlank((String)this.deviceId) && !"0".equalsIgnoreCase(this.deviceId)) {
                        String hostModel = data.getString("hostModel");
                        if ("1".equals(hostModel)) {
                            this.deviceId = HexUtil.toDecimalString(this.deviceId, 0, 2, 16) + "-" + HexUtil.toDecimalString(this.deviceId, 2, 4, 16) + "-" + HexUtil.toDecimalString(this.deviceId, 4, 6, 16);
                        }
                        devicePath.append("/" + this.deviceId);
                    }
                    devicePath.append("/");
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString()));
                    pst.setString(pIndex++, devicePath.toString());
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("hostModel")));
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("eventType")));
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("event")));
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("acquisitionTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, data.getString("desc"));
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 1538: {
                    String hostModel = data.getString("hostModel");
                    String rowCount = data.getString("rowCount");
                    String dataContent = data.getString("dataContent");
                    String dtu_no = unitNo;
                    String eventType = "0";
                    String desc = "";
                    Timestamp stamp = null;
                    String acquisitionTime = "";
                    String dateStr = "";
                    String timeStr = "";
                    if (StringUtil.isBlank((String)dataContent)) break;
                    if (!HexUtil.isHexNumberRex(dataContent)) {
                        this.log.writeErrorLog("dtu_no:" + dtu_no + ",1538_dataContent:" + dataContent);
                        break;
                    }
                    String cnDataStr = DigitalTransUtil.hexStringToEncodeString(dataContent.trim(), "GBK");
                    this.log.writeDebugInfo("dtu_no:" + dtu_no + ",1538_dataContent:" + dataContent + ",cnDataStr:" + cnDataStr);
                    Logger.writeConsleLog("dtu_no:" + dtu_no);
                    JSONArray jarr = this.dataDeal(cnDataStr.trim());
                    if (jarr.size() == 0) break;
                    String date = "";
                    String eventTypeName = "";
                    String unitType = "";
                    String postion = "";
                    for (Object o : jarr) {
                        JSONObject json = (JSONObject)o;
                        String dateTime = json.get("stamp").toString();
                        if (dateTime == null || "19990101010101".equalsIgnoreCase(dateTime) || "2015-01-01 01:01:01".equalsIgnoreCase(dateTime)) {
                            this.unitDataParsingRuleBean.insertManufacturerModelNoHex(hostModel, dtu_no, dataContent, cnDataStr.trim(), 3, dateTime);
                            continue;
                        }
                        stamp = TimeUtil.getTimestamp();
                        unitType = json.get("unitType").toString();
                        postion = json.get("postion").toString();
                        eventType = json.get("eventType").toString();
                        eventTypeName = json.get("eventTypeName").toString();
                        this.deviceId = json.get("deviceid").toString();
                        data.put((Object)"eventTypeName", (Object)eventTypeName);
                        StringBuffer thisDevicePath = new StringBuffer();
                        thisDevicePath.append(devicePath);
                        if (StringUtil.isNotBlank((String)this.deviceId) && !"0".equalsIgnoreCase(this.deviceId)) {
                            thisDevicePath.append("/" + this.deviceId);
                        }
                        if ("0".equalsIgnoreCase(this.deviceId)) {
                            this.deviceId = equipmentNo;
                        }
                        thisDevicePath.append("/");
                        pIndex = 1;
                        pst.setInt(pIndex++, this.system_no);
                        pst.setLong(pIndex++, this.unitbean.selectUnitId(thisDevicePath.toString()));
                        pst.setString(pIndex++, thisDevicePath.toString());
                        pst.setString(pIndex++, this.deviceId);
                        pst.setInt(pIndex++, id);
                        pst.setInt(pIndex++, Integer.valueOf(hostModel));
                        pst.setInt(pIndex++, Integer.valueOf(eventType));
                        pst.setInt(pIndex++, Integer.valueOf(unitType));
                        pst.setDouble(pIndex++, 0.0);
                        pst.setDouble(pIndex++, 0.0);
                        pst.setTimestamp(pIndex++, TimeUtil.getTimestamp(dateTime, "yyyy-MM-dd HH:mm:ss"));
                        pst.setString(pIndex++, postion);
                        pst.setString(pIndex++, gatewayNo);
                        pst.setString(pIndex++, protocolNo);
                        pst.setString(pIndex++, unitNo);
                        pst.setString(pIndex++, equipmentNo);
                        if (msg.toString().length() > 4000) {
                            if (count == 0L) {
                                this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                                ++count;
                            }
                            pst.setString(pIndex++, msg.toString().length() + "");
                        } else {
                            pst.setString(pIndex++, msg.toString());
                        }
                        pst.setString(pIndex++, data.toString());
                        pst.setDouble(pIndex++, 0.0);
                        pst.setInt(pIndex++, 0);
                        pst.addBatch();
                    }
                    break;
                }
                case 1793: {
                    this.deviceId = equipmentNo;
                    devicePath.append("/");
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString()));
                    pst.setString(pIndex++, devicePath.toString());
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    double indication = Double.valueOf(data.getString("indication"));
                    String v = this.JedisUtil.hget(2, "UnitAnalogValue", devicePath.toString());
                    if (StringUtils.isNotBlank(v)) {
                        String[] tmp = v.split(",", 100);
                        double top = 0.0;
                        double lower = 0.0;
                        if (StringUtils.isNotBlank(tmp[0])) {
                            lower = Double.parseDouble(tmp[0]);
                        }
                        if (StringUtils.isNotBlank(tmp[1])) {
                            top = Double.parseDouble(tmp[1]);
                        }
                        if (top != 0.0 && indication > top) {
                            pst.setInt(pIndex++, 522);
                        } else if (lower != 0.0 && indication < lower) {
                            pst.setInt(pIndex++, 523);
                        } else {
                            pst.setInt(pIndex++, 399);
                        }
                    } else {
                        pst.setInt(pIndex++, 399);
                    }
                    pst.setInt(pIndex++, 224);
                    pst.setDouble(pIndex++, indication);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 1794: {
                    this.deviceId = equipmentNo;
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("alarmFlag")));
                    pst.setInt(pIndex++, 224);
                    pst.setDouble(pIndex++, Double.valueOf(data.getString("indication")));
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 720: {
                    this.deviceId = data.getString("portNo");
                    devicePath.append("/" + this.deviceId);
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("event")));
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 722: 
                case 723: {
                    this.deviceId = data.getString("portNo");
                    devicePath.append("/" + this.deviceId);
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("event")));
                    if (data.containsKey((Object)"state")) {
                        pst.setInt(pIndex++, Integer.valueOf(data.getString("state")));
                    } else {
                        pst.setInt(pIndex++, 0);
                    }
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    if (data.containsKey((Object)"power")) {
                        pst.setDouble(pIndex++, Integer.valueOf(data.getString("power")).intValue());
                    } else {
                        pst.setDouble(pIndex++, 0.0);
                    }
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 1024: {
                    devicePath.append("/");
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString()));
                    pst.setString(pIndex++, devicePath.toString());
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 1);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 1025: {
                    String tmp = data.getString("dataContent");
                    if (StringUtils.isNotBlank(tmp) && tmp.indexOf("AA") == 0 && (tmp.length() == 50 || tmp.length() == 82)) {
                        devicePath.append("/");
                        pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString()));
                        pst.setString(pIndex++, devicePath.toString());
                        pst.setString(pIndex++, this.deviceId);
                        pst.setInt(pIndex++, id);
                        pst.setInt(pIndex++, 1);
                        pst.setInt(pIndex++, id);
                        pst.setInt(pIndex++, 0);
                        pst.setDouble(pIndex++, 0.0);
                        pst.setDouble(pIndex++, 0.0);
                        pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                        pst.setString(pIndex++, data.getString("dataContent"));
                        pst.setString(pIndex++, gatewayNo);
                        pst.setString(pIndex++, protocolNo);
                        pst.setString(pIndex++, unitNo);
                        pst.setString(pIndex++, equipmentNo);
                        if (msg.toString().length() > 4000) {
                            if (count == 0L) {
                                this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                                ++count;
                            }
                            pst.setString(pIndex++, msg.toString().length() + "");
                        } else {
                            pst.setString(pIndex++, msg.toString());
                        }
                        pst.setString(pIndex++, data.toString());
                        pst.setDouble(pIndex++, 0.0);
                        pst.setInt(pIndex++, 0);
                        pst.addBatch();
                        break;
                    }
                    UnitParsingError bean = new UnitParsingError();
                    bean.insertUnitParsingError(unitNo, data.getString("dataContent"), Integer.parseInt(gatewayNo), Integer.parseInt(protocolNo), Integer.parseInt(equipmentNo));
                    break;
                }
                case 130: {
                    this.deviceId = unitNo;
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, 2);
                    pst.setInt(pIndex++, 1);
                    pst.setInt(pIndex++, 1);
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    long beginTime1 = System.currentTimeMillis();
                    this.log.writeDebugLog(unitNo + " \u767b\u5f55\u9a8c\u8bc1\u5f00\u59cb!");
                    int ret = this.unitbean.updateUnitCCID(data.getString("ccid"), unitNo, protocolNo);
                    data.put((Object)"ret", (Object)String.valueOf(ret));
                    msg.replace((Object)"functionWord", (Object)"2");
                    dataItem.put((Object)"data", (Object)data);
                    dataItem.put((Object)"id", (Object)"2");
                    long endTime1 = System.currentTimeMillis();
                    long costTime1 = (endTime1 - beginTime1) / 1000L;
                    this.log.writeDebugLog(unitNo + " \u767b\u5f55\u9a8c\u8bc1\u5b8c\u6bd5!\u8017\u65f6:" + costTime1 + "\u79d2");
                    this.cmdR.sendCommand(gatewayNo, msg);
                    if (ret == 0) {
                        // empty if block
                    }
                    this.JedisUtil.set(1, unitNo, gatewayNo + ",1," + System.currentTimeMillis() + "," + TimeUtil.timeStampToString(System.currentTimeMillis()));
                    break;
                }
                case 131: {
                    this.deviceId = unitNo;
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, 3);
                    pst.setInt(pIndex++, 1);
                    pst.setInt(pIndex++, 2);
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    this.JedisUtil.set(1, unitNo, gatewayNo + ",0," + System.currentTimeMillis() + "," + TimeUtil.timeStampToString(System.currentTimeMillis()));
                    break;
                }
                case 1282: {
                    this.deviceId = unitNo;
                    devicePath = new StringBuffer();
                    devicePath.append("/0/" + this.deviceId + "/");
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString()));
                    pst.setString(pIndex++, devicePath.toString());
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("alarmFlag")));
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, 0.0);
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, "0");
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    pst.addBatch();
                    break;
                }
                case 1808: {
                    this.deviceId = data.getString("lineNo");
                    devicePath.append("/" + this.deviceId);
                    pst.setLong(pIndex++, this.unitbean.selectUnitId(devicePath.toString() + "/"));
                    pst.setString(pIndex++, devicePath.toString() + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("alarmStatus")));
                    pst.setInt(pIndex++, 0);
                    pst.setDouble(pIndex++, Double.valueOf(data.getString("alarmData")));
                    pst.setDouble(pIndex++, 0.0);
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, this.deviceId);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, "");
                    }
                    pst.setString(pIndex++, "");
                    pst.setDouble(pIndex++, 0.0);
                    pst.setInt(pIndex++, 0);
                    Logger.writeConsleLog("\u6dfb\u52a0\u7535\u6c14\u706b\u707e\u6570\u636e\uff1a" + pIndex);
                    pst.addBatch();
                    break;
                }
                case 1809: 
                case 1810: {
                    this.deviceId = unitNo;
                    pst.setLong(pIndex++, this.unitbean.selectUnitId("/0/" + this.deviceId + "/"));
                    pst.setString(pIndex++, "/0/" + this.deviceId + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    int UNIT_STATE_ID = 0;
                    if (data.containsKey((Object)"liquidOverEvent")) {
                        UNIT_STATE_ID = Integer.valueOf(data.getString("liquidOverEvent"));
                    } else if (data.containsKey((Object)"tempOverEvent")) {
                        UNIT_STATE_ID = Integer.valueOf(data.getString("tempOverEvent"));
                    }
                    pst.setInt(pIndex++, UNIT_STATE_ID);
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("lowBatteryEvent")));
                    if (data.containsKey((Object)"hydraulic")) {
                        pst.setDouble(pIndex++, Double.valueOf(data.getString("hydraulic")));
                    } else {
                        pst.setDouble(pIndex++, Double.valueOf(data.getString("temperature")));
                    }
                    pst.setDouble(pIndex++, Double.valueOf(data.getString("temperature")));
                    this.tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                    if (this.tm == null) {
                        this.tm = TimeUtil.getTimestamp();
                        this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                    }
                    pst.setTimestamp(pIndex++, this.tm);
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, "");
                    }
                    pst.setString(pIndex++, data.toString());
                    pst.setDouble(pIndex++, Double.valueOf(data.getString("percent")));
                    pst.setInt(pIndex++, Integer.valueOf(data.getString("signalStrength")));
                    Logger.writeConsleLog("\u6dfb\u52a0\u7535\u6c14\u706b\u707e\u6570\u636e\uff1a" + pIndex);
                    pst.addBatch();
                    break;
                }
                case 110: {
                    break;
                }
            }
            bl = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bl;
    }
}

