/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.decode;

import com.vcarecity.savedb.decode.Decode;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.sf.json.JSONObject;

public class DecodeProtocolNo1101
extends Decode {
    private String deviceId = "";
    private Timestamp tm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deCode(PreparedStatement pst, String gatewayNo, String protocolNo, String unitNo, String equipmentNo, int id, int pIndex, long count, StringBuffer devicePath, JSONObject dataItem, JSONObject data, JSONObject msg) throws SQLException {
        boolean bl = false;
        try {
            unitNo = this.JedisUtil.hget(2, "NBUnit", unitNo);
            if (StringUtils.isEmpty(unitNo)) {
                this.log.writeErrorLog("\u6ca1\u6709\u53d6\u5f97\u5bf9\u5e94\u7684\u8bbe\u5907\u53f7:" + unitNo);
                this.log.writeErrorLog("protocolNo_1101:" + msg.toString());
                bl = false;
            }
            String[] tmpArr = unitNo.split(",", 100);
            double remaining_battery = -1.0;
            int signal_strength = -1;
            double smokeConc = 0.0;
            double tempValue = 0.0;
            if (tmpArr.length > 2) {
                unitNo = tmpArr[0];
                remaining_battery = Double.parseDouble(tmpArr[1]);
                signal_strength = Integer.parseInt(tmpArr[2]);
                this.JedisUtil.set(1, unitNo, gatewayNo + ",1," + System.currentTimeMillis() + "," + TimeUtil.timeStampToString(System.currentTimeMillis()));
            }
            switch (id) {
                case 1: 
                case 9000: {
                    this.deviceId = unitNo;
                    pst.setLong(pIndex++, this.unitbean.selectUnitId("/0/" + unitNo + "/"));
                    pst.setString(pIndex++, "/0/" + unitNo + "/");
                    pst.setString(pIndex++, this.deviceId);
                    pst.setInt(pIndex++, id);
                    pst.setInt(pIndex++, 0);
                    int unit_state_id = 0;
                    if (data.has("alarmStatus")) {
                        unit_state_id = Integer.parseInt(data.getString("alarmStatus"));
                    }
                    pst.setInt(pIndex++, unit_state_id);
                    pst.setInt(pIndex++, 0);
                    if (data.has("smokeConcentration")) {
                        smokeConc = Double.parseDouble(data.getString("smokeConcentration")) / 100.0;
                    }
                    pst.setDouble(pIndex++, smokeConc);
                    if (data.has("temperatureValue")) {
                        tempValue = Double.parseDouble(data.getString("temperatureValue")) / 100.0;
                    }
                    pst.setDouble(pIndex++, tempValue);
                    pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                    pst.setString(pIndex++, "");
                    pst.setString(pIndex++, gatewayNo);
                    pst.setString(pIndex++, protocolNo);
                    pst.setString(pIndex++, unitNo);
                    pst.setString(pIndex++, equipmentNo);
                    if (msg.toString().length() > 4000) {
                        if (count == 0L) {
                            this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                            ++count;
                        }
                        pst.setString(pIndex++, msg.toString().length() + "");
                    } else {
                        pst.setString(pIndex++, msg.toString());
                    }
                    pst.setString(pIndex++, data.toString());
                    if (data.has("batteryLevel")) {
                        remaining_battery = Double.parseDouble(data.getString("batteryLevel"));
                    }
                    if (data.has("nbBattery")) {
                        remaining_battery = Double.parseDouble(data.getString("nbBattery"));
                    }
                    pst.setDouble(pIndex++, remaining_battery);
                    if (data.has("signalStrength")) {
                        signal_strength = (Math.abs(Integer.parseInt(data.getString("signalStrength"))) - 51) / 62 * 100;
                    }
                    pst.setInt(pIndex++, signal_strength);
                    pst.addBatch();
                    break;
                }
                case 255: {
                    break;
                }
            }
            bl = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return bl;
    }
}

