/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.decode;

import com.vcarecity.savedb.decode.Decode;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.sf.json.JSONObject;

public class DecodeProtocolNo16
extends Decode {
    private String deviceId = "";
    private Timestamp tm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deCode(PreparedStatement pst, String gatewayNo, String protocolNo, String unitNo, String equipmentNo, int id, int pIndex, long count, StringBuffer devicePath, JSONObject dataItem, JSONObject data, JSONObject msg) throws SQLException {
        boolean bl = false;
        try {
            double remaining_battery = -1.0;
            int signal_strength = -1;
            double readValue = 0.0;
            double tempValue = 0.0;
            if ("1006".equalsIgnoreCase(protocolNo)) {
                unitNo = msg.getString("deviceId");
                if (StringUtils.isEmpty(unitNo = this.JedisUtil.hget(2, "NBUnit", unitNo))) {
                    this.log.writeErrorLog("\u6ca1\u6709\u53d6\u5f97\u5bf9\u5e94\u7684\u8bbe\u5907\u53f7:" + unitNo);
                    this.log.writeErrorLog("protocolNo_1006:" + msg.toString());
                    bl = true;
                } else {
                    remaining_battery = -1.0;
                    signal_strength = -1;
                    tempValue = 0.0;
                    String[] tmpArr = unitNo.split(",", 100);
                    if (tmpArr.length > 2) {
                        unitNo = tmpArr[0];
                        remaining_battery = Double.parseDouble(tmpArr[1]);
                        signal_strength = Integer.parseInt(tmpArr[2]);
                    }
                }
            }
            if (!bl) {
                this.JedisUtil.set(1, unitNo, gatewayNo + ",1," + System.currentTimeMillis() + "," + TimeUtil.timeStampToString(System.currentTimeMillis()));
                switch (id) {
                    case 1: 
                    case 4: 
                    case 9: {
                        this.deviceId = unitNo;
                        pst.setLong(pIndex++, this.unitbean.selectUnitId("/0/" + unitNo + "/"));
                        pst.setString(pIndex++, "/0/" + unitNo + "/");
                        pst.setString(pIndex++, this.deviceId);
                        pst.setInt(pIndex++, id);
                        pst.setInt(pIndex++, 0);
                        int unit_state_id = 0;
                        if (data.has("status")) {
                            unit_state_id = Integer.parseInt(data.getString("status"));
                        } else {
                            unit_state_id = 222;
                            if (data.has("voltageLow")) {
                                if ("0".equalsIgnoreCase(data.getString("voltageLow"))) {
                                    unit_state_id = 383;
                                    remaining_battery = 20.0;
                                } else {
                                    remaining_battery = 80.0;
                                    if (data.has("antiFoldingStatus") && "1".equalsIgnoreCase(data.getString("antiFoldingStatus"))) {
                                        unit_state_id = 963;
                                    }
                                }
                            }
                        }
                        pst.setInt(pIndex++, unit_state_id);
                        pst.setInt(pIndex++, 0);
                        if (data.has("readValue")) {
                            readValue = Double.parseDouble(data.getString("readValue"));
                        }
                        pst.setDouble(pIndex++, readValue);
                        if (data.has("tempValue")) {
                            tempValue = Double.parseDouble(data.getString("tempValue"));
                        }
                        pst.setDouble(pIndex++, tempValue);
                        pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                        pst.setString(pIndex++, "");
                        pst.setString(pIndex++, gatewayNo);
                        pst.setString(pIndex++, protocolNo);
                        pst.setString(pIndex++, unitNo);
                        pst.setString(pIndex++, equipmentNo);
                        if (msg.toString().length() > 4000) {
                            if (count == 0L) {
                                this.log.writeErrorLog("\u5355\u6b21\u4e0a\u4f20\u6570\u636e\u8fc7\u591a\uff1a" + msg.toString());
                                ++count;
                            }
                            pst.setString(pIndex++, msg.toString().length() + "");
                        } else {
                            pst.setString(pIndex++, msg.toString());
                        }
                        pst.setString(pIndex++, data.toString());
                        if (data.has("battery")) {
                            remaining_battery = Double.parseDouble(data.getString("battery"));
                        }
                        if (data.has("voltageValue")) {
                            remaining_battery = Double.parseDouble(data.getString("voltageValue"));
                            if (remaining_battery > 3000.0) {
                                remaining_battery = 3000.0;
                            }
                            remaining_battery = (remaining_battery - 2400.0) / 600.0 * 100.0;
                        }
                        pst.setInt(pIndex++, (int)Math.floor(remaining_battery));
                        if (data.has("signalStrength")) {
                            signal_strength = Integer.parseInt(data.getString("signalStrength"));
                        }
                        if (signal_strength < 0 && data.has("signalValue")) {
                            signal_strength = (Integer.parseInt(data.getString("signalValue")) - 5) / 5;
                        }
                        pst.setInt(pIndex++, signal_strength);
                        pst.addBatch();
                        break;
                    }
                    case 255: {
                        break;
                    }
                }
                bl = true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bl;
    }
}

