/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq;

import com.vcarecity.savedb.BatchSaveDB;
import com.vcarecity.savedb.cache.DataCache;
import com.vcarecity.savedb.mq.ActiveMQReader;
import com.vcarecity.savedb.mq.MQManager;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import net.sf.json.JSONObject;

public class DefaultActiveMQReader
implements ActiveMQReader {
    private String name;
    private String queueName;
    private int queueType;
    private BatchSaveDB batchSave;
    private DataCache cache;
    private Session session;
    private Destination queue;
    private MessageConsumer consumer;
    private Logger log = Logger.getLogger();
    private int batch_count = 0;
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis();

    public DefaultActiveMQReader(String name) {
        this.name = name;
    }

    @Override
    public void setDataCache(DataCache cache) {
        this.cache = cache;
    }

    @Override
    public DataCache getDataCache() {
        return this.cache;
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }

    @Override
    public int getQueueType() {
        return this.queueType;
    }

    @Override
    public void setBatchSave(BatchSaveDB batchSave) {
        this.batchSave = batchSave;
    }

    @Override
    public BatchSaveDB getBatchSave() {
        return this.batchSave;
    }

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQReader init " + this.name + " start");
        Connection connection = MQManager.openConnection();
        connection.start();
        this.session = connection.createSession(false, 1);
        this.queue = this.queueType == 1 ? this.session.createQueue(this.queueName) : this.session.createTopic(this.queueName);
        this.consumer = this.session.createConsumer(this.queue);
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQReader init " + this.name + " end");
    }

    @Override
    public void startRead() {
        try {
            this.consumer.setMessageListener(new MessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Message msg) {
                    try {
                        if (ObjectMessage.class.isInstance(msg)) {
                            if (StringUtils.isNotBlank(String.valueOf(msg))) {
                                ObjectMessage objMsg = (ObjectMessage)msg;
                                DefaultActiveMQReader.this.cache.addData(objMsg.getObject());
                            } else {
                                System.out.println("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg);
                            }
                        } else if (TextMessage.class.isInstance(msg)) {
                            if (StringUtils.isNotBlank(String.valueOf(msg))) {
                                TextMessage txtObj = (TextMessage)msg;
                                JSONObject objMsg = JSONObject.fromObject((Object)txtObj.getText().replaceAll("(java.lang.String)", ""));
                                DefaultActiveMQReader.this.cache.addData(objMsg);
                            } else {
                                System.out.println("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg);
                            }
                        } else if (String.class.isInstance(msg)) {
                            if (StringUtils.isNotBlank(String.valueOf(msg))) {
                                TextMessage txtObj = (TextMessage)msg;
                                JSONObject objMsg = JSONObject.fromObject((Object)msg);
                                DefaultActiveMQReader.this.cache.addData(objMsg);
                            } else {
                                System.out.println("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg);
                            }
                        } else if (StringBuffer.class.isInstance(msg)) {
                            if (StringUtils.isNotBlank(String.valueOf(msg))) {
                                TextMessage txtObj = (TextMessage)msg;
                                JSONObject objMsg = JSONObject.fromObject((Object)msg);
                                DefaultActiveMQReader.this.cache.addData(objMsg);
                            } else {
                                System.out.println("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg);
                            }
                        } else {
                            DefaultActiveMQReader.this.log.debug("DefaultActiveMQReader msg type error:" + msg.getClass());
                        }
                        DefaultActiveMQReader.this.batch_count++;
                        if (DefaultActiveMQReader.this.batch_count >= MQManager.BATCH_SIZE_READ) {
                            DefaultActiveMQReader.this.batch_count = 0;
                        }
                        DefaultActiveMQReader.this.endTime = System.currentTimeMillis();
                        if (DefaultActiveMQReader.this.endTime - DefaultActiveMQReader.this.startTime > (long)MQManager.READ_COMMIT_INTERVAL) {
                            DefaultActiveMQReader.this.batch_count = 0;
                            DefaultActiveMQReader.this.startTime = DefaultActiveMQReader.this.endTime;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        DefaultActiveMQReader.this.batchSave.exceptionCaught(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.batchSave.exceptionCaught(e);
        }
    }
}

