/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq;

import com.vcarecity.savedb.util.PropertiesUtils;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MQManager {
    private static ConnectionFactory factory;
    public static int BATCH_SIZE_READ;
    public static int MAX_CACHE_SIZE;
    public static int MAX_CACHE_SIZE_WRITE;
    public static int BATCH_SIZE_WRITE;
    public static int READ_COMMIT_INTERVAL;

    public static void init() {
        String url = PropertiesUtils.getMqProperty("activemq_url");
        String user = PropertiesUtils.getMqProperty("username");
        String password = PropertiesUtils.getMqProperty("password");
        factory = new ActiveMQConnectionFactory(user, password, url);
        BATCH_SIZE_READ = Integer.valueOf(PropertiesUtils.getMqProperty("batch_size_read"));
        READ_COMMIT_INTERVAL = Integer.valueOf(PropertiesUtils.getMqProperty("read_commit_interval"));
    }

    public static Connection openConnection() throws JMSException {
        Connection connection = null;
        if (factory == null) {
            MQManager.init();
        }
        connection = factory.createConnection();
        return connection;
    }

    static {
        BATCH_SIZE_READ = 500;
        MAX_CACHE_SIZE = 50000;
        MAX_CACHE_SIZE_WRITE = 50000;
        BATCH_SIZE_WRITE = 50000;
        READ_COMMIT_INTERVAL = 3000;
    }
}

