/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class CmdResponseReceiver
implements MessageListener {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "cmdResponse";
    private Destination dest = null;
    private Connection conn = null;
    private Session session = null;
    private MessageConsumer consumer = null;

    private void initialize() throws JMSException, Exception {
        this.USER = "vcare";
        this.PASSWORD = "manager";
        this.URL = "failover:(tcp://119.146.223.117:61616)";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
        this.dest = this.session.createQueue(this.queueName);
        this.consumer = this.session.createConsumer(this.dest);
    }

    public void receiveMessage() throws JMSException, Exception {
        this.initialize();
        this.conn.start();
        this.consumer.setMessageListener((MessageListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        try {
            if (msg instanceof ObjectMessage) {
                System.out.println("------Received  " + this.queueName + " ObjectMessage------");
                ObjectMessage message = (ObjectMessage)msg;
                JSONObject jsonObject = (JSONObject)message.getObject();
                System.out.println("jsonObject1\uff1a" + jsonObject);
                System.out.println("gatewayNo\uff1a" + jsonObject.getString("gatewayNo"));
                System.out.println("unitNo\uff1a" + jsonObject.getString("unitNo"));
                System.out.println("protocolNo\uff1a" + jsonObject.getString("protocolNo"));
                System.out.println("functionWord\uff1a" + jsonObject.getString("functionWord"));
                System.out.println("equipmentNo\uff1a" + jsonObject.getString("equipmentNo"));
                System.out.println("dataItems\uff1a" + jsonObject.getJSONArray("dataItems"));
                JSONArray jsonArr = jsonObject.getJSONArray("dataItems");
                for (Object object : jsonArr) {
                    JSONObject obj = (JSONObject)object;
                    Iterator it = obj.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        System.out.println(key + ":" + obj.get(key));
                    }
                }
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void close() throws JMSException {
        System.out.println("Consumer:->Closing connection");
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public static void main(String[] args) throws JMSException, Exception {
        CmdResponseReceiver receiver = new CmdResponseReceiver();
        receiver.receiveMessage();
    }
}

