/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.log.LogManager;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MsgSender {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "ActiveMQ.Demo";
    private Destination destination = null;
    private Connection conn = null;
    private Session session = null;
    private MessageProducer producer = null;

    public MsgSender() throws JMSException, Exception {
        LogManager.init();
        this.initialize();
        this.conn.start();
    }

    private void initialize() throws JMSException, Exception {
        this.USER = "vcare";
        this.PASSWORD = "manager";
        this.URL = "failover:(tcp://192.168.10.112:61616)";
        this.URL = PropertiesUtils.getMqProperty("activemq_url");
        this.USER = PropertiesUtils.getMqProperty("username");
        this.PASSWORD = PropertiesUtils.getMqProperty("password");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
    }

    public void sendJSONStringMessage(String queueName, String JSONString) throws JMSException, Exception {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject = JSONObject.fromObject((Object)JSONString);
            ObjectMessage msg = this.session.createObjectMessage();
            msg.setObject((Serializable)jsonObject);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendJSONObjectMessage(String queueName, JSONObject JObject) throws JMSException, Exception {
        try {
            ObjectMessage msg = this.session.createObjectMessage();
            msg.setObject((Serializable)JObject);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(String queueName) throws JMSException, Exception {
        ObjectMessage msg;
        JSONObject jsonObject;
        String jsonMessage;
        if ("protocolStructure".equals(queueName)) {
            jsonMessage = "";
            jsonMessage = "{\"protocolNo\":\"2\",\"function\":[{\"functionWord\":[\"1\"],\"dti\":[{\"id\":\"1\",\"name\":\"\u6ce8\u518c\",\"dataItem\":[{\"elementName\":\"ccid\",\"description\":\"ccid\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"address\",\"description\":\"\u7ec8\u7aef\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1}]}]},{\"functionWord\":[\"4\"],\"dti\":[{\"id\":\"4\",\"name\":\"\u6c34\u538b\u8d85\u9608\u503c\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"dataType\",\"description\":\"\u7c7b\u578b(01\u6062\u590d,02\u4e0b\u9650\uff0c03\u4e0a\u9650)\",\"elementType\":\"NUMBER\",\"elementLen\":2,\"elementPrecision\":1},{\"elementName\":\"threshold\",\"description\":\"\u9608\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"5\"],\"dti\":[{\"id\":\"5\",\"name\":\"\u6c34\u538b\u6062\u590d\u62a5\u544a\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"dataType\",\"description\":\"\u7c7b\u578b(01\u6062\u590d,02\u4e0b\u9650\uff0c03\u4e0a\u9650)\",\"elementType\":\"NUMBER\",\"elementLen\":2,\"elementPrecision\":1},{\"elementName\":\"threshold\",\"description\":\"\u9608\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"6\"],\"dti\":[{\"id\":\"6\",\"name\":\"\u7535\u6c60\u6b20\u538b\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"voltage\",\"description\":\"\u7535\u538b\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"7\"],\"dti\":[{\"id\":\"7\",\"name\":\"\u7535\u6c60\u6b20\u538b\u6062\u590d\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"voltage\",\"description\":\"\u7535\u538b\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"8\"],\"dti\":[{\"id\":\"8\",\"name\":\"\u65ad\u7535\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"9\"],\"dti\":[{\"id\":\"9\",\"name\":\"\u6062\u590d\u4f9b\u7535\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"10\"],\"dti\":[{\"id\":\"10\",\"name\":\"\u8bbe\u5907\u76d6\u88ab\u6253\u5f00\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"11\"],\"dti\":[{\"id\":\"11\",\"name\":\"\u8bbe\u5907\u76d6\u6062\u590d\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"12\"],\"dti\":[{\"id\":\"12\",\"name\":\"\u8bbe\u7f6eAPN\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"apn\",\"description\":\"apn\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"13\"],\"dti\":[{\"id\":\"13\",\"name\":\"\u8bfb\u53d6APN\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"apn\",\"description\":\"apn\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"14\"],\"dti\":[{\"id\":\"14\",\"name\":\"\u8bbe\u7f6eIP\u5730\u5740\u548c\u7aef\u53e3\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ip\",\"description\":\"\u670d\u52a1\u5668IP\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":30,\"elementPrecision\":1},{\"elementName\":\"port\",\"description\":\"\u7aef\u53e3\u53f7\",\"elementType\":\"VARCHAR2\",\"elementLen\":30,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"15\"],\"dti\":[{\"id\":\"15\",\"name\":\"\u8bbe\u7f6e\u538b\u529b\u9608\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdTop\",\"description\":\"\u4e0a\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdLower\",\"description\":\"\u4e0b\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"16\"],\"dti\":[{\"id\":\"16\",\"name\":\"\u8bfb\u53d6\u538b\u529b\u9608\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdTop\",\"description\":\"\u4e0a\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdLower\",\"description\":\"\u4e0b\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"21\"],\"dti\":[{\"id\":\"21\",\"name\":\"\u8bfb\u538b\u529b\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"22\"],\"dti\":[{\"id\":\"22\",\"name\":\"\u8bfb\u7535\u6c60\u7535\u538b\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"24\"],\"dti\":[{\"id\":\"24\",\"name\":\"\u5524\u9192\u65b9\u5f0f\u8bbe\u5b9a\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"timeUnit\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"25\"],\"dti\":[{\"id\":\"25\",\"name\":\"\u5bf9\u65f6\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1}]}]},{\"functionWord\":[\"26\"],\"dti\":[{\"id\":\"26\",\"name\":\"\u8bbe\u7f6e\u538b\u529b\u4e0a\u62a5\u65f6\u95f4\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"unit\",\"description\":\"\u5355\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"time\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"27\"],\"dti\":[{\"id\":\"27\",\"name\":\"\u8bfb\u53d6\u538b\u529b\u4e0a\u62a5\u65f6\u95f4\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"unit\",\"description\":\"\u5355\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"time\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"28\"],\"dti\":[{\"id\":\"28\",\"name\":\"\u4e3b\u52a8\u4e0a\u62a5\u538b\u529b\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"29\"],\"dti\":[{\"id\":\"29\",\"name\":\"\u91cd\u542f\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"30\"],\"dti\":[{\"id\":\"30\",\"name\":\"\u8bbe\u7f6e\u5fc3\u8df3\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"heartbeat\",\"description\":\"\u5fc3\u8df3\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"31\"],\"dti\":[{\"id\":\"31\",\"name\":\"\u8bfb\u53d6\u5fc3\u8df3\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"heartbeat\",\"description\":\"\u5fc3\u8df3\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"35\"],\"dti\":[{\"id\":\"35\",\"name\":\"\u4e0b\u53d1\u5347\u7ea7\u901a\u77e5\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"port\",\"description\":\"\u7aef\u53e3\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"description\":\"IP\",\"elementName\":\"\u5347\u7ea7\u670d\u52a1\u5668IP\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"username\",\"description\":\"\u7528\u6237\u540d\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"password\",\"description\":\"\u5bc6\u7801\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"filename\",\"description\":\"\u5347\u7ea7\u6587\u4ef6\u540d\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1}]}]},{\"functionWord\":[\"36\"],\"dti\":[{\"id\":\"36\",\"name\":\"\u9000\u51fa\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1}]}]},{\"functionWord\":[\"37\"],\"dti\":[{\"id\":\"37\",\"name\":\"\u901a\u77e5\u6ce8\u9500\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1}]}]},{\"functionWord\":[\"34\"],\"dti\":[{\"id\":\"34\",\"name\":\"\u8bfb\u53d6\u8bbe\u5907\u7248\u672c\u53f7\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"version\",\"description\":\"\u7248\u672c\u53f7\",\"elementType\":\"VARCHAR2\",\"elementLen\":17,\"elementPrecision\":1}]}]}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("msg".equals(queueName)) {
            jsonMessage = "";
            jsonMessage = "{\"gatewayNo\":\"1\",\"unitNo\":\"002315110001\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"dataItems\":[{\"id\":\"1537\",\"data\":{\"desc\":\"\uff2e231\u65c1\u624b\u62a5\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"10\",\"deviceId\":\"050106\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"A201\u5bbf\u820d\u70df\u611f\",\"cnt\":\"15\",\"event\":\"01\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"11\",\"deviceId\":\"0A0201\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"A201\u5bbf\u820d\u70df\u611f\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"11\",\"deviceId\":\"0A0201\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"\u4e5d\u5c42\uff2e\u533a\u58f0\u5149\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"13\",\"deviceId\":\"050483\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("cmd".equals(queueName)) {
            jsonMessage = "{\"gatewayNo\":\"0001\",\"unitNo\":\"0001\",\"protocolNo\":\"0001\",\"functionWord\":\"010\",\"equipmentNo\":\"01212010\",\"SN\":\"000001\",\"dataItems\":[{\"id\":\"518\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}},{\"id\":\"519\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}},{\"id\":\"520\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("onLineCheck".equals(queueName)) {
            Unit databean = new Unit();
            JSONObject jObj = databean.getOnLineCheckData();
            msg = this.session.createObjectMessage();
            msg.setObject((Serializable)jObj);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        if ("register".equals(queueName)) {
            jsonMessage = "{\"gatewayNo\":\"1\",\"unitNo\":\"0000000000923041\",\"protocolNo\":\"1\",\"functionWord\":\"1\",\"SN\":\"1\",\"equipmentNo\":\"0\",\"dataItems\":[{\"id\":\"1\",\"data\":{\"ccid\":\"89860050191596018909\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public static void main(String[] args) throws JMSException, Exception {
        MsgSender sender = new MsgSender();
        String JSONString = "";
        String queueName = "";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384516D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"459\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F30392F32382030313A32353A343420312D393520B8D0D1CCBBF0BEAF20D2BBB2E3B4F3CCFCD1CCB8D0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3845E6D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"1\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"C6F4B6AF2031362F30392F32382031343A35303A313720312D31373720CFFBC5A5CAD6B6AF20D2BBC2A5CFFBBBF0CBA8B0B4C5A5202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F84E6E12C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"18\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F31302F30382031303A32323A303220352D383120CFFBC5A5B9CAD5CF20BDCCD1A7C2A5C1F9B6B034B2E3CFFBBBF0CBA8202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A38442702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"140\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"3136C4EA3131D4C23239C8D53231CAB13236B7D620D1CCB8D02020202020200A31BBFA3031C2B731323220BBF0BEAF202031B6B02031B2E3D7FAD7FAD7FAD7FA0A0A\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3844B6B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"5\",\"dataContent\":\"30332F30372030353A31352030392D30303820B9CAD5CFBBD6B8B420D2BBB2E332C7F8D1CCB8D0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F84EEE12C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"5\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"3030322D30313320CAE4B3F6C4A3BFE920CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1BEEDC1B1C3C50D0A3030322D30323320CAE4B3F6C4A3BFE920CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1B7C0BBF0B7A70D0A3030322D30353620B9E2B5E7B8D0D1CC20CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1D1CCB8D00D0A3030322D30373020B9E2B5E7B8D0D1CC20CDA8D1B6B9CAD5CF2031362D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F849C082C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"677\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"13\",\"dataContent\":\"31312D33302032323A323220B8D0D1CCCCBDB2E2C6F720302D30332D3631201B3804B2BFCEBBB9CAD5CF20\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3844F702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"20\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"380DCAC2BCFE3AC6F7BCFEB9CAD5CF0DB1E0BAC53A303030323230380DC0E0D0CD3ABCE0B9DCCAE4C8EB0DB5D8B5E33A3130B2E3D0C5BAC5B7A70DCAB1BCE43A323031362F31322F30362031363A31320D0D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384616D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"8\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F31302F32312031373A33303A333720B1B8B5E7B9CAD5CF00\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B9CAD5CF2020202020202020202020204946432D333033302020202020B5DA31BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020204E32543837202020202020202031383A31313A313820202020323031362D31322D370D0AB9CAD5CF2020202020202020202020204946432D333033302020202020B5DA33BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3843B6B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"434\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"16\",\"dataContent\":\"20202020202031303A34343A3239202031322C31322C32303136204E3030312020202020202020CFFBB7C0B1A8BEAF31BAC5D6F7BBFA2020202020202020202020202020CFB5CDB3B3F5CABCBBAF2020202020202020202020202020202020202020BBF0BEAFB9CAD5CFBCBAC7E5B3FD2020202020202020202020202020202000\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"444283677A3C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"5\",\"dataContent\":\"30332F30372030353A31352030392D30303820B9CAD5CFBBD6B8B4D2BBB2E332C7F8D1CCB8D000\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384256D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"2\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"7\",\"dataContent\":\"3631362F31322F32332031303A32310A1B39D6F7B5E7B9CAD5CF0A0A\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B9CAD5CF202020202020202020202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEACBBA4202020202020204E334C3244313820202020202032333A35303A323420202020323031372D312D330D0AB9CAD5CFB1A8BEAFBDE2B3FD20202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEAC\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B1A8BEAF202020202020202020202020BBF0BEAFBCE0CAD32020202020C9CCD2B5D6D0D0C4D2BBB2E33423CAD6B6AFB1A8BEAFB0B4C5A5B1A8BEAFBCE0CAD32028C9CCD2B5D6205A6F6E6520303031202020202020204E334C314D3238202020202020383A33383A33312020202020323031372D312D350D0AC6F4B6AF202020202020202020202020BCCCB5E7C6F720202020202020C9CCD2B5D6D0D0C4D2BBB2E33141454C312D31BEEDC1B1C8ABBDB5BFD8D6C62028C9CCD2B5D6D0D0C4205A6F6E652030\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3849D6C2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"36\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"8\",\"dataContent\":\"30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF20\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384256C2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"3\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"7\",\"dataContent\":\"1B401B31051B361B3931372F30332F30342031333A33343A32340A3030C2A53032B2E33030B7BFBCE40AD7A1D4BAB2BF000000000AD7DFB5C00000000000000AB9CAD5CF3A30363033330AB8D0D1CC0A1B4A011B39\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F8443082C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"9\",\"dataContent\":\"BBF0BEAF2030332D30372031363A33372030393130303520202020B5E3D0CDB8D0D1CCD6C7B3C7BBE1D2C7CAD2D5B9B0E5\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384996B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"3542\",\"dataItems\":[{\"id\":\"1025\",\"data\":{\"ret\":\"0\",\"dataType\":\"1025\",\"dataContent\":\"AA170613122832AA0400007F48487F04380808FF0808080000020CF08482FC04848484FC8484840400\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA48379372E\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"1401\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"170622151435\",\"event\":\"0\",\"indication\":\"73\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E31F239\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"1024\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"170721160545\",\"event\":\"0\",\"indication\":\"0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E3AD0D2\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"2304\",\"dataItems\":[{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"4\",\"dataType\":\"720\",\"dateTime\":\"170808173233\",\"event\":\"1\"}},{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"5\",\"dateTime\":\"170808173233\",\"event\":\"1\"}},{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"6\",\"dateTime\":\"170808173233\",\"event\":\"1\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"4\",\"unitNo\":\"83A41E31F239\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"4\",\"SN\":\"512\",\"dataItems\":[{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"1\",\"dataType\":\"1808\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"2\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"3\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"4\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"5\",\"alarmData\":\"278\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"6\",\"alarmData\":\"303\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"7\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"170922105929\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"8\",\"alarmData\":\"0\"},\"id\":\"1808\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E31F239\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"3\",\"SN\":\"1280\",\"dataItems\":[{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"1\",\"dataType\":\"1808\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"1\",\"lineNo\":\"2\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"3\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"3\",\"lineNo\":\"4\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"4\",\"lineNo\":\"5\",\"alarmData\":\"649\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"5\",\"lineNo\":\"6\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"7\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"171010151743\",\"ret\":\"0\",\"alarmStatus\":\"2\",\"lineNo\":\"8\",\"alarmData\":\"0\"},\"id\":\"1808\"}],\"enable\":\"0\"}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A20170401035\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"2401\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"171115000939\",\"event\":\"0\",\"indication\":\"8\"}}],\"enable\":\"0\"}";
        JSONString = "{\"rows\":[{\"dtu_no\":\"1EA48301512E\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"12559\",\"device_type\":\"\u6e29\u611f\",\"event\":\"\u901a\u8baf\u6545\u969c\",\"stamp\":\"2017-11-1604:21:28\",\"postion\":\"B3\u4e1c\u5317\u89d2\u8f66\u90531102.010.002a62945\",\"remarks\":\"\",\"oinfo\":\"\"}]}";
        queueName = "fireHostData";
        JSONString = "{\"rows\":[{\"dtu_no\":\"1EA483605A2E\",\"conn_point_no\":1,\"protocol_no\":1,\"device_no\":\"34-186\",\"device_type\":\"\u6d88\u706b\u6813\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2017-11-0812:49:00\",\"postion\":\"9\u680b1\u5c42\u6d88\u706b\u6813\",\"remarks\":\"\",\"oinfo\":\"[110812:4934-186\u706b\u8b66,9\u680b1\u5c42\u6d88\u706b\u6813]\"}]}";
        queueName = "fireHostData";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A20170401035\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"2401\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"171115000939\",\"event\":\"0\",\"indication\":\"8\"}}],\"enable\":\"0\"}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA483539A2E\",\"protocolNo\":\"1\",\"functionWord\":\"130\",\"equipmentNo\":\"0\",\"dataItems\":[{\"id\":\"130\",\"data\":{\"ret\":\"0\",\"ccid\":\"898602B9191790428925\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"44428333713C\",\"protocolNo\":\"1\",\"functionWord\":\"130\",\"equipmentNo\":\"0\",\"dataItems\":[{\"id\":\"130\",\"data\":{\"ret\":\"0\",\"ccid\":\"898602B5191750045026\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA4839E2630\",\"protocolNo\":\"1\",\"functionWord\":\"130\",\"equipmentNo\":\"0\",\"dataItems\":[{\"id\":\"130\",\"data\":{\"ret\":\"0\",\"ccid\":\"898602B9191790439372\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"4\",\"unitNo\":\"000000000001\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"1\",\"dataItems\":[{\"data\":{\"dateTime\":\"170921170900\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"1\",\"dataType\":\"1808\",\"alarmData\":\"16\"},\"id\":\"1808\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E3AD2FC\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"15\",\"SN\":\"30720\",\"dataItems\":[{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"dataType\":\"1808\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"1\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"2\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"3\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"4\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"266\",\"lineNo\":\"5\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"6\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"7\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"0\",\"dateTime\":\"171130000054\",\"alarmData\":\"0\",\"lineNo\":\"8\"}}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"4\",\"gatewayNo\":\"4\",\"unitNo\":\"83A41E3AD2FC\",\"deviceName\":\"83A41E3AD2FC\",\"functionWord\":\"1\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"data\":{\"heartBeat\":\"31\",\"dataType\":\"1\"},\"id\":\"1\"}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"4\",\"gatewayNo\":\"4\",\"unitNo\":\"83A41E3AD2FC\",\"deviceName\":\"83A41E3AD2FC\",\"functionWord\":\"9\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"data\":{\"dateTime\":\"171128214057\",\"remainingBattery\":\"94\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171128214057\",\"remainingBattery\":\"94\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"4\",\"gatewayNo\":\"4\",\"unitNo\":\"83A41E3AD2FC\",\"deviceName\":\"83A41E3AD2FC\",\"functionWord\":\"9\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"data\":{\"dateTime\":\"171128214057\",\"remainingBattery\":\"94\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"1\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171128214057\",\"remainingBattery\":\"94\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"2\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171128214057\",\"remainingBattery\":\"94\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"3\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA483AAF431\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"2391\",\"dataItems\":[{\"data\":{\"dateTime\":\"171204112736\",\"ret\":\"0\",\"dataType\":\"1793\",\"cnt\":\"0\",\"indication\":\"64\",\"event\":\"0\",\"desc\":\"\"},\"id\":\"1793\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"84218C32AA13\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"13\",\"SN\":\"46848\",\"dataItems\":[{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"dataType\":\"1808\",\"alarmStatus\":\"0\",\"dateTime\":\"171215230906\",\"alarmData\":\"149\",\"lineNo\":\"19\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"44428311773C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"768\",\"dataItems\":[{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"dataType\":\"1808\",\"alarmStatus\":\"0\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"1\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"2\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"3\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"4\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"1\",\"dateTime\":\"171218112557\",\"alarmData\":\"273\",\"lineNo\":\"5\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"6\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"7\"}},{\"id\":\"1808\",\"data\":{\"ret\":\"0\",\"alarmStatus\":\"2\",\"dateTime\":\"171218112557\",\"alarmData\":\"0\",\"lineNo\":\"8\"}}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"4\",\"gatewayNo\":\"4\",\"unitNo\":\"6471638933800000\",\"deviceName\":\"1590041095500000\",\"functionWord\":\"9\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171219114159\",\"remainingBattery\":\"99\",\"signalStrength\":\"4\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"10.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"4\",\"gatewayNo\":\"4\",\"unitNo\":\"6479515814700000\",\"deviceName\":\"1590041095500000\",\"functionWord\":\"9\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"data\":{\"dateTime\":\"171229174133\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174233\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174333\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174433\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174533\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174633\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174733\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174833\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229174933\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"},{\"data\":{\"dateTime\":\"171229175033\",\"remainingBattery\":\"99\",\"signalStrength\":\"1\",\"dataType\":\"9\",\"dataStatus\":\"0\",\"state\":\"0.0\",\"reverse\":\"00\",\"collectionInterval\":\"60\",\"dataUnit\":\"1\"},\"id\":\"9\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"11\",\"unitNo\":\"44428392AA3B\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"512\",\"dataItems\":[{\"data\":{\"dateTime\":\"180109161635\",\"ret\":\"0\",\"portNo\":\"50FA3119\",\"dataType\":\"722\",\"power\":\"100\",\"event\":\"1\"},\"id\":\"722\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA483AAF431\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"51\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"180119173014\",\"event\":\"0\",\"indication\":\"91\"}}],\"enable\":\"0\"}";
        queueName = "gwMonitor";
        JSONString = "{\"protocolNo\":1,\"gatewayNo\":11,\"functionWord\":600,\"data\":[{\"time\":1516693854723,\"data\":0},{\"time\":1516693856730,\"data\":0},{\"time\":1516693858737,\"data\":0},{\"time\":1516693860744,\"data\":0},{\"time\":1516693862756,\"data\":0},{\"time\":1516693864762,\"data\":0},{\"time\":1516693866772,\"data\":0},{\"time\":1516693868774,\"data\":0},{\"time\":1516693870779,\"data\":0},{\"time\":1516693872785,\"data\":0},{\"time\":1516693874793,\"data\":0}]}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"444283AFB63B\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"703\",\"dataItems\":[{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"1\",\"dataType\":\"720\",\"dateTime\":\"180124170732\",\"event\":\"1\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"11\",\"unitNo\":\"1EA483EF332E\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"9728\",\"dataItems\":[{\"data\":{\"dateTime\":\"180130050405\",\"ret\":\"0\",\"portNo\":\"50FA3119\",\"dataType\":\"722\",\"num\":\"1\",\"power\":\"100\",\"event\":\"0\"},\"id\":\"722\"}],\"enable\":\"0\"}";
        queueName = "loginOut";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"84218C33B862\",\"protocolNo\":\"1\",\"functionWord\":\"130\",\"equipmentNo\":\"0\",\"dataItems\":[{\"data\":{\"ret\":\"0\",\"ccid\":\"89860404191790515128\"},\"id\":\"130\"}],\"enable\":\"0\"}";
        queueName = "heartBeat";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"84218C33B862\",\"protocolNo\":\"1\",\"functionWord\":\"132\",\"equipmentNo\":\"0\",\"dataItems\":[{\"data\":{},\"id\":\"132\"}],\"enable\":\"0\"}";
        queueName = "fireHostData";
        JSONString = "{\"rows\":[{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0001\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:13\",\"postion\":\"\u4e00\u5355\u5143002\u533a008\u680b019\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:132018/02/06\u4e00\u5355\u5143002\u533a0001\u53f7008\u680b019\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0081\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:14\",\"postion\":\"\u4e8c\u5355\u5143003\u533a008\u680b003\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:142018/02/06\u4e8c\u5355\u5143003\u533a0081\u53f7008\u680b003\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0007\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:14\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b034\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:142018/02/06\u4e00\u5355\u5143005\u533a0007\u53f7005\u680b034\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0009\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:14\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b016\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:142018/02/06\u4e00\u5355\u5143005\u533a0009\u53f7005\u680b016\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0003\u53f7\",\"device_type\":\"\u672a\u5b9a\u4e49\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:18\",\"postion\":\"5012\u533a000\u680bB3\u5c42\u611f\u6e29\",\"remarks\":\"\",\"oinfo\":\"11:27:182018/02/065012\u533a0003\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u611f\u6e29------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0025\u53f7\",\"device_type\":\"\u672a\u5b9a\u4e49\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:18\",\"postion\":\"5013\u533a000\u680bB3\u5c42\u611f\u6e29\",\"remarks\":\"\",\"oinfo\":\"11:27:182018/02/065013\u533a0025\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u611f\u6e29------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0048\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:18\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:182018/02/06000\u533a0048\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0026\u53f7\",\"device_type\":\"\u672a\u5b9a\u4e49\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:18\",\"postion\":\"5013\u533a000\u680bB3\u5c42\u611f\u6e29\",\"remarks\":\"\",\"oinfo\":\"11:27:182018/02/065013\u533a0026\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u611f\u6e29------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0015\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:22\",\"postion\":\"2\u5355\u5143007\u533a005\u680b033\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:222018/02/062\u5355\u5143007\u533a0015\u53f7005\u680b033\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0082\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:22\",\"postion\":\"\u4e8c\u5355\u5143003\u533a008\u680b003\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:222018/02/06\u4e8c\u5355\u5143003\u533a0082\u53f7008\u680b003\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0021\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:22\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b032\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:222018/02/06\u4e00\u5355\u5143005\u533a0021\u53f7005\u680b032\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0027\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:23\",\"postion\":\"\u4e00\u5355\u5143001\u533a008\u680b030\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:232018/02/06\u4e00\u5355\u5143001\u533a0027\u53f7008\u680b030\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0030\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:27\",\"postion\":\"3\u5355\u5143009\u533a005\u680b031\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:272018/02/063\u5355\u5143009\u533a0030\u53f7005\u680b031\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0057\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:27\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:272018/02/06000\u533a0057\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0033\u53f7\",\"device_type\":\"\u672a\u5b9a\u4e49\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:27\",\"postion\":\"5013\u533a000\u680bB3\u5c42\u611f\u6e29\",\"remarks\":\"\",\"oinfo\":\"11:27:272018/02/065013\u533a0033\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u611f\u6e29------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0041\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:27\",\"postion\":\"3\u5355\u5143009\u533a005\u680b028\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:272018/02/063\u5355\u5143009\u533a0041\u53f7005\u680b028\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0021\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:32\",\"postion\":\"\u4e00\u5355\u5143001\u533a008\u680b014\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:322018/02/06\u4e00\u5355\u5143001\u533a0021\u53f7008\u680b014\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0033\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:32\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b030\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:322018/02/06\u4e00\u5355\u5143005\u533a0033\u53f7005\u680b030\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0030\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:32\",\"postion\":\"2\u5355\u5143007\u533a005\u680b031\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:322018/02/062\u5355\u5143007\u533a0030\u53f7005\u680b031\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0178\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:32\",\"postion\":\"\u4e8c\u5355\u5143003\u533a008\u680b012\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:322018/02/06\u4e8c\u5355\u5143003\u533a0178\u53f7008\u680b012\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0065\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:36\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:362018/02/06000\u533a0065\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0058\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:36\",\"postion\":\"3\u5355\u5143009\u533a005\u680b025\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:362018/02/063\u5355\u5143009\u533a0058\u53f7005\u680b025\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0200\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:36\",\"postion\":\"5013\u533a000\u680bB3\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:362018/02/065013\u533a0200\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0105\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:37\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:372018/02/06000\u533a0105\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0054\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:41\",\"postion\":\"\u4e00\u5355\u5143001\u533a008\u680b008\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:412018/02/06\u4e00\u5355\u5143001\u533a0054\u53f7008\u680b008\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0064\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:41\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b025\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:412018/02/06\u4e00\u5355\u5143005\u533a0064\u53f7005\u680b025\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0099\u53f7\",\"device_type\":\"\u624b\u52a8\u62a5\u8b66\",\"event\":\"\u624b\u52a8\u62a5\u8b66\",\"stamp\":\"2018-02-0611:27:41\",\"postion\":\"001\u533a008\u680b028\u5c42\u706b\u8b66\",\"remarks\":\"\",\"oinfo\":\"11:27:412018/02/06001\u533a0099\u53f7008\u680b028\u5c42\u706b\u8b66\u2014\u624b\u52a8\u62a5\u8b66------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0071\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:41\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b005\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:412018/02/06\u4e00\u5355\u5143005\u533a0071\u53f7005\u680b005\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0107\u53f7\",\"device_type\":\"\u624b\u52a8\u62a5\u8b66\",\"event\":\"\u624b\u52a8\u62a5\u8b66\",\"stamp\":\"2018-02-0611:27:46\",\"postion\":\"3\u5355\u5143009\u533a005\u680b032\u5c42\u706b\u8b66\",\"remarks\":\"\",\"oinfo\":\"11:27:462018/02/063\u5355\u5143009\u533a0107\u53f7005\u680b032\u5c42\u706b\u8b66\u2014\u624b\u52a8\u62a5\u8b66------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0206\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:46\",\"postion\":\"5013\u533a000\u680bB3\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:462018/02/065013\u533a0206\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0144\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:46\",\"postion\":\"3\u5355\u5143009\u533a005\u680b016\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:462018/02/063\u5355\u5143009\u533a0144\u53f7005\u680b016\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0116\u53f7\",\"device_type\":\"\u624b\u52a8\u62a5\u8b66\",\"event\":\"\u624b\u52a8\u62a5\u8b66\",\"stamp\":\"2018-02-0611:27:46\",\"postion\":\"3\u5355\u5143009\u533a005\u680b023\u5c42\u706b\u8b66\",\"remarks\":\"\",\"oinfo\":\"11:27:462018/02/063\u5355\u5143009\u533a0116\u53f7005\u680b023\u5c42\u706b\u8b66\u2014\u624b\u52a8\u62a5\u8b66------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0235\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:51\",\"postion\":\"000\u533a001\u680b004\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:512018/02/06000\u533a0235\u53f7001\u680b004\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0098\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:51\",\"postion\":\"2\u5355\u5143007\u533a005\u680b019\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:512018/02/062\u5355\u5143007\u533a0098\u53f7005\u680b019\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0077\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:51\",\"postion\":\"\u4e00\u5355\u5143001\u533a008\u680b004\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:512018/02/06\u4e00\u5355\u5143001\u533a0077\u53f7008\u680b004\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0081\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:51\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b022\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:512018/02/06\u4e00\u5355\u5143005\u533a0081\u53f7005\u680b022\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0172\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:56\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:562018/02/06000\u533a0172\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0001\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:56\",\"postion\":\"2\u5355\u5143008\u533a005\u680b001\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:562018/02/062\u5355\u5143008\u533a0001\u53f7005\u680b001\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0158\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:56\",\"postion\":\"3\u5355\u5143009\u533a005\u680b034\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:562018/02/063\u5355\u5143009\u533a0158\u53f7005\u680b034\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0164\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:27:56\",\"postion\":\"3\u5355\u5143009\u533a005\u680b031\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:27:562018/02/063\u5355\u5143009\u533a0164\u53f7005\u680b031\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0075\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:01\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b004\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:012018/02/06\u4e00\u5355\u5143005\u533a0075\u53f7005\u680b004\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0076\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:01\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b004\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:012018/02/06\u4e00\u5355\u5143005\u533a0076\u53f7005\u680b004\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0098\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:01\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b019\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:012018/02/06\u4e00\u5355\u5143005\u533a0098\u53f7005\u680b019\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0083\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:01\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b003\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:012018/02/06\u4e00\u5355\u5143005\u533a0083\u53f7005\u680b003\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0158\u53f7\",\"device_type\":\"\u672a\u5b9a\u4e49\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:05\",\"postion\":\"5013\u533a000\u680bB3\u5c42\u611f\u6e29\",\"remarks\":\"\",\"oinfo\":\"11:28:052018/02/065013\u533a0158\u53f7000\u680bB3\u5c42\u706b\u8b66\u2014\u611f\u6e29------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0191\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:05\",\"postion\":\"3\u5355\u5143009\u533a005\u680b018\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:052018/02/063\u5355\u5143009\u533a0191\u53f7005\u680b018\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0161\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:05\",\"postion\":\"3\u5355\u5143009\u533a005\u680b008\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:052018/02/063\u5355\u5143009\u533a0161\u53f7005\u680b008\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0023\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:05\",\"postion\":\"3\u5355\u5143009\u533a005\u680b013\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:052018/02/063\u5355\u5143009\u533a0023\u53f7005\u680b013\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0178\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:10\",\"postion\":\"\u4e00\u5355\u5143001\u533a008\u680b003\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:102018/02/06\u4e00\u5355\u5143001\u533a0178\u53f7008\u680b003\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0081\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:10\",\"postion\":\"000\u533a001\u680b001\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:102018/02/06000\u533a0081\u53f7001\u680b001\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0188\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:10\",\"postion\":\"\u4e00\u5355\u5143005\u533a005\u680b001\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:102018/02/06\u4e00\u5355\u5143005\u533a0188\u53f7005\u680b001\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0149\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:28:14\",\"postion\":\"3\u5355\u5143009\u533a005\u680b014\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:28:142018/02/063\u5355\u5143009\u533a0149\u53f7005\u680b014\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0142\u53f7\",\"device_type\":\"\u6d88\u706b\u6813\u5f00\u5173\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:29:00\",\"postion\":\"3\u5355\u5143009\u533a037\u680b017\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:29:002018/02/063\u5355\u5143009\u533a0142\u53f7037\u680b017\u5c42\u706b\u8b66\u2014\u6d88\u706b\u6813\u5f00\u5173------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0027\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:29:44\",\"postion\":\"000\u533a001\u680b015\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:29:442018/02/06000\u533a0027\u53f7001\u680b015\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0043\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:29:49\",\"postion\":\"3\u5355\u5143009\u533a005\u680b010\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:29:492018/02/063\u5355\u5143009\u533a0043\u53f7005\u680b010\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0029\u53f7\",\"device_type\":\"\u611f\u70df\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:30:16\",\"postion\":\"3\u5355\u5143009\u533a005\u680b013\u5c42\",\"remarks\":\"\",\"oinfo\":\"11:30:162018/02/063\u5355\u5143009\u533a0029\u53f7005\u680b013\u5c42\u706b\u8b66\u2014\u611f\u70df------------\"},{\"dtu_no\":\"444283107B3C\",\"conn_point_no\":1,\"protocol_no\":12,\"device_no\":\"0080\u53f7\",\"device_type\":\"\u603b\u7ebf\",\"event\":\"\u706b\u8b66\",\"stamp\":\"2018-02-0611:30:19\",\"postion\":\"3\u5355\u5143009\u533a005\u680b004\u5c42\u611f\u70df255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8255\u533a255\u680bB\u8a79\u53f7\u8054\u52a8\",\"remarks\":\"\",\"oinfo\":\"11:30:192018/02/063\u5355\u5143009\u533a0080\u53f7005\u680b004\u5c42\u706b\u8b66\u2014\u611f\u70df------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf255\u680bB\u8a79\ufffd????\u53f7\u8054\u52a8\u2014------------??:??:??????/??/??255\u533a\u603b\u7ebf...\"}]}";
        queueName = "loginOut";
        JSONString = "{\"gatewayNo\":\"3\",\"unitNo\":\"83A41E3AD1F7\",\"protocolNo\":\"3\",\"functionWord\":\"2\",\"equipmentNo\":\"0\",\"dataItems\":[{\"data\":{\"ret\":\"0\",\"ccid\":\"898602B9191790442952\"},\"id\":\"2\"}],\"enable\":\"0\"}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"84218C32A814\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"13\",\"SN\":\"21311\",\"dataItems\":[{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"1\",\"dataType\":\"1808\",\"alarmData\":\"6231\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"2\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"3\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"4\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"5\",\"alarmData\":\"136\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"6\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"7\",\"alarmData\":\"0\"},\"id\":\"1808\"},{\"data\":{\"dateTime\":\"180309202945\",\"ret\":\"0\",\"alarmStatus\":\"0\",\"lineNo\":\"8\",\"alarmData\":\"0\"},\"id\":\"1808\"}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA483AAF431\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"427\",\"dataItems\":[{\"data\":{\"dateTime\":\"180424235934\",\"ret\":\"0\",\"dataType\":\"1793\",\"cnt\":\"0\",\"indication\":\"151\",\"event\":\"0\",\"desc\":\"\"},\"id\":\"1793\"}],\"enable\":\"0\"}";
        queueName = "loginOut";
        JSONString = "{\"gatewayNo\":\"111\",\"protocolNo\":\"1\",\"functionWord\":\"130\",\"unitNo\":\"83CA66376971\",\"dataItems\":[{\"id\":\"130\",\"data\":{\"ccid\":\"89860317492038713382\"}}],\"enable\":\"0\",\"eventTime\":\"20180613T094304Z\",\"serviceId\":\"LoginJson\",\"deviceId\":\"8d09ccfe-03d0-43a7-a074-03a42afcb351\",\"gatewayId\":\"8d09ccfe-03d0-43a7-a074-03a42afcb351\"}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"11\",\"unitNo\":\"444283DAB03B\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"1280\",\"dataItems\":[{\"data\":{\"dateTime\":\"180702154305\",\"ret\":\"0\",\"portNo\":\"A4D5CBA2\",\"dataType\":\"722\",\"state\":\"1\",\"power\":\"100\",\"event\":\"4\"},\"id\":\"722\"},{\"data\":{\"dateTime\":\"180702154857\",\"ret\":\"0\",\"portNo\":\"450C036D\",\"state\":\"1\",\"power\":\"100\",\"event\":\"4\"},\"id\":\"722\"},{\"data\":{\"dateTime\":\"180702155941\",\"ret\":\"0\",\"portNo\":\"81921CFE\",\"state\":\"1\",\"power\":\"100\",\"event\":\"4\"},\"id\":\"722\"},{\"data\":{\"dateTime\":\"180705155852\",\"ret\":\"0\",\"portNo\":\"AB499D81\",\"dataType\":\"722\",\"num\":\"1\",\"state\":\"1\",\"power\":\"100\",\"event\":\"4\"},\"id\":\"722\"}],\"enable\":\"0\"}";
        JSONString = "{\"protocolNo\":\"1\",\"gatewayNo\":\"111\",\"functionWord\":\"176\",\"unitNo\":\"000000000001\",\"equipmentNo\":\"1\",\"SN\":\"1\",\"dataItems\":[{\"id\":\"1809\",\"data\":{\"dateTime\":\"180806101112\",\"hydraulic\":\"1.024\",\"signalStrength\":\"4\",\"temperature\":\"6.4\",\"liquidOverEvent\":\"3\",\"lowBatteryEvent\":\"0\",\"percent\":\"80\"}},{\"id\":\"1809\",\"data\":{\"dateTime\":\"180806101212\",\"hydraulic\":\"1.28\",\"signalStrength\":\"4\",\"temperature\":\"32.0\",\"liquidOverEvent\":\"3\",\"lowBatteryEvent\":\"0\",\"percent\":\"64\"}}],\"enable\":\"0\",\"eventTime\":\"20180511T155139Z\",\"serviceId\":\"Report\",\"deviceId\":\"f17019f3-c382-4bd4-a4df-3e336b8d0407\",\"gatewayId\":\"f17019f3-c382-4bd4-a4df-3e336b8d0407\"}";
        JSONString = "{\"gatewayNo\":\"111\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"unitNo\":\"848F503605F8\",\"equipmentNo\":\"0\",\"SN\":\"3840\",\"dataItems\":[{\"id\":\"1809\",\"data\":{\"dateTime\":\"180831151439\",\"hydraulic\":\"0.727\",\"signalStrength\":\"4\",\"temperature\":\"26.0\",\"liquidOverEvent\":\"0\",\"lowBatteryEvent\":\"0\",\"percent\":\"100\"}},{\"id\":\"1809\",\"data\":{\"dateTime\":\"180831153005\",\"hydraulic\":\"0.717\",\"signalStrength\":\"4\",\"temperature\":\"25.8\",\"liquidOverEvent\":\"1\",\"lowBatteryEvent\":\"0\",\"percent\":\"100\"}},{\"id\":\"1809\",\"data\":{\"dateTime\":\"180831154531\",\"hydraulic\":\"0.707\",\"signalStrength\":\"4\",\"temperature\":\"26.0\",\"liquidOverEvent\":\"2\",\"lowBatteryEvent\":\"0\",\"percent\":\"100\"}},{\"id\":\"1809\",\"data\":{\"dateTime\":\"180831152357\",\"hydraulic\":\"0.695\",\"signalStrength\":\"4\",\"temperature\":\"26.0\",\"liquidOverEvent\":\"3\",\"lowBatteryEvent\":\"0\",\"percent\":\"100\"}}],\"enable\":\"0\",\"eventTime\":\"20180831T233526Z\",\"serviceId\":\"Report\",\"deviceId\":\"12ec112b-a2cb-49bb-be81-bf7ec98a4261\",\"gatewayId\":\"12ec112b-a2cb-49bb-be81-bf7ec98a4261\"}";
        queueName = "loginOut";
        JSONString = "{\"gatewayNo\":\"3\",\"unitNo\":\"84218C302074\",\"protocolNo\":\"3\",\"functionWord\":\"2\",\"equipmentNo\":\"0\",\"dataItems\":[{\"data\":{\"ret\":\"1\",\"ccid\":\"898602B9191790442059\"},\"id\":\"2\"}],\"enable\":\"0\"}";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"unitNo\":\"44428318763C\",\"equipmentNo\":\"0\",\"SN\":\"24888\",\"dataItems\":[{\"id\":\"720\",\"data\":{\"dateTime\":\"180A12110154\",\"event\":\"1\",\"portNo\":\"1\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"unitNo\":\"44428318763C\",\"equipmentNo\":\"0\",\"SN\":\"24888\",\"dataItems\":[{\"id\":\"720\",\"data\":{\"dateTime\":\"181012110154\",\"event\":\"1\",\"portNo\":\"1\"}}],\"enable\":\"0\"}";
        JSONString = "{\"deviceId\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"eventTime\":\"20181102064023\",\"protocolNo\":\"7\",\"gatewayNo\":\"7\",\"unitNo\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"SN\":\"0\",\"functionWord\":\"176\",\"dataItems\":[{\"id\":7,\"data\":{\"status\":\"7\"}}]}";
        JSONString = "{\"deviceId\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"eventTime\":\"20181102064023\",\"protocolNo\":\"7\",\"gatewayNo\":\"7\",\"unitNo\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"SN\":\"0\",\"functionWord\":\"176\",\"dataItems\":[{\"id\":2,\"data\":{\"status\":\"2\"}}]}";
        JSONString = "{\"deviceId\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"eventTime\":\"20181101061239\",\"protocolNo\":\"6\",\"gatewayNo\":\"6\",\"dataItems\":[{\"id\":\"1\",\"data\":{\"smokeConc\":\"41\",\"tempValue\":\"28\",\"relativeHumidityValue\":\"0\",\"smokeBatteryPct\":\"100\",\"longitude\":\"1008981770\",\"latitude\":\"1017370378\",\"alarmStatus\":\"1\",\"iccid\":\"89861118252004176488\"}}],\"unitNo\":\"ab3d077b-453e-4770-a1be-929ad6c2d4e7\",\"SN\":\"0\",\"equipmentNo\":\"0\",\"functionWord\":\"176\"}";
        JSONString = "{\"deviceId\":\"fe93490f-84e2-4112-b337-f2ab4e2228a5\",\"eventTime\":\"20181226184536\",\"protocolNo\":\"1001\",\"gatewayNo\":\"1001\",\"dataItems\":[{\"id\":\"1\",\"data\":{\"smokeConc\":\"0\",\"tempValue\":\"64\",\"relativeHumidityValue\":\"0\",\"smokeBatteryPct\":\"98\",\"longitude\":\"1036831949\",\"latitude\":\"1045220557\",\"alarmStatus\":\"1\"}}],\"unitNo\":\"fe93490f-84e2-4112-b337-f2ab4e2228a5\",\"SN\":\"0\",\"equipmentNo\":\"0\",\"functionWord\":\"176\"}";
        JSONString = "{\"deviceId\":\"d03ed861-fc94-4521-8e40-d184b11b7731\",\"eventTime\":\"20190322060535\",\"protocolNo\":\"1003\",\"gatewayNo\":\"1003\",\"dataItems\":[{\"id\":\"1\",\"data\":{\"gasValue\":\"0\",\"gasStatus\":\"1\",\"alarmType\":\"7\",\"language\":\"0\",\"robotStatus\":\"2\",\"soundSize\":\"5\"}}],\"unitNo\":\"d03ed861-fc94-4521-8e40-d184b11b7731\",\"SN\":\"0\",\"equipmentNo\":\"0\",\"functionWord\":\"176\"}";
        JSONString = "{\"rows\":[{\"dtu_no\":\"1EA483F4F631\",\"conn_point_no\":1,\"protocol_no\":4,\"device_no\":\"089\u53f7\",\"device_type\":\"\u611f\u70df\u63a2\u6d4b\u5668\",\"event\":\"\u706b\u8b66\u8bb0\u5f55\",\"stamp\":\"2019-05-10 14:56:00\",\"postion\":\"\u70df\u611f\",\"remarks\":\"\",\"oinfo\":\"\u7c7b\u578b\uff1a\u611f\u70df\u63a2\u6d4b\u5668\u4f4d\u7f6e\uff1a\u70df\u611f\u65f6\u95f4\uff1a2019\u5e7405\u670810\u65e514\u65f656\u5206\u5730\u5740\uff1a089\u53f7No:001\u706b\u8b66\u8bb0\u5f55\"}]}";
        JSONString = "{\"deviceId\":\"40b50e22-5072-40a8-b4e5-38f325bcb9fb\",\"gatewayNo\":\"1001\",\"protocolNo\":\"1001\",\"functionWord\":\"2\",\"unitNo\":\"869505041038132\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"2\",\"data\":{\"ret\":\"3\"}}],\"enable\":\"0\"}";
        JSONString = "{\"deviceId\":\"fb5e605d-29ee-4de7-9e15-b25056d3775c\",\"unitNo\":\"8653520360227380\",\"protocolNo\":\"1004\",\"gatewayNo\":\"1004\",\"dataItems\":[{\"id\":1,\"data\":{\"workTime\":65498,\"iccid\":\"89861118282009948250\",\"romVersion\":1,\"version\":1,\"signalStrength\":24,\"battery\":\"3.5\",\"deviceType\":46,\"heartBeat\":2880,\"groupLen\":5,\"eventType\":242,\"readValue\":9,\"blueValue\":0}}],\"SN\":\"0\",\"equipmentNo\":\"0\",\"functionWord\":\"10\"}";
        JSONString = "{\"gatewayNo\":\"16\",\"protocolNo\":\"16\",\"functionWord\":\"4\",\"unitNo\":\"YG964041978904\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"4\",\"data\":{\"voltageLow\":0,\"signalStrength\":4}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"16\",\"protocolNo\":\"16\",\"functionWord\":\"9\",\"unitNo\":\"YG964041978904\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"9\",\"data\":{\"alarmCount\":1,\"acct\":\"123\",\"mt\":\"41\",\"q\":\"8\",\"status\":\"111\",\"gg\":\"10\",\"ccc\":\"100\",\"s\":\"0\",\"time\":\"000000000000\",\"appId\":\"00FFFFFFFFFFFFFF\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"16\",\"protocolNo\":\"16\",\"functionWord\":\"9\",\"unitNo\":\"YG861964042639539\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"9\",\"data\":{\"alarmCount\":1,\"acct\":\"123\",\"mt\":\"41\",\"q\":\"8\",\"status\":\"111\",\"gg\":\"10\",\"ccc\":\"100\",\"s\":\"0\",\"time\":\"000000000000\",\"appId\":\"00FFFFFFFFFFFFFF\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"15\",\"protocolNo\":\"15\",\"functionWord\":\"2\",\"unitNo\":\"0086007501051800\",\"equipmentNo\":\"0\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"0\",\"data\":{\"signalStrength\":27,\"leakage1\":20,\"leakage2\":30,\"leakage3\":40,\"leakage4\":50,\"electricEnergy\":0,\"voltageA\":6000,\"voltageB\":7000,\"voltageC\":8000,\"currentA\":6000,\"currentB\":7000,\"currentC\":8000,\"temperatureA\":100,\"temperatureB\":110,\"temperatureC\":120,\"temperatureN\":130,\"leakageAlarm1\":\"0\",\"leakageAlarm2\":\"0\",\"leakageAlarm3\":\"0\",\"leakageAlarm4\":\"0\",\"remainCurSensorStatus1\":\"1\",\"remainCurSensorStatus2\":\"1\",\"remainCurSensorStatus3\":\"1\",\"remainCurSensorStatus4\":\"1\",\"relayOutput\":\"0\",\"phaseError\":\"0\",\"phaseCPowerOff\":\"0\",\"phaseBPowerOff\":\"0\",\"phaseAPowerOff\":\"0\",\"currentCAlarm\":\"0\",\"currentBAlarm\":\"0\",\"currentAAlarm\":\"0\",\"tempNAlarm\":\"0\",\"tempCStatus\":\"1\",\"tempCAlarm\":\"0\",\"tempBStatus\":\"1\",\"tempBAlarm\":\"0\",\"tempAStatus\":\"1\",\"tempAAlarm\":\"0\",\"voltageCOverPressure\":\"0\",\"underVoltageC\":\"0\",\"voltageBOverPressure\":\"0\",\"underVoltageB\":\"0\",\"voltageAOverPressure\":\"0\",\"underVoltageA\":\"0\",\"leakageAlarm\":\"0\",\"dateTime\":\"190617081815\",\"hex\":\"01010F120811061301010086007501051800FFFF0200000000440007D20000001B00000000000014001E00280032000000000000177000001B5800001F400000177000001B5800001F400064006E00780082000F0002A8000F1208110613BE\"}}],\"enable\":\"0\",\"dateTime\":\"190617081815\"}";
        JSONString = "{\"gatewayNo\":\"10\",\"protocolNo\":\"10\",\"functionWord\":\"2\",\"unitNo\":\"888900000000011A\",\"equipmentNo\":\"0\",\"SN\":\"154\",\"dataItems\":[{\"id\":\"0\",\"data\":{\"signalStrength\":27,\"leakage\":\"119\",\"electricEnergy\":0,\"voltageA\":0,\"voltageB\":0,\"voltageC\":0,\"currentA\":0,\"currentB\":0,\"currentC\":0,\"temperatureA\":0,\"temperatureB\":0,\"temperatureC\":270,\"temperatureN\":0,\"remainCurSensorStatus\":\"0\",\"phaseAPowerOff\":\"1\",\"phaseBPowerOff\":\"1\",\"phaseCPowerOff\":\"1\",\"phaseError\":\"0\",\"relayOutput\":\"1\",\"tempNAlarm\":\"0\",\"tempNStatus\":\"1\",\"currentAAlarm\":\"0\",\"currentBAlarm\":\"0\",\"currentCAlarm\":\"0\",\"voltageCOverPressure\":\"0\",\"tempAAlarm\":\"0\",\"tempAStatus\":\"1\",\"tempBAlarm\":\"0\",\"tempBStatus\":\"1\",\"tempCAlarm\":\"0\",\"tempCStatus\":\"0\",\"leakageAlarm\":\"1\",\"underVoltageA\":\"0\",\"voltageAOverPressure\":\"0\",\"underVoltageB\":\"0\",\"voltageBOverPressure\":\"0\",\"underVoltageC\":\"0\",\"dateTime\":\"190816113610\",\"hex\":\"01013B2C0B1008130101888900000000011AFFFF02009A0131000007D20000001BFFFFFFFFFF00770000000000000000000000000000000000000000010E000000950228010A240B10081332\"}}],\"enable\":\"0\",\"dateTime\":\"190816114459\"}";
        JSONString = "{\"deviceId\":\"9a85ee22-3077-48fa-8ad0-d16e71118699\",\"unitNo\":\"8654620452314670\",\"protocolNo\":\"1004\",\"gatewayNo\":\"1004\",\"dataItems\":[{\"id\":1,\"data\":{\"workTime\":31603,\"iccid\":\"89861119238013994689\",\"romVersion\":1,\"version\":1,\"signalStrength\":6,\"battery\":\"3.6\",\"deviceType\":46,\"heartBeat\":2880,\"groupLen\":5,\"eventType\":242,\"readValue\":20,\"blueValue\":0}}],\"SN\":\"0\",\"equipmentNo\":\"0\",\"functionWord\":\"10\"}";
        queueName = "msg";
        sender.sendJSONStringMessage(queueName, JSONString);
        System.out.println(TimeUtil.getLocalTime() + "DTU\u4e0a\u4f20\u6570\u636e \u5b8c\u6bd5");
        sender.close();
    }
}

