/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromClob(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(clob.getCharacterStream());
        StringWriter writer = new StringWriter();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return writer.toString();
    }

    public static String getString(ResultSet rs, String fieldName) throws SQLException {
        return rs.getString(fieldName) == null ? "" : rs.getString(fieldName);
    }

    public static String getString(String getStringValue) throws SQLException {
        return getStringValue == null ? "" : getStringValue;
    }

    public static void rollBack(Connection con) {
        try {
            con.rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(Connection con, String sql) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = con.prepareStatement(sql);
            rs = pst.executeQuery();
        }
        catch (Throwable throwable) {
            DBUtil.closeDB(rs, pst, null);
            throw throwable;
        }
        DBUtil.closeDB(rs, pst, null);
        return DBUtil.getListFromRs(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> executeQuery(Connection con, String sql, Class<?> c) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = con.prepareStatement(sql);
            rs = pst.executeQuery();
        }
        catch (Throwable throwable) {
            DBUtil.closeDB(rs, pst, null);
            throw throwable;
        }
        DBUtil.closeDB(rs, pst, null);
        return DBUtil.getListFromRs(rs, c);
    }

    public static List<Map<String, Object>> getListFromRs(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < columns; ++i) {
                map.put(md.getColumnName(i + 1), DBUtil.getValueByType(rs, md.getColumnType(i + 1), md.getColumnName(i + 1)));
            }
            list.add(map);
        }
        return list;
    }

    public static List<Object> getListFromRs(ResultSet rs, Class<?> c) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            while (rs.next()) {
                Object o = DBUtil.initObjectFromRs(rs, c);
                list.add(o);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMapFromRs(ResultSet rs) throws SQLException {
        HashMap<String, String> hm = null;
        try {
            int colCnt = rs.getMetaData().getColumnCount();
            hm = new HashMap<String, String>();
            while (rs.next()) {
                for (int i = 1; i <= colCnt; ++i) {
                    hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), DBUtil.getString(rs.getString(i)));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMapFromRow(ResultSet rs) throws SQLException {
        HashMap<String, String> hm = null;
        try {
            int colCnt = rs.getMetaData().getColumnCount();
            hm = new HashMap<String, String>();
            for (int i = 1; i <= colCnt; ++i) {
                hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), DBUtil.getString(rs.getString(i)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getListMapFromRs(ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        Logger log = Logger.getLogger();
        try {
            HashMap<String, String> hm = null;
            int colCnt = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                hm = new HashMap<String, String>();
                for (int i = 1; i <= colCnt; ++i) {
                    hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), DBUtil.getString(rs.getString(i)));
                }
                list.add(hm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getListMapFromRs(ResultSet rs, boolean IsLowerCase) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        Logger log = Logger.getLogger();
        try {
            HashMap<String, String> hm = null;
            int colCnt = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                hm = new HashMap<String, String>();
                for (int i = 1; i <= colCnt; ++i) {
                    if (IsLowerCase) {
                        hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), DBUtil.getString(rs.getString(i)));
                        continue;
                    }
                    hm.put(rs.getMetaData().getColumnName(i), DBUtil.getString(rs.getString(i)));
                }
                list.add(hm);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getColumnCommentsMapFromRs(ResultSet rs) throws SQLException {
        HashMap<String, String> hm = null;
        try {
            int colCnt = rs.getMetaData().getColumnCount();
            hm = new HashMap<String, String>();
            for (int i = 1; i <= colCnt; ++i) {
                hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), rs.getMetaData().getColumnName(i).toLowerCase());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getListMapFromRsAndCloseRs(ResultSet rs) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        Logger log = Logger.getLogger();
        try {
            HashMap<String, String> hm = null;
            int colCnt = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                hm = new HashMap<String, String>();
                for (int i = 1; i <= colCnt; ++i) {
                    hm.put(rs.getMetaData().getColumnName(i).toLowerCase(), DBUtil.getString(rs.getString(i)));
                }
                list.add(hm);
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeRs(rs);
                throw throwable;
            }
            DBUtil.closeRs(rs);
        }
        DBUtil.closeRs(rs);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getListMapBySQL(Connection con, String sql) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = con.prepareStatement(sql);
            rs = pst.executeQuery();
        }
        catch (Throwable throwable) {
            DBUtil.closeDB(rs, pst, null);
            throw throwable;
        }
        DBUtil.closeDB(rs, pst, null);
        return DBUtil.getListMapFromRs(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getListMapBySQLCloseCon(Connection con, String sql) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = con.prepareStatement(sql);
            rs = pst.executeQuery();
        }
        catch (Throwable throwable) {
            DBUtil.closeDB(rs, pst, null);
            throw throwable;
        }
        DBUtil.closeDB(rs, pst, null);
        return DBUtil.getListMapFromRs(rs);
    }

    public static Object getFirstObjectFromRs(ResultSet rs, Class<?> c) throws SQLException {
        Object o = null;
        try {
            if (rs.next()) {
                o = DBUtil.initObjectFromRs(rs, c);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return o;
    }

    private static Object getValueByType(ResultSet rs, int type, String name) throws SQLException {
        switch (type) {
            case 2: {
                return rs.getLong(name);
            }
            case 12: {
                return rs.getString(name);
            }
            case 91: {
                return rs.getDate(name);
            }
            case 93: {
                return rs.getTimestamp(name);
            }
            case 4: {
                return rs.getInt(name);
            }
            case 8: {
                return rs.getDouble(name);
            }
            case 6: {
                return Float.valueOf(rs.getFloat(name));
            }
        }
        return rs.getObject(name);
    }

    public static Object initObjectFromRs(ResultSet rs, Class<?> c) throws InstantiationException, SQLException, IllegalAccessException {
        Method[] methods;
        Object o = c.newInstance();
        for (Method m : methods = o.getClass().getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            try {
                m.invoke(o, DBUtil.getParamValueFromRs(rs, m));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("IllegalArgumentException:" + e + "\nMethods:" + m.getName());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("InvocationTargetException:" + e + "\nMethods:" + m.getName());
            }
        }
        return o;
    }

    private static Object getParamValueFromRs(ResultSet rs, Method m) throws SQLException {
        String fieldName = m.getName().substring(3);
        Type type = m.getGenericParameterTypes()[0];
        return DBUtil.getValueFromRs(rs, fieldName, type);
    }

    private static Object getValueFromRs(ResultSet rs, String fieldName, Type t) throws SQLException {
        String type = t.toString();
        try {
            if (type.equals("int") || type.equals("class java.lang.Integer")) {
                return rs.getInt(fieldName);
            }
            if (type.equals("class java.lang.String")) {
                return rs.getString(fieldName);
            }
            if (type.equals("class java.sql.Timestamp")) {
                return rs.getTimestamp(fieldName);
            }
            if (type.equals("class java.sql.Date")) {
                return rs.getDate(fieldName);
            }
            if (type.equals("class java.sql.Time")) {
                return rs.getTime(fieldName);
            }
            if (type.equals("long") || type.equals("class java.lang.Long")) {
                return rs.getLong(fieldName);
            }
            if (type.equals("double") || type.equals("class java.lang.Double")) {
                return rs.getDouble(fieldName);
            }
            if (type.equals("float") || type.equals("class java.lang.Float")) {
                return Float.valueOf(rs.getFloat(fieldName));
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQLException when get field:" + fieldName + "\n" + e);
        }
        throw new RuntimeException("getValueFromRsByField fail, field type is:" + type + ",field name is:" + fieldName);
    }

    public static void closeRs(ResultSet ... rss) {
        for (ResultSet rs : rss) {
            if (rs == null) continue;
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closePst(Statement ... psts) {
        for (Statement pst : psts) {
            if (pst == null) continue;
            try {
                pst.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeCon(Connection ... cons) {
        for (Connection con : cons) {
            if (con == null) continue;
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeDB(ResultSet rs, Statement st, Connection con) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

