/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterStr {
    public static String filterNumber(String number) {
        number = number.replaceAll("[^(0-9)]", "");
        return number;
    }

    public static String filterAlphabet(String alph) {
        alph = alph.replaceAll("[^(A-Za-z)]", "");
        return alph;
    }

    public static String filterChinese(String chin) {
        chin = chin.replaceAll("[^(\\u4e00-\\u9fa5)]", "");
        return chin;
    }

    public static String filter(String character) {
        character = character.replaceAll("[^(a-zA-Z0-9\\u4e00-\\u9fa5)]", "");
        return character;
    }

    public static String filterInvisibleCharacter(String character) {
        character = character.replaceAll("[^0-9a-zA-Z\u4e00-\u9fa5. \uff0c:/\\_,\u3002\\-\uff1f\u201c\u201d]+", "");
        return character;
    }

    public static String removeAlphabet(String alphabet) {
        return alphabet.replaceAll("[A-Za-z]", "");
    }

    public static String filterDigital(String digital) {
        return digital.replaceAll("[0-9]", "");
    }

    public static String removeChinese(String chin) {
        return chin.replaceAll("[\\u4e00-\\u9fa5]", "");
    }

    public static String filterAll(String character) {
        return character.replaceAll("[a-zA-Z0-9\\u4e00-\\u9fa5]", "");
    }

    public static void main(String[] args) {
        String you = "^&^&^you123$%$%\u4f60\u597d";
        you = FilterStr.filterNumber(you);
        System.out.println("\u8fc7\u6ee4\u51fa\u6570\u5b57\uff1a" + you);
        String hai = "\uffe5%\u2026\u20264556ahihdjsadhj$%$%\u4f60\u597d\u5417wewewe";
        hai = FilterStr.filterAlphabet(hai);
        System.out.println("\u8fc7\u6ee4\u51fa\u5b57\u6bcd\uff1a" + hai);
        String dong = "$%$%$\u5f20\u4e0934584yuojk\u674e\u56db@#\uffe5#%%\uffe5\u2026\u2026%&";
        dong = FilterStr.filterChinese(dong);
        System.out.println("\u8fc7\u6ee4\u51fa\u4e2d\u6587\uff1a" + dong);
        String str = "$%$%$\u5f20\u4e0934584yuojk\u674e\u56db@#\uffe5#%%\uffe5\u2026\u2026%&";
        str = FilterStr.filter(str);
        System.out.println("\u8fc7\u6ee4\u51fa\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e2d\u6587\uff1a" + str);
        str = "hello\u4f60\u597d\u5417,\u6211\u5f88\u597d thank you";
        String reg = "[\u2e80-\u9fff]";
        Pattern pat = Pattern.compile(reg);
        Matcher mat = pat.matcher(str);
        String repickStr = mat.replaceAll("");
        System.out.println("\u8fc7\u6ee4\u4e2d\u6587\u540e: " + repickStr);
        System.out.println("-----------------");
        System.out.println("removeAlphabet\u7ed3\u679c:" + FilterStr.removeAlphabet("123abc\u4f60\u597d"));
        System.out.println("filterDigital\u7ed3\u679c:" + FilterStr.filterDigital("123abc\u4f60\u597d"));
        System.out.println("removeChinese\u7ed3\u679c:" + FilterStr.removeChinese("123abc\u4f60\u597d"));
        System.out.println("filterAll\u7ed3\u679c:" + FilterStr.filterAll("123abc\u4f60\u597d"));
        str = "$%$%$\u5f20 \u4e0934\\/:5-8_4yuojk\u674e  \u56db@#\uffe5#%%\uffe5\u2026\u2026%&";
        System.out.println("\u8fc7\u6ee4\u5185\u5bb9\u53ea\u4fdd\u7559\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u4e2d\u6587\u3001\u6807\u70b9\u7b26\u53f7:" + FilterStr.filterInvisibleCharacter(str));
    }
}

