/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import java.util.Stack;

public class HexUtil {
    private static String clearBlank(String str) {
        StringBuilder s = new StringBuilder(str);
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') continue;
            s.deleteCharAt(i);
            --i;
        }
        return s.toString();
    }

    public static String hexToString(String hex) {
        byte[] bs = HexUtil.hexToBytes(hex);
        return new String(bs);
    }

    public static String stringToHexString(String str) {
        StringBuilder sb = new StringBuilder(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char v = str.charAt(i);
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexToBytes(String hex) {
        hex = HexUtil.clearBlank(hex);
        int len = hex.length() / 2;
        byte[] bs = new byte[len];
        for (int i = 0; i < len; ++i) {
            String sub = hex.substring(2 * i, 2 * i + 2);
            int v = Integer.valueOf(sub, 16);
            bs[i] = (byte)v;
        }
        return bs;
    }

    public static String byteToHexStr(byte[] bs) {
        return HexUtil.byteToHexStr(bs, bs.length);
    }

    public static String byteToHexStr(byte[] bs, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            byte b = bs[i];
            String str = Integer.toHexString(b);
            if (str.length() == 1) {
                sb.append("0").append(str);
                continue;
            }
            if (str.length() > 2) {
                sb.append(str.substring(str.length() - 2));
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static boolean equals(byte[] bs1, byte[] bs2) {
        if (bs1.length != bs2.length) {
            return false;
        }
        for (int i = 0; i < bs1.length; ++i) {
            if (bs1[i] == bs2[i]) continue;
            return false;
        }
        return true;
    }

    public static String toHexStr(byte b) {
        String str = Integer.toHexString(b);
        if (str.length() == 1) {
            return "0" + str;
        }
        if (str.length() > 2) {
            return str.substring(str.length() - 2);
        }
        return str;
    }

    public static String toHexStr(short v) {
        byte[] bs = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return HexUtil.byteToHexStr(bs);
    }

    public static String toHexStr(int v) {
        byte[] bs = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return HexUtil.byteToHexStr(bs);
    }

    public static String baseString(int num, int base) {
        if (base > 16) {
            throw new RuntimeException("\u8fdb\u5236\u6570\u8d85\u51fa\u8303\u56f4\uff0cbase<=16");
        }
        StringBuffer str = new StringBuffer("");
        String digths = "0123456789ABCDEF";
        Stack<Character> s = new Stack<Character>();
        while (num != 0) {
            s.push(Character.valueOf(digths.charAt(num % base)));
            num /= base;
        }
        while (!s.isEmpty()) {
            str.append(s.pop());
        }
        return str.toString();
    }

    public static String baseNum(String num, int srcBase, int destBase) {
        if (srcBase == destBase) {
            return num;
        }
        String digths = "0123456789ABCDEF";
        char[] chars = num.toCharArray();
        int len = chars.length;
        if (destBase == 10) {
            int n = 0;
            for (int i = len - 1; i >= 0; --i) {
                n = (int)((double)n + (double)digths.indexOf(chars[i]) * Math.pow(srcBase, len - i - 1));
            }
            return n + "";
        }
        num = HexUtil.baseNum(num, srcBase, 10);
        return HexUtil.baseString(Integer.valueOf(num), destBase);
    }

    public static String toBinaryString(int v) {
        return Integer.toBinaryString(v);
    }

    public static String toOctalString(int v) {
        return Integer.toOctalString(v);
    }

    public static String toHexString(int v) {
        return Integer.toHexString(v);
    }

    public static int toDecimalString(String v, int srcBase) {
        return Integer.valueOf(v, srcBase);
    }

    public static int toDecimalString(String v, int beginIndex, int endIndex, int srcBase) {
        if (v.length() < endIndex) {
            endIndex = v.length();
        }
        v = v.substring(beginIndex, endIndex);
        return Integer.valueOf(v, srcBase);
    }

    public static boolean isOctNumber(String str) {
        boolean flag = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (!(c == '0' | c == '1' | c == '2' | c == '3' | c == '4' | c == '5' | c == '6' | c == '7' | c == '8' | c == '9')) continue;
            flag = true;
        }
        return flag;
    }

    public static boolean isHexNumber(String str) {
        char cc;
        boolean flag = false;
        for (int i = 0; i < str.length() && ((cc = str.charAt(i)) == '0' || cc == '1' || cc == '2' || cc == '3' || cc == '4' || cc == '5' || cc == '6' || cc == '7' || cc == '8' || cc == '9' || cc == 'A' || cc == 'B' || cc == 'C' || cc == 'D' || cc == 'E' || cc == 'F' || cc == 'a' || cc == 'b' || cc == 'c' || cc == 'c' || cc == 'd' || cc == 'e' || cc == 'f'); ++i) {
            flag = true;
        }
        return flag;
    }

    public static boolean isOctNumberRex(String str) {
        String validate = "\\d+";
        return str.matches(validate);
    }

    public static boolean isHexNumberRex(String str) {
        String validate = "(?i)[0-9a-f]+";
        return str.matches(validate) && str.length() % 2 == 0;
    }

    public static void main(String[] args) {
        System.out.println("\u5341\u8f6c\u4e8c\uff1a" + Integer.toBinaryString(120));
        System.out.println("\u5341\u8f6c\u516b\uff1a" + Integer.toOctalString(120));
        System.out.println("\u5341\u8f6c\u5341\u516d\uff1a" + Integer.toHexString(120));
        System.out.println("\u4e8c\u8f6c\u5341\uff1a" + Integer.valueOf("1010", 2));
        System.out.println("\u516b\u8f6c\u5341\uff1a" + Integer.valueOf("125", 8));
        System.out.println("\u5341\u516d\u8f6c\u5341\uff1a" + Integer.valueOf("ABCDEF", 16));
        System.out.println("\u5341\u516d\u8f6c\u5341\uff1a" + Integer.valueOf("0b", 16));
        System.out.println("\u5341\u516d\u8f6c\u5341\uff1a" + HexUtil.baseString(16, 2));
        System.out.println("\u5341\u516d\u8f6c\u5341\uff1a" + HexUtil.toDecimalString("0b", 16));
        System.out.println("\u5341\u516d\u8f6c\u5341\uff1a" + "123".substring(0, 2));
        String deviceId = "0F082A";
        deviceId = HexUtil.toDecimalString(deviceId, 0, 2, 16) + "-" + HexUtil.toDecimalString(deviceId, 2, 4, 16) + "-" + HexUtil.toDecimalString(deviceId, 4, 6, 16);
        System.out.println("deviceId\uff1a" + deviceId);
    }
}

