/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    public static String post(String url, Map<String, String> params) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String value = e.getValue();
                if (value == null || "".equals(value) || "null".equals(value)) continue;
                paramList.add(new BasicNameValuePair(e.getKey(), e.getValue()));
            }
        }
        UrlEncodedFormEntity reqEntity = new UrlEncodedFormEntity(paramList, Charset.forName("UTF-8"));
        httpPost.setEntity((HttpEntity)reqEntity);
        String result = (String)httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new IOException("Unexpected response status: " + status);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String jsonBody) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String body = "{\"code\":100,\"info\":\"\u63d0\u4ea4\u5931\u8d25\uff01\"}";
        try {
            httpClient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(requestConfig);
            if (StringUtils.isNotBlank(jsonBody)) {
                httpPost.setEntity((HttpEntity)new StringEntity(jsonBody));
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                String string = body;
                HttpClient.close(httpClient, response);
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            HttpClient.close(httpClient, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            HttpClient.close(httpClient, response);
        }
        return body;
    }

    private static void close(CloseableHttpClient httpClient, CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, List<NameValuePair> nvps) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String body = "{\"code\":100,\"info\":\"\u63d0\u4ea4\u5931\u8d25\uff01\"}";
        try {
            Object reqEntity;
            httpClient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(requestConfig);
            if (nvps != null && !nvps.isEmpty()) {
                reqEntity = new UrlEncodedFormEntity(nvps, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)reqEntity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                reqEntity = body;
                HttpClient.close(httpClient, response);
                return reqEntity;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            HttpClient.close(httpClient, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            HttpClient.close(httpClient, response);
        }
        return body;
    }
}

