/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.Util;
import java.io.IOException;
import java.util.Properties;

public class PropertiesUtils {
    private static final String MQ_CONFIG_FILE_PATH = "config/mq.properties";
    private static final String WEB_CONFIG_FILE_PATH = "config/web.properties";
    private static final String REDIS_CONFIG_FILE_PATH = "config/redis.properties";
    private static final String QUARTZ_CONFIG_FILE_PATH = "config/quartz.properties";
    private static final String MAIL_CONFIG_FILE_PATH = "config/mail.properties";
    private static Properties mq_properties;
    private static Properties web_properties;
    private static Properties redis_properties;
    private static Properties quartz_properties;
    private static Properties mail_properties;

    public static Properties getMqProperty() {
        return mq_properties;
    }

    public static String getMqProperty(String key) {
        return mq_properties.getProperty(key);
    }

    public static String getMqProperty(String key, String defaultValue) {
        return mq_properties.getProperty(key, defaultValue);
    }

    public static Properties getWebProperty() {
        return web_properties;
    }

    public static String getWebProperty(String key) {
        return web_properties.getProperty(key);
    }

    public static Properties getRedisProperties() {
        return redis_properties;
    }

    public static String getRedisProperties(String key) {
        return redis_properties.getProperty(key);
    }

    public static Properties getQuartzProperties() {
        return quartz_properties;
    }

    public static String getQuartzProperties(String key) {
        return quartz_properties.getProperty(key);
    }

    public static Properties getMailProperties() {
        return mail_properties;
    }

    public static String getMailProperties(String key) {
        return mail_properties.getProperty(key);
    }

    static {
        try {
            mq_properties = Util.loadProperties(MQ_CONFIG_FILE_PATH);
            web_properties = Util.loadProperties(WEB_CONFIG_FILE_PATH);
            redis_properties = Util.loadProperties(REDIS_CONFIG_FILE_PATH);
            mail_properties = Util.loadProperties(MAIL_CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

