/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.TimeUtil;
import java.io.File;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.sql.rowset.serial.SerialClob;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final String[] PADDING = new String[65535];
    static final char DBC_CHAR_START = '!';
    static final char DBC_CHAR_END = '~';
    static final char SBC_CHAR_START = '\uff01';
    static final char SBC_CHAR_END = '\uff5e';
    static final int CONVERT_STEP = 65248;
    static final char SBC_SPACE = '\u3000';
    static final char DBC_SPACE = ' ';
    private static String[] pattern;
    private static String[] cPattern;
    private static String[] cfPattern;
    private static String ZEOR;

    public static String getMaxSubString(String s1, String s2) {
        int n;
        if (s1.length() > s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        int index = 0;
        block0: for (n = s1.length(); n > 0; --n) {
            for (int i = 0; i < s1.length() - n + 1; ++i) {
                String s = s1.substring(i, i + n);
                if (s2.indexOf(s) == -1) continue;
                index = i;
                break block0;
            }
        }
        return s1.substring(index, index + n);
    }

    public static String interceptStringByByte(String str, int len, String elide) {
        int elideLen;
        if (str == null) {
            return EMPTY;
        }
        byte[] strByte = str.getBytes();
        int strLen = strByte.length;
        int n = elideLen = elide.trim().length() == 0 ? 0 : elide.getBytes().length;
        if (len >= strLen || len < 1) {
            return str;
        }
        if (len - elideLen > 0) {
            len -= elideLen;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            byte value = strByte[i];
            if (value >= 0) continue;
            ++count;
        }
        if (count % 2 != 0) {
            len = len == 1 ? len + 1 : len - 1;
        }
        return new String(strByte, 0, len) + elide.trim();
    }

    public static String appendZero(String n) {
        return ("00" + n).substring(("00" + n).length() - 2);
    }

    public static String leftAppendZero(String instr, int length) {
        for (int i = instr.getBytes().length; i < length; ++i) {
            instr = "0" + instr;
        }
        return instr;
    }

    public static String rightAppendBlank(String instr, int length) {
        if (instr.getBytes().length > length) {
            instr = StringUtils.interceptStringByByte(instr, length, EMPTY);
        }
        for (int i = instr.getBytes().length; i < length; ++i) {
            instr = instr + " ";
        }
        return instr;
    }

    public static double roundHalf(double value, int n) {
        BigDecimal bDec = new BigDecimal(value);
        if (n < 0) {
            n = 0;
        }
        bDec = bDec.setScale(n, 6);
        value = bDec.doubleValue();
        return value;
    }

    public static String formatDec(String str) {
        int iPoint = str.indexOf(".");
        int iLen = str.length();
        String temp = EMPTY;
        if (iLen < 4) {
            return str;
        }
        if (iPoint < 0) {
            iPoint = 0;
        } else {
            iLen = iPoint;
        }
        for (int i = 3; i < iLen; ++iLen, i += 3) {
            temp = str.substring(iLen - i);
            str = str.substring(0, iLen - i) + ",";
            str = str + temp;
            ++i;
        }
        return str;
    }

    public static String unFormatDec(String str) {
        str = str.replaceAll(",", EMPTY);
        return str;
    }

    public static String replaceRadixPoint(String str) {
        str = str.replaceAll("\\.", EMPTY);
        return str;
    }

    public static boolean splitBygb2312(byte[] sourceByte, int index) {
        int i = 0;
        while (i < index && i < sourceByte.length) {
            if (sourceByte[i] < 0) {
                i += 2;
                continue;
            }
            ++i;
        }
        return i == index;
    }

    public static byte[] getByteSubStr(byte[] sourceByte, int beginIndex, int endIndex) {
        if (!StringUtils.splitBygb2312(sourceByte, beginIndex)) {
            --beginIndex;
        }
        if (!StringUtils.splitBygb2312(sourceByte, endIndex)) {
            --endIndex;
        }
        int length = endIndex - beginIndex;
        byte[] resultByte = null;
        if (sourceByte.length > endIndex) {
            resultByte = new byte[length];
            for (int i = 0; i < length; ++i) {
                resultByte[i] = sourceByte[beginIndex + i];
            }
        } else {
            length = sourceByte.length - beginIndex;
            resultByte = new byte[length];
            for (int i = 0; i < length; ++i) {
                resultByte[i] = sourceByte[beginIndex + i];
            }
        }
        return resultByte;
    }

    public static String getSubStrByByte(String sourcestr, int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        String tempstr = new String(StringUtils.getByteSubStr(sourcestr.getBytes(), beginIndex, endIndex));
        for (int i = tempstr.getBytes().length; i < length; ++i) {
            tempstr = tempstr + " ";
        }
        return tempstr;
    }

    public static String getSubStrByByteLength(String sourcestr, int beginIndex, int endIndex, int length) {
        String tempstr = new String(StringUtils.getByteSubStr(sourcestr.getBytes(), beginIndex, endIndex));
        for (int i = tempstr.getBytes().length; i < length; ++i) {
            tempstr = tempstr + " ";
        }
        return tempstr;
    }

    public static String replaceBySubtle(String source, String oldStr, String newStr) {
        return StringUtils.replace(source, oldStr, newStr, true);
    }

    public static String replace(String source, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(source, delim);
        String restr = EMPTY;
        while (tokenizer.hasMoreTokens()) {
            restr = restr + tokenizer.nextToken();
        }
        return restr;
    }

    public static String replace(String source, String oldStr, String newStr, boolean matchCase) {
        if (source == null) {
            return null;
        }
        if (source.toLowerCase().indexOf(oldStr.toLowerCase()) == -1) {
            return source;
        }
        int findStartPos = 0;
        int a = 0;
        while (a > -1) {
            String strB;
            String strA;
            int b = 0;
            String str1 = source;
            String str2 = str1.toLowerCase();
            String str3 = oldStr;
            String str4 = str3.toLowerCase();
            if (matchCase) {
                strA = str1;
                strB = str3;
            } else {
                strA = str2;
                strB = str4;
            }
            if ((a = strA.indexOf(strB, findStartPos)) <= -1) continue;
            b = oldStr.length();
            findStartPos = a + b;
            StringBuffer bbuf = new StringBuffer(source);
            source = bbuf.replace(a, a + b, newStr) + EMPTY;
            findStartPos = findStartPos + newStr.length() - b;
        }
        return source;
    }

    public double getDouble2Number(double d) {
        DecimalFormat df1 = new DecimalFormat("###0.00");
        double dd = Double.parseDouble(df1.format(d));
        return dd;
    }

    public static double getDistance(double startlon, double startlat, double endlon, double endlat) {
        double arc2degree = 57.29577951308232;
        double lon2length = 111320.590351;
        double lat2length = 110947.089891;
        DecimalFormat df1 = new DecimalFormat("###0.000");
        double lonrate = Math.cos((startlat + endlat) / (2.0 + arc2degree));
        double deltalon = (startlon - endlon) * lon2length * lonrate;
        double deltalat = (startlat - endlat) * lat2length;
        return Double.parseDouble(df1.format(Math.sqrt(Math.pow(deltalon, 2.0) + Math.pow(deltalat, 2.0)) / 1000.0));
    }

    public static double getDegree(double startlon, double startlat, double endlon, double endlat) {
        double deltalon = startlon - endlon;
        double deltalat = startlat - endlat;
        double degree = 0.0;
        if (deltalat == 0.0) {
            degree = deltalon >= 0.0 ? 90.0 : 270.0;
        } else {
            degree = Math.atan(Math.abs(deltalon / deltalat)) * 180.0 / 3.14159255358;
            if (deltalat < 0.0 && deltalon >= 0.0) {
                degree = 180.0 - degree;
            } else if (deltalat < 0.0 && deltalon < 0.0) {
                degree = 180.0 + degree;
            } else if (deltalat > 0.0 && deltalon <= 0.0) {
                degree = 360.0 - degree;
            }
        }
        return degree;
    }

    public static String ChangCourse(String course) {
        double icourse = Double.parseDouble(course);
        String scourse = EMPTY;
        if (icourse == 0.0 || icourse == 360.0) {
            scourse = "\u5411\u5317";
        } else if (icourse > 0.0 && icourse <= 30.0) {
            scourse = "\u5317\u504f\u4e1c";
        } else if (icourse > 30.0 && icourse <= 60.0) {
            scourse = "\u4e1c\u5317";
        } else if (icourse > 60.0 && icourse < 90.0) {
            scourse = "\u4e1c\u504f\u5317";
        } else if (icourse == 90.0) {
            scourse = "\u5411\u4e1c";
        } else if (icourse > 90.0 && icourse <= 120.0) {
            scourse = "\u4e1c\u504f\u5357";
        } else if (icourse > 120.0 && icourse <= 150.0) {
            scourse = "\u4e1c\u5357";
        } else if (icourse > 150.0 && icourse < 180.0) {
            scourse = "\u5357\u504f\u4e1c";
        } else if (icourse == 180.0) {
            scourse = "\u5411\u5357";
        } else if (icourse > 180.0 && icourse <= 210.0) {
            scourse = "\u5357\u504f\u897f";
        } else if (icourse > 210.0 && icourse <= 240.0) {
            scourse = "\u897f\u5357";
        } else if (icourse > 240.0 && icourse < 270.0) {
            scourse = "\u897f\u504f\u5357";
        } else if (icourse == 270.0) {
            scourse = "\u5411\u897f";
        } else if (icourse > 270.0 && icourse <= 300.0) {
            scourse = "\u897f\u504f\u5317";
        } else if (icourse > 300.0 && icourse <= 330.0) {
            scourse = "\u897f\u5317";
        } else if (icourse > 330.0 && icourse < 360.0) {
            scourse = "\u5317\u504f\u897f";
        }
        return scourse;
    }

    public boolean isChinese(String s) {
        String pattern = "[\u4e00-\u9fa5]+";
        Pattern p = Pattern.compile(pattern);
        Matcher result = p.matcher(s);
        return result.find();
    }

    public static boolean isNumStr(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNum(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumericString(String str) {
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericStr(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException ne) {
            return false;
        }
        return true;
    }

    public static String ChangCourseCH(double icourse) {
        String scourse = EMPTY;
        if (icourse == 0.0 || icourse == 360.0) {
            scourse = "\u5411\u5317";
        } else if (icourse > 0.0 && icourse <= 30.0) {
            scourse = "\u5317\u504f\u4e1c";
        } else if (icourse > 30.0 && icourse <= 60.0) {
            scourse = "\u4e1c\u5317";
        } else if (icourse > 60.0 && icourse < 90.0) {
            scourse = "\u4e1c\u504f\u5317";
        } else if (icourse == 90.0) {
            scourse = "\u5411\u4e1c";
        } else if (icourse > 90.0 && icourse <= 120.0) {
            scourse = "\u4e1c\u504f\u5357";
        } else if (icourse > 120.0 && icourse <= 150.0) {
            scourse = "\u4e1c\u5357";
        } else if (icourse > 150.0 && icourse < 180.0) {
            scourse = "\u5357\u504f\u4e1c";
        } else if (icourse == 180.0) {
            scourse = "\u5411\u5357";
        } else if (icourse > 180.0 && icourse <= 210.0) {
            scourse = "\u5357\u504f\u897f";
        } else if (icourse > 210.0 && icourse <= 240.0) {
            scourse = "\u897f\u5357";
        } else if (icourse > 240.0 && icourse < 270.0) {
            scourse = "\u897f\u504f\u5357";
        } else if (icourse == 270.0) {
            scourse = "\u5411\u897f";
        } else if (icourse > 270.0 && icourse <= 300.0) {
            scourse = "\u897f\u504f\u5317";
        } else if (icourse > 300.0 && icourse <= 330.0) {
            scourse = "\u897f\u5317";
        } else if (icourse > 330.0 && icourse < 360.0) {
            scourse = "\u5317\u504f\u897f";
        }
        return scourse;
    }

    public String replaceHtmlCode(String content) {
        if (StringUtils.isEmpty(content)) {
            return EMPTY;
        }
        String[] eventKeywords = new String[]{"onmouseover", "onmouseout", "onmousedown", "onmouseup", "onmousemove", "onclick", "ondblclick", "onkeypress", "onkeydown", "onkeyup", "ondragstart", "onerrorupdate", "onhelp", "onreadystatechange", "onrowenter", "onrowexit", "onselectstart", "onload", "onunload", "onbeforeunload", "onblur", "onerror", "onfocus", "onresize", "onscroll", "oncontextmenu"};
        content = StringUtils.replace(content, "<script", "&ltscript", false);
        content = StringUtils.replace(content, "</script", "&lt/script", false);
        content = StringUtils.replace(content, "<marquee", "&ltmarquee", false);
        content = StringUtils.replace(content, "</marquee", "&lt/marquee", false);
        content = StringUtils.replace(content, "\r\n", "<BR>");
        for (int i = 0; i < eventKeywords.length; ++i) {
            content = StringUtils.replace(content, eventKeywords[i], "_" + eventKeywords[i], false);
        }
        return content;
    }

    public static String replaceHtmlToText(String input) {
        if (StringUtils.isEmpty(input)) {
            return EMPTY;
        }
        return StringUtils.setBr(StringUtils.setTag(input));
    }

    public static String setTag(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            if (s.charAt(i) == '<') {
                stringbuffer.append("&lt");
                continue;
            }
            if (s.charAt(i) == '>') {
                stringbuffer.append("&gt");
                continue;
            }
            if (s.charAt(i) == '&') {
                stringbuffer.append("&amp");
                continue;
            }
            stringbuffer.append(s.charAt(i));
        }
        return stringbuffer.toString();
    }

    public static String setBr(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            if (s.charAt(i) == '\n') {
                stringbuffer.append(EMPTY);
                continue;
            }
            if (s.charAt(i) == '\r') {
                stringbuffer.append(EMPTY);
                continue;
            }
            stringbuffer.append(s.charAt(i));
        }
        return stringbuffer.toString();
    }

    public static String setNbsp(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        for (int i = 0; i < j; ++i) {
            if (s.charAt(i) == ' ') {
                stringbuffer.append("&nbsp;");
                continue;
            }
            stringbuffer.append(s.charAt(i));
        }
        return stringbuffer.toString();
    }

    public static boolean isAllNumeric(String input) {
        if (StringUtils.isEmpty(input)) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            char charAt = input.charAt(i);
            if (charAt >= '0' && charAt <= '9') continue;
            return false;
        }
        return true;
    }

    public static String toChi(String input) {
        try {
            byte[] bytes = input.getBytes("ISO8859-1");
            return new String(bytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String replaceSql(String input) {
        return StringUtils.replace(input, "'", "''");
    }

    public static String encode(String value) {
        if (StringUtils.isEmpty(value)) {
            return EMPTY;
        }
        return URLEncoder.encode(value);
    }

    public static String decode(String value) {
        if (StringUtils.isEmpty(value)) {
            return EMPTY;
        }
        return URLDecoder.decode(value);
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() <= 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmptyString(String input) {
        boolean bl;
        boolean bl2 = bl = input != null && !EMPTY.equals(input.trim()) && !"null".equals(input);
        return bl;
    }

    public String smilies(String temp) {
        if (StringUtils.isEmpty(temp)) {
            return EMPTY;
        }
        temp = StringUtils.replace(temp, "/:)", "<IMG border=0 SRC=images/brow/regular_smile.gif>");
        temp = StringUtils.replace(temp, "/:d", "<IMG border=0 SRC=images/brow/teeth_smile.gif>");
        temp = StringUtils.replace(temp, "/:o", "<IMG border=0 SRC=images/brow/omg_smile.gif>");
        temp = StringUtils.replace(temp, "/:p", "<IMG border=0 SRC=images/brow/tounge_smile.gif>");
        temp = StringUtils.replace(temp, "/;)", "<IMG border=0 SRC=images/brow/wink_smile.gif>");
        temp = StringUtils.replace(temp, "/:(", "<IMG border=0 SRC=images/brow/sad_smile.gif>");
        temp = StringUtils.replace(temp, "/:s", "<IMG border=0 SRC=images/brow/confused_smile.gif>");
        temp = StringUtils.replace(temp, "/:|", "<IMG border=0 SRC=images/brow/whatchutalkingabout_smile.gif>");
        temp = StringUtils.replace(temp, "/:$", "<IMG border=0 SRC=images/brow/embaressed_smile.gif>");
        return temp;
    }

    public static String getExtension(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1).toLowerCase();
        }
        return EMPTY;
    }

    public static String getPrefix(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return EMPTY;
    }

    public String request(HttpServletRequest request, String fieldName) {
        if (request.getMethod().equalsIgnoreCase("POST")) {
            return StringUtils.toChi(request.getParameter(fieldName));
        }
        return StringUtils.toChi(request.getParameter(fieldName));
    }

    public String request1(HttpServletRequest request, String fieldName) {
        String s = this.request(request, fieldName);
        if (s == null) {
            return EMPTY;
        }
        return s;
    }

    public String requestSql(HttpServletRequest request, String fieldName) {
        return this.replaceSql(this.request1(request, fieldName));
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return EMPTY;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(name)) continue;
            return StringUtils.decode(cookie.getValue());
        }
        return EMPTY;
    }

    public static String[] getParameterValues(HttpServletRequest request, String name) {
        if (request.getMethod().equalsIgnoreCase("POST")) {
            return request.getParameterValues(name);
        }
        String[] values = request.getParameterValues(name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = StringUtils.toChi(values[i]);
            }
        }
        return values;
    }

    public static void deleteFile(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtils.isEmpty(filePath) && !StringUtils.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            file.delete();
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0 || "null".equalsIgnoreCase(str)) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String clean(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String stripToNull(String str) {
        if (str == null) {
            return null;
        }
        return (str = StringUtils.strip(str, null)).length() == 0 ? null : str;
    }

    public static String stripToEmpty(String str) {
        return str == null ? EMPTY : StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(str, stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int strsLen;
        if (strs == null || (strsLen = strs.length) == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newArr[i] = StringUtils.strip(strs[i], stripChars);
        }
        return newArr;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static int indexOf(String str, char searchChar) {
        if (StringUtils.isEmpty(str)) {
            return -1;
        }
        return str.indexOf(searchChar);
    }

    public static int indexOf(String str, char searchChar, int startPos) {
        if (StringUtils.isEmpty(str)) {
            return -1;
        }
        return str.indexOf(searchChar, startPos);
    }

    public static int indexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.indexOf(searchStr);
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    public static int indexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (searchStr.length() == 0 && startPos >= str.length()) {
            return str.length();
        }
        return str.indexOf(searchStr, startPos);
    }

    public static int lastIndexOf(String str, char searchChar) {
        if (StringUtils.isEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(searchChar);
    }

    public static int lastIndexOf(String str, char searchChar, int startPos) {
        if (StringUtils.isEmpty(str)) {
            return -1;
        }
        return str.lastIndexOf(searchChar, startPos);
    }

    public static int lastIndexOf(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr);
    }

    public static int lastIndexOf(String str, String searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return str.lastIndexOf(searchStr, startPos);
    }

    public static boolean contains(String str, char searchChar) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static int indexOfAny(String str, char[] searchChars) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty((char[])searchChars)) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchChars.length; ++j) {
                if (searchChars[j] != ch) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String str, String searchChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(str, searchChars.toCharArray());
    }

    public static int indexOfAnyBut(String str, char[] searchChars) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty((char[])searchChars)) {
            return -1;
        }
        block0: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchChars.length; ++j) {
                if (searchChars[j] == ch) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(String str, String searchChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (searchChars.indexOf(str.charAt(i)) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsOnly(String str, char[] valid) {
        if (valid == null || str == null) {
            return false;
        }
        if (str.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(str, valid) == -1;
    }

    public static boolean containsOnly(String str, String validChars) {
        if (str == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(str, validChars.toCharArray());
    }

    public static boolean containsNone(String str, char[] invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        int strSize = str.length();
        int validSize = invalidChars.length;
        for (int i = 0; i < strSize; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < validSize; ++j) {
                if (invalidChars[j] != ch) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(String str, String invalidChars) {
        if (str == null || invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(str, invalidChars.toCharArray());
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.indexOf(search)) == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int lastIndexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = -1;
        int tmp = 0;
        for (int i = 0; i < sz; ++i) {
            String search = searchStrs[i];
            if (search == null || (tmp = str.lastIndexOf(search)) <= ret) continue;
            ret = tmp;
        }
        return ret;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBetween(String str, String tag) {
        return StringUtils.substringBetween(str, tag, tag);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String getNestedString(String str, String tag) {
        return StringUtils.substringBetween(str, tag, tag);
    }

    public static String getNestedString(String str, String open, String close) {
        return StringUtils.substringBetween(str, open, close);
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String concatenate(Object[] array) {
        return StringUtils.join(array, null);
    }

    public static String join(Object[] array) {
        return StringUtils.join(array, null);
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                buf.append(obj);
            }
            if (separator == null || !iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String deleteSpaces(String str) {
        if (str == null) {
            return null;
        }
        return CharSetUtils.delete((String)str, (String)" \t\r\n\b");
    }

    public static String deleteWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || StringUtils.isEmpty(repl) || with == null || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceChars.length()) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String overlayString(String text, String overlay, int start, int end) {
        return new StringBuffer(start + overlay.length() + text.length() - end + 1).append(text.substring(0, start)).append(overlay).append(text.substring(end)).toString();
    }

    public static String overlay(String str, String overlay, int start, int end) {
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return new StringBuffer(len + start - end + overlay.length() + 1).append(str.substring(0, start)).append(overlay).append(str.substring(end)).toString();
    }

    public static String chomp(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String chomp(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (str.endsWith(separator)) {
            return str.substring(0, str.length() - separator.length());
        }
        return str;
    }

    public static String chompLast(String str) {
        return StringUtils.chompLast(str, "\n");
    }

    public static String chompLast(String str, String sep) {
        if (str.length() == 0) {
            return str;
        }
        String sub = str.substring(str.length() - sep.length());
        if (sep.equals(sub)) {
            return str.substring(0, str.length() - sep.length());
        }
        return str;
    }

    public static String getChomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx == str.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str.substring(idx);
        }
        return EMPTY;
    }

    public static String prechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(idx + sep.length());
        }
        return str;
    }

    public static String getPrechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx + sep.length());
        }
        return EMPTY;
    }

    public static String chop(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str) {
        int lastIdx = str.length() - 1;
        if (lastIdx <= 0) {
            return EMPTY;
        }
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String escape(String str) {
        return StringEscapeUtils.escapeJava((String)str);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.padding(repeat, str.charAt(0));
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                char ch = str.charAt(0);
                char[] output1 = new char[outputLength];
                for (int i = repeat - 1; i >= 0; --i) {
                    output1[i] = ch;
                }
                return new String(output1);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuffer buf = new StringBuffer(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    private static String padding(int repeat, char padChar) {
        String pad = PADDING[padChar];
        if (pad == null) {
            pad = String.valueOf(padChar);
        }
        while (pad.length() < repeat) {
            pad = pad.concat(pad);
        }
        StringUtils.PADDING[padChar] = pad;
        return pad.substring(0, repeat);
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(StringUtils.padding(pads, padChar));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String center(String str, int size) {
        return StringUtils.center(str, size, ' ');
    }

    public static String center(String str, int size, char padChar) {
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, strLen + pads / 2, padChar);
        str = StringUtils.rightPad(str, size, padChar);
        return str;
    }

    public static String center(String str, int size, String padStr) {
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return str;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str;
        }
        str = StringUtils.leftPad(str, strLen + pads / 2, padStr);
        str = StringUtils.rightPad(str, size, padStr);
        return str;
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String capitalise(String str) {
        return StringUtils.capitalize(str);
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String uncapitalise(String str) {
        return StringUtils.uncapitalize(str);
    }

    public static String swapCase(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(strLen);
        char ch = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str) {
        return WordUtils.capitalize((String)str);
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static int toInt(String str, int defaultvalue) {
        int reint = 0;
        if (StringUtils.isEmpty(str)) {
            reint = defaultvalue;
        }
        try {
            reint = Integer.parseInt(str);
        }
        catch (NumberFormatException ne) {
            reint = defaultvalue;
        }
        return reint;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (CharUtils.isAsciiPrintable((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultString(String str) {
        return str == null ? EMPTY : str;
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuffer(str).reverse().toString();
    }

    public static String reverseDelimited(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtils.split(str, separatorChar);
        ArrayUtils.reverse((Object[])strs);
        return StringUtils.join(strs, separatorChar);
    }

    public static String reverseDelimitedString(String str, String separatorChars) {
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtils.split(str, separatorChars);
        ArrayUtils.reverse((Object[])strs);
        if (separatorChars == null) {
            return StringUtils.join(strs, ' ');
        }
        return StringUtils.join(strs, separatorChars);
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtils.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + StringUtils.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = StringUtils.indexOfDifference(str1, str2);
        if (at == -1) {
            return EMPTY;
        }
        return str2.substring(at);
    }

    public static int indexOfDifference(String str1, String str2) {
        int i;
        if (str1.equals(str2)) {
            return -1;
        }
        if (str1 == null || str2 == null) {
            return 0;
        }
        for (i = 0; i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i); ++i) {
        }
        if (i < str2.length() || i < str1.length()) {
            return i;
        }
        return -1;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int j;
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = StringUtils.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static String iso2gbk(String isostr) {
        try {
            byte[] byteStr = isostr.getBytes("ISO8859-1");
            String gbkStr = new String(byteStr, "GBK");
            return gbkStr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String gbk2iso(String gbkstr) {
        try {
            byte[] byteStr = gbkstr.getBytes("GB2312");
            String isoStr = new String(byteStr, "ISO8859-1");
            return isoStr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String UnicodeToChinese(String s, boolean iffilter) {
        if (iffilter) {
            try {
                if (s == null || s.equals(EMPTY)) {
                    return EMPTY;
                }
                String newstring = null;
                newstring = new String(s.getBytes("ISO8859_1"), "gb2312");
                return newstring;
            }
            catch (UnsupportedEncodingException e) {
                return s;
            }
        }
        return s;
    }

    public static String ChineseToUnicode(String s, boolean iffilter) {
        if (iffilter) {
            try {
                if (s == null || s.equals(EMPTY)) {
                    return EMPTY;
                }
                String newstring = null;
                newstring = new String(s.getBytes("gb2312"), "ISO8859_1");
                return newstring;
            }
            catch (UnsupportedEncodingException e) {
                return s;
            }
        }
        return s;
    }

    public static String toUtf8String(String s, boolean iffilter) {
        if (iffilter) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                byte[] b;
                char c = s.charAt(i);
                if (c >= '\u0000' && c <= '\u00ff') {
                    sb.append(c);
                    continue;
                }
                try {
                    b = Character.toString(c).getBytes("utf-8");
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    b = new byte[]{};
                }
                for (int j = 0; j < b.length; ++j) {
                    int k = b[j];
                    if (k < 0) {
                        k += 256;
                    }
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                }
            }
            return sb.toString();
        }
        return s;
    }

    public static String encodingFileName(String fileName) {
        String returnFileName = EMPTY;
        try {
            returnFileName = URLEncoder.encode(fileName, "UTF-8");
            returnFileName = StringUtils.replace(returnFileName, "+", "%20", false);
            if (returnFileName.length() > 150) {
                returnFileName = new String(fileName.getBytes("GB2312"), "ISO8859-1");
                returnFileName = StringUtils.replace(returnFileName, " ", "%20", false);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return returnFileName;
    }

    public static boolean IsSafeCharacters(String str) {
        boolean returnVal = true;
        char[] unSafeChar = new char[]{'&', ';', '\'', '\\', '\"', '|', '*', '?', '~', '^', '<', '>', '(', ')', '[', ']', '{', '}', '$'};
        for (int i = 0; i < unSafeChar.length; ++i) {
            if (str.indexOf(unSafeChar[i]) == -1) continue;
            returnVal = returnVal;
        }
        return returnVal;
    }

    public static boolean IsUnlawfulCharacter(String s, String[] UnlawfulCharacter) {
        boolean bl = false;
        for (int j = 0; j < UnlawfulCharacter.length; ++j) {
            if (s.indexOf(UnlawfulCharacter[j]) <= -1) continue;
            System.out.println("[" + UnlawfulCharacter[j] + "]-----------\u975e\u6cd5\u5b57\u7b26!");
            if (!bl) {
                // empty if block
            }
            bl = true;
        }
        return bl;
    }

    public static String FillingZero(String code, int number) {
        String returncode = code.trim();
        while (returncode.length() < number) {
            returncode = "0" + returncode;
        }
        return returncode;
    }

    public static Clob stringToClob(String str) {
        if (null == str) {
            return null;
        }
        try {
            SerialClob c = new SerialClob(str.toCharArray());
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(65535);
        Reader clobStream = null;
        try {
            clobStream = clob.getCharacterStream();
            char[] b = new char[60000];
            int i = 0;
            while ((i = clobStream.read(b)) != -1) {
                sb.append(b, 0, i);
            }
        }
        catch (Exception ex) {
            sb = null;
        }
        finally {
            try {
                if (clobStream != null) {
                    clobStream.close();
                }
            }
            catch (Exception exception) {}
        }
        if (sb == null) {
            return null;
        }
        return sb.toString();
    }

    public static String arrayToString(String[] Arr) {
        if (Arr == null || Arr.length < 1) {
            return EMPTY;
        }
        String reStr = EMPTY;
        for (int i = 0; i < Arr.length; ++i) {
            reStr = reStr + Arr[i] + ",";
        }
        if (reStr.length() > 0) {
            reStr = reStr.substring(0, reStr.length() - 1);
        }
        return reStr;
    }

    public static String[] splitByChar(String str, char splitchar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < len) {
            if (str.charAt(i) == splitchar) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        if (start != i) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitByString(String str, String splitchar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < len) {
            if (str.charAt(i) == splitchar.charAt(0)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        if (start != i) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getStringValue(HashMap hm, String name) {
        if (hm.get(name) != null) {
            return String.valueOf(hm.get(name));
        }
        return EMPTY;
    }

    public static int getIntValue(HashMap hm, String name) {
        if (hm.get(name) != null && !EMPTY.equals(hm.get(name))) {
            return Integer.parseInt(String.valueOf(hm.get(name)));
        }
        return 0;
    }

    public static Date getDateValue(HashMap hm, String name) {
        if (hm.get(name) != null && !EMPTY.equals(hm.get(name)) && !"null".equals(hm.get(name))) {
            return Date.valueOf(String.valueOf(hm.get(name)));
        }
        return null;
    }

    public static double getDoubleValue(HashMap hm, String name) {
        if (hm.get(name) != null && !EMPTY.equals(hm.get(name))) {
            return Double.parseDouble(String.valueOf(hm.get(name)));
        }
        return 0.0;
    }

    public static long getLongValue(HashMap hm, String name) {
        if (hm.get(name) != null && !EMPTY.equals(hm.get(name))) {
            return Long.parseLong(String.valueOf(hm.get(name)));
        }
        return 0L;
    }

    public static String[] stringSplit(String srcStr) {
        String[] temp;
        String str = "\u6253\u5370\u673a*\u949f\u8868//\u81ea\u884c\u8f66**\u96e8\u4f1e%%\u6536\u97f3\u673a??\u7535\u8111 \u6c34\u676f \u98ce\u6247";
        str = "03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f\u000b03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f";
        for (String word : temp = srcStr.split("%%|\\*+|\\//|\\?+|\\ +|\\\u000b+")) {
            System.out.println(word);
        }
        return temp;
    }

    public static String[] stringSplit(String srcStr, String pattern) {
        String str = "\u6253\u5370\u673a*\u949f\u8868//\u81ea\u884c\u8f66**\u96e8\u4f1e%%\u6536\u97f3\u673a??\u7535\u8111 \u6c34\u676f \u98ce\u6247";
        str = "03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f\u000b03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f";
        String[] temp = srcStr.split(pattern);
        return temp;
    }

    public static HashMap stringToHashMap(String mapText) {
        String str = "{UNIT_STATE_ID=228, UNIT_ID=41208, FLOOR_ID=2887, BUILDING_ID=142}";
        HashMap<String, String> hm = new HashMap<String, String>();
        if (mapText != null) {
            String[] temp;
            for (String word : temp = StringUtils.StringFilterNoWithCommaMinusSign(mapText).split("%%|\\*+|\\//|\\?+|\\ +|\\\u000b+|\\,+")) {
                String[] tmpArr = word.split("\\=");
                System.out.println(tmpArr[0].trim() + "=" + tmpArr[1].trim());
                hm.put(tmpArr[0].trim(), tmpArr[1].trim());
            }
        }
        return hm;
    }

    public static HashMap mapStringToHashMap(String mapText) {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (mapText != null) {
            String[] temp;
            mapText = mapText.substring(1, mapText.length() - 1);
            for (String word : temp = mapText.split(",")) {
                String[] tmpArr = word.split("\\=");
                System.out.println(tmpArr[0] + "=" + tmpArr[1]);
                hm.put(tmpArr[0].trim(), tmpArr[1].trim());
            }
        }
        return hm;
    }

    public static HashMap JSONObjectStringToHashMap(String mapText) {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (mapText != null) {
            JSONObject jobj = JSONObject.fromObject((Object)mapText);
            Iterator it = jobj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = jobj.getString(key);
                hm.put(key.trim(), value);
            }
        }
        return hm;
    }

    public static HashMap stringToHashMap(String mapText, String splitSign, String equalSign) {
        String str = "[\u767b\u5f55-1;\u9000\u5f55-2;\u706b\u8b66-10;\u6545\u969c-11;\u56de\u7b54-12;\u590d\u4f4d-13;\u901a\u4fe1\u6545\u969c-14]";
        HashMap<String, String> hm = new HashMap<String, String>();
        if (mapText != null) {
            String[] temp;
            for (String word : temp = StringUtils.StringFilterNoWithCommaMinusSign(mapText).split("%%|\\*+|\\//|\\?+|\\ +|\\\u000b+|\\" + splitSign + "+")) {
                String[] tmpArr = word.split("\\" + equalSign + EMPTY);
                System.out.println(tmpArr[0] + "=" + tmpArr[1]);
                hm.put(tmpArr[0], tmpArr[1]);
            }
        }
        return hm;
    }

    public static String StringFilter(String str) {
        String regEx = "[`~!@#$%^&*()+ =|{}':;',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoColon(String str) {
        String regEx = "[`~!@#$%^&*()+ =|{}';',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoStar(String str) {
        String regEx = "[`~!@#$%^&()+ =|{}':;',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoStarAndQuestionMark(String str) {
        String regEx = "[`~!@$%^&()+ =|{}':;',\\-\\[\\].<>/~\uff01@\uffe5%\u2026\u2026&\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoStarAndQuestionAndBlankMark(String str) {
        String regEx = "[`~!@$%^&()+=|{}':;',\\-\\[\\].<>/~\uff01@\uffe5%\u2026\u2026&\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoWithCommaMinusSign(String str) {
        String regEx = "[`~!@#$%^&*()+ |{}':'\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoWithComma(String str) {
        String regEx = "[`~!@#$%^&*()+ |{}':;'\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoWithSemicolonAndEquals(String str) {
        String regEx = "[`~!@#$%^&*()+ |{}':'\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterNoWithSpace(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\-\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterWithEquals(String str) {
        String regEx = "[`~!@#$%^&*()+|{}':;',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u001b]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static String StringFilterSpecificCharacter(String str) {
        String regEx = "\u5730\u5740\uff1a|No.|No.001|No:001|\u65f6\u95f4\uff1a|\u4f4d\u7f6e\uff1a|\u63cf\u8ff0\uff1a|\u63cf\u8ff0\uff1a|\u7c7b\u578b\uff1a|\u4e8b\u4ef6:|\u7c7b\u578b:|\u5730\u70b9:|\u7f16\u53f7:|\u4e8b\u4ef6|\u7f16\u53f7|\u7c7b\u578b|\u5730\u70b9|\u65f6\u95f4:|\u4f4d\u7f6e";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(" ").trim();
    }

    public static String StringFilterSpecificCharacter(String regEx, String str) {
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(EMPTY).trim();
    }

    public static JSONObject dealData(String data, String date_regexp, String deviceid_regexp, String dateFormat, String timeFormat) {
        String date = "2015-01-01 01:01:01";
        Timestamp stamp = null;
        String deviceid = "0";
        String eventTypeName = EMPTY;
        String unitType = EMPTY;
        String postion = ".";
        Pattern p = null;
        Matcher m = null;
        JSONObject obj = new JSONObject();
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("\u7535\u6c60\u7535\u538b\u8fc7\u4f4e\u544a\u8b66");
        ls.add("\u6c34\u538b\u4e0d\u8fbe\u6807\u544a\u8b66");
        ls.add("\u6c34\u538b\u6062\u590d\u62a5\u544a");
        ls.add("\u7535\u6c60\u7535\u538b\u6062\u590d");
        ls.add("\u8bbe\u5907\u76d6\u88ab\u6253\u5f00");
        ls.add("\u6c34\u4f4d\u8d85\u4e0a\u9650");
        ls.add("\u6c34\u4f4d\u8d85\u4e0b\u9650");
        ls.add("\u8bbe\u5907\u76d6\u6062\u590d");
        ls.add("\u672a\u5b9a\u4e49\u4e8b\u4ef6");
        ls.add("\u5e94\u7b54\u64a4\u6d88");
        ls.add("\u4e3b\u52a8\u4e0a\u62a5");
        ls.add("\u901a\u4fe1\u6545\u969c");
        ls.add("\u901a\u8baf\u6545\u969c");
        ls.add("\u6062\u590d\u4f9b\u7535");
        ls.add("\u6545\u969c\u6062\u590d");
        ls.add("\u706b\u8b66\u89e3\u9664");
        ls.add("\u6c34\u538b\u8fc7\u4f4e");
        ls.add("\u6c34\u538b\u8fc7\u9ad8");
        ls.add("\u5907\u7535\u6545\u969c");
        ls.add("\u65ad\u7535\u544a\u8b66");
        ls.add("\u5e94\u7b54");
        ls.add("\u5c4f\u853d");
        ls.add("\u53cd\u9988");
        ls.add("\u6284\u8bfb");
        ls.add("\u9000\u5f55");
        ls.add("\u767b\u5f55");
        ls.add("\u590d\u4f4d");
        ls.add("\u9884\u8b66");
        ls.add("\u6545\u969c");
        ls.add("\u62a5\u8b66");
        ls.add("\u6b63\u5e38");
        ls.add("\u56de\u7b54");
        ls.add("\u706b\u8b66");
        ls.add("\u542f\u52a8");
        ls.add("\u505c\u6b62");
        ls.add("\u9694\u79bb");
        ls.add("\u91ca\u653e");
        ls.add("\u6062\u590d");
        ls.add("\u52a8\u4f5c");
        p = Pattern.compile(date_regexp);
        m = p.matcher(data);
        while (m.find()) {
            date = m.group();
            stamp = TimeUtil.getFullDateTimeString(date, dateFormat, timeFormat);
        }
        System.out.println("stamp:" + stamp);
        p = Pattern.compile(deviceid_regexp);
        m = p.matcher(data);
        while (m.find()) {
            deviceid = m.group();
        }
        System.out.println("deviceid:" + deviceid);
        for (Object e : ls) {
            if (data.indexOf(e.toString()) <= -1) continue;
            eventTypeName = e.toString();
            break;
        }
        System.out.println("eventTypeName:" + eventTypeName);
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u4e3b\u673a\u7cfb\u7edf\u6570\u636e\u91c7\u96c6\u8bbe\u5907");
        list.add("\u72ec\u7acb\u5f0f\u6570\u636e\u91c7\u96c6\u8bbe\u5907");
        list.add("\u71c3\u6c14\u6cc4\u6f0f\u62a5\u8b66\u5668");
        list.add("\u6c34\u4f4d\u9884\u8b66\u8bbe\u5907");
        list.add("\u6c34\u538b\u9884\u8b66\u8bbe\u5907");
        list.add("\u5149\u675f\u63a5\u53e3\u6a21\u5757");
        list.add("\u72ec\u7acb\u5f0f\u70df\u611f");
        list.add("\u63a7\u5236\u6a21\u5757");
        list.add("\u7ea2\u5916\u63a2\u5934");
        list.add("\u7535\u6e90\u5f3a\u5207");
        list.add("\u5149\u6805\u6d4b\u6e29");
        list.add("\u70b9\u578b\u611f\u6e29");
        list.add("\u70b9\u578b\u611f\u70df");
        list.add("\u62a5\u8b66\u63a5\u53e3");
        list.add("\u590d\u5408\u706b\u7130");
        list.add("\u5149\u675f\u611f\u70df");
        list.add("\u7d2b\u5916\u706b\u7130");
        list.add("\u7ebf\u578b\u611f\u6e29");
        list.add("\u5438\u6c14\u611f\u70df");
        list.add("\u590d\u5408\u63a2\u6d4b");
        list.add("\u624b\u52a8\u6309\u94ae");
        list.add("\u6d88\u9632\u5e7f\u64ad");
        list.add("\u6d88\u9632\u7535\u8bdd");
        list.add("\u6d88\u706b\u6813\u6cf5");
        list.add("\u5377\u5e18\u95e8\u4e2d");
        list.add("\u5377\u5e18\u95e8\u4e0b");
        list.add("\u538b\u529b\u5f00\u5173");
        list.add("\u6c34\u6d41\u6307\u793a");
        list.add("\u7a7a\u8c03\u673a\u7ec4");
        list.add("\u67f4\u6cb9\u53d1\u7535");
        list.add("\u7167\u660e\u914d\u7535");
        list.add("\u52a8\u529b\u914d\u7535");
        list.add("\u6c34\u5e55\u7535\u78c1");
        list.add("\u6c14\u4f53\u542f\u52a8");
        list.add("\u6c14\u4f53\u505c\u52a8");
        list.add("\u706b\u707e\u793a\u76d8");
        list.add("\u5e72\u7c89\u706d\u706b");
        list.add("\u6d88\u9632\u7535\u6e90");
        list.add("\u7d27\u6025\u7167\u660e");
        list.add("\u758f\u5bfc\u6307\u793a");
        list.add("\u55b7\u6d12\u6307\u793a");
        list.add("\u9632\u76d7\u6a21\u5757");
        list.add("\u4fe1\u53f7\u789f\u9600");
        list.add("\u9632\u6392\u70df\u9600");
        list.add("\u8bbe\u5907\u505c\u52a8");
        list.add("\u6025\u542f\u6309\u94ae");
        list.add("\u6025\u505c\u6309\u94ae");
        list.add("\u8054\u52a8\u7535\u6e90");
        list.add("\u591a\u7ebf\u5236\u9501");
        list.add("\u90e8\u5206\u8bbe\u5907");
        list.add("\u6545\u969c\u8f93\u51fa");
        list.add("\u624b\u52a8\u5141\u8bb8");
        list.add("\u81ea\u52a8\u5141\u8bb8");
        list.add("\u53ef\u71c3\u6c14\u4f53");
        list.add("\u5907\u7528\u6307\u793a");
        list.add("\u5907\u7528\u5de5\u4f5c");
        list.add("\u8bbe\u5907\u6545\u969c");
        list.add("\u7d27\u6025\u6c42\u52a9");
        list.add("\u65f6\u949f\u7535\u6e90");
        list.add("\u8b66\u62a5\u8f93\u51fa");
        list.add("\u62a5\u8b66\u4f20\u8f93");
        list.add("\u73af\u8def\u5f00\u5173");
        list.add("\u7f06\u5f0f\u611f\u6e29");
        list.add("\u5438\u6c14\u611f\u70df");
        list.add("\u5438\u6c14\u706b\u8b66");
        list.add("\u5438\u6c14\u9884\u8b66");
        list.add("\u63a2\u6d4b\u5668\u810f");
        list.add("\u591a\u7ebf\u5236\u76d8");
        list.add("\u6a21\u62df\u611f\u6e29");
        list.add("\u6f0f\u7535\u62a5\u8b66");
        list.add("\u6d88\u9632\u4e3b\u673a");
        list.add("\u8f93\u5165\u6a21\u5757");
        list.add("\u5149\u7535\u611f\u70df");
        list.add("\u672a\u5b9a\u4e49");
        list.add("\u6d88\u706b\u6813");
        list.add("\u6d88\u706b\u6813");
        list.add("\u55b7\u6dcb\u6cf5");
        list.add("\u7a33\u538b\u6cf5");
        list.add("\u6392\u70df\u673a");
        list.add("\u9001\u98ce\u673a");
        list.add("\u65b0\u98ce\u673a");
        list.add("\u9632\u706b\u9600");
        list.add("\u6392\u70df\u9600");
        list.add("\u9001\u98ce\u9600");
        list.add("\u7535\u78c1\u9600");
        list.add("\u9632\u706b\u95e8");
        list.add("\u6ce1\u6cab\u6cf5");
        list.add("\u6c34\u5e55\u6cf5");
        list.add("\u5c42\u53f7\u706f");
        list.add("\u6cf5\u6545\u969c");
        list.add("\u96e8\u6dcb\u6cf5");
        list.add("\u4e0a\u4f4d\u673a");
        list.add("\u7a7a\u538b\u673a");
        list.add("\u96e8\u6dcb\u9600");
        list.add("\u611f\u6e29\u68d2");
        list.add("\u672a\u5b9a\u4e49");
        list.add("\u672a\u5b9a\u4e49");
        list.add("\u8baf\u54cd\u5668");
        list.add("\u58f0\u5149");
        list.add("\u7535\u68af");
        list.add("\u4ece\u673a");
        list.add("\u603b\u7ebf");
        list.add("\u56de\u8def");
        list.add("\u95e8\u706f");
        list.add("\u95f8\u9600");
        for (Object e : list) {
            if (data.indexOf(e.toString()) <= -1) continue;
            unitType = e.toString();
            break;
        }
        System.out.println("unitType:" + unitType);
        postion = StringUtils.StringFilter(data.replaceAll(date, EMPTY).replaceAll(deviceid, EMPTY).replaceAll(eventTypeName, EMPTY).replaceAll(unitType, EMPTY).replaceAll(" ", EMPTY));
        System.out.println("postion:" + postion);
        obj.put((Object)"stamp", (Object)stamp);
        obj.put((Object)"unitType", (Object)unitType);
        obj.put((Object)"postion", (Object)postion);
        obj.put((Object)"eventTypeName", (Object)eventTypeName);
        obj.put((Object)"deviceid", (Object)deviceid);
        return obj;
    }

    public static JSONArray deal(String str, String date_regexp, String deviceid_regexp, String dateFormat, String timeFormat) {
        String datetime;
        System.out.println("str:" + str);
        Pattern p = Pattern.compile("\\d{2}/\\d{2} \\d{2}:\\d{2}");
        Matcher m = p.matcher(str);
        String indexs = EMPTY;
        int lastIndex = 0;
        boolean datePos = false;
        boolean splitFlag = false;
        String format = EMPTY;
        JSONObject obj = new JSONObject();
        JSONArray jarr = new JSONArray();
        p = Pattern.compile(date_regexp);
        m = p.matcher(str);
        if (m.lookingAt()) {
            format = date_regexp;
        }
        if (StringUtils.isBlank(format) && (m = (p = Pattern.compile(deviceid_regexp)).matcher(str)).lookingAt()) {
            format = deviceid_regexp;
        }
        if (StringUtils.isBlank(format)) {
            p = Pattern.compile(date_regexp);
            m = p.matcher(str);
            lastIndex = 0;
            while (m.find()) {
                datetime = m.group();
                lastIndex = m.end();
            }
            if (lastIndex == str.length()) {
                format = date_regexp;
            }
        }
        if (StringUtils.isBlank(format)) {
            p = Pattern.compile(deviceid_regexp);
            m = p.matcher(str);
            lastIndex = 0;
            while (m.find()) {
                lastIndex = m.end();
            }
            if (lastIndex == str.length()) {
                format = deviceid_regexp;
            }
        }
        p = Pattern.compile(format);
        m = p.matcher(str);
        while (m.find()) {
            datetime = m.group();
            indexs = indexs + m.start() + ",";
            lastIndex = m.end();
        }
        indexs = indexs + str.length();
        if (lastIndex == str.length()) {
            indexs = "0,";
            m = p.matcher(str);
            while (m.find()) {
                datetime = m.group();
                indexs = indexs + (m.start() + datetime.length()) + ",";
            }
            datePos = true;
        }
        String[] tmpArr = indexs.split(",");
        System.out.println("tmpArr:" + tmpArr.length);
        if (tmpArr.length > 2) {
            for (int i = 0; i < tmpArr.length - 1; ++i) {
                String data = str.substring(Integer.parseInt(tmpArr[i]), Integer.parseInt(tmpArr[i + 1]));
                System.out.println("data:" + data);
                obj = StringUtils.dealData(data, date_regexp, deviceid_regexp, dateFormat, timeFormat);
                jarr.add((Object)obj);
            }
        } else if (tmpArr.length == 2) {
            obj = StringUtils.dealData(str, date_regexp, deviceid_regexp, dateFormat, timeFormat);
            jarr.add((Object)obj);
        }
        return jarr;
    }

    public static void sortStringArray(String[] arrStr) {
        for (int i = 0; i < arrStr.length; ++i) {
            for (int j = arrStr.length - 1; j > i; --j) {
                if (arrStr[i].length() >= arrStr[j].length()) continue;
                String temp = arrStr[i];
                arrStr[i] = arrStr[j];
                arrStr[j] = temp;
            }
        }
    }

    public static String[] Set2Array(Set<String> set) {
        String[] arr = new String[set.size()];
        set.toArray(arr);
        StringUtils.sortStringArray(arr);
        return arr;
    }

    public static String filterNumber(String number) {
        number = number.replaceAll("[^(0-9)]", EMPTY);
        return number;
    }

    public static String filterAlphabet(String alph) {
        alph = alph.replaceAll("[^(A-Za-z)]", EMPTY);
        return alph;
    }

    public static String filterChinese(String chin) {
        chin = chin.replaceAll("[^(\\u4e00-\\u9fa5)]", EMPTY);
        return chin;
    }

    public static String filter(String character) {
        character = character.replaceAll("[^(a-zA-Z0-9\\u4e00-\\u9fa5)]", EMPTY);
        return character;
    }

    public static String removeAlphabet(String alphabet) {
        return alphabet.replaceAll("[A-Za-z]", EMPTY);
    }

    public static String filterDigital(String digital) {
        return digital.replaceAll("[0-9]", EMPTY);
    }

    public static String removeChinese(String chin) {
        return chin.replaceAll("[\\u4e00-\\u9fa5]", EMPTY);
    }

    public static String filterAll(String character) {
        return character.replaceAll("[a-zA-Z0-9\\u4e00-\\u9fa5]", EMPTY);
    }

    public static String replaceMultiToOneSpace(String str) {
        Pattern p = Pattern.compile("\\s+");
        Matcher m = p.matcher(str);
        return m.replaceAll(" ");
    }

    public static String filterInvisibleCharacter(String character) {
        character = character.replaceAll("[^0-9a-zA-Z\u4e00-\u9fa5. \uff0c:/\\_,\u3002\\-\uff1f\u201c\u201d]+", EMPTY);
        return character;
    }

    public static String[] getDateFormatMatcher(String str, String regexp) {
        String[] dayFormats = regexp.split("\\|", 100);
        String datetime = TimeUtil.getLocalTime();
        String[] matcher = new String[]{datetime, "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}", "0"};
        int count = 0;
        Pattern p = null;
        Matcher m = null;
        for (String date_format : dayFormats) {
            p = Pattern.compile(date_format);
            m = p.matcher(str);
            while (m.find()) {
                matcher[0] = m.group();
                matcher[1] = date_format;
                ++count;
            }
        }
        matcher[2] = String.valueOf(count);
        return matcher;
    }

    public static HashMap getOptimalMatching(String str, String regexp) {
        String[] tmpA1 = regexp.split("\\|", 10000);
        HashMap<String, String> tmap = new HashMap<String, String>();
        String value = EMPTY;
        Pattern p = null;
        Matcher m = null;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            if (m.find()) {
                tmap = new HashMap();
                tmap.put("regexp", exp);
                tmap.put("value", m.group());
            }
            if (tmap.size() > 0) break;
        }
        return tmap;
    }

    public static String getDateRegExp() {
        StringBuffer regexp = new StringBuffer();
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}\u65f6\\d{2}\u5206|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206|");
        regexp.append("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\u5e74\\d{1,2}\u6708 \\d{1,2}\u65e5\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708 \\d{2}\u65e5\\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}|");
        regexp.append("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}:\\d{2}|");
        regexp.append("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206|");
        regexp.append("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}\u65f6\\d{2}\u5206|");
        regexp.append("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206|");
        regexp.append("\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}|");
        regexp.append("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}|");
        regexp.append("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{2}-\\d{1,2}-\\d{1,2}|");
        regexp.append("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{4}-\\d{1,2}-\\d{1,2}|");
        regexp.append("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}|");
        regexp.append("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}|");
        regexp.append("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}|");
        regexp.append("\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\/\\d{2} \\d{2}:\\d{2}|");
        regexp.append("\\d{2}\\/\\d{2}\\d{2}:\\d{2}|");
        regexp.append("\\d{2}-\\d{2} \\d{2}:\\d{2}");
        regexp.append(EMPTY);
        return regexp.toString();
    }

    public static String getDeviceIdRegExp() {
        StringBuffer regexp = new StringBuffer();
        regexp.append("\\d{3}\u53f7|");
        regexp.append("\\d{2}\u680b\\d{2}\u533a\\d{2}\u5c42\\d{3}\u53f7|");
        regexp.append("\\d{2}\u680b\\d{2}\u673a\\d{2}\u8def\\d{3}\u53f7|");
        regexp.append("\\d{2}\u673a\\d{2}\u8def\\d{3}\u53f7|");
        regexp.append("[A-Za-z]{1}\\d{2}-\\d{4}[A-Za-z]{1}\\d{3}|");
        regexp.append("\\d{1}[\\u4e00-\\u9fa5]{1}\\d{2}[\\u4e00-\\u9fa5]{1}\\d{3}|");
        regexp.append("N\\d{1,3}L\\d{1,2}M\\d{1,3}|");
        regexp.append("\u591a\u7ebf\\d{2}-\\d{1}|");
        regexp.append("[\\u4e00-\\u9fa5]{2}\\d{2}-\\d{1}|");
        regexp.append("\\d{3}[\\u4e00-\\u9fa5]{2}\\d{3}|");
        regexp.append("\\d{2}[\\u4e00-\\u9fa5]{1}-\\d{3}|");
        regexp.append("N\\d{1,2}L\\d{1,2}M\\d{1,2}|");
        regexp.append("N\\d{1,2}L\\d{1,2}D\\d{1,2}|");
        regexp.append("N\\d{1}T\\d{1,3}|");
        regexp.append("\\d{2}-\\d{1}\u53f7|");
        regexp.append("\\d{1}-\\d{2}-\\d{2}|");
        regexp.append("\\d{3}-\\d{2}-\\d{2}|");
        regexp.append("\\d{3}-\\d{3}|");
        regexp.append("\\d{2}-\\d{3}|");
        regexp.append("\\d{1}-\\d{3}|");
        regexp.append("\\d{2}-\\d{2}|");
        regexp.append("\\d{1}-\\d{2}|");
        regexp.append("\\d{8}|");
        regexp.append("\\d{7}|");
        regexp.append("\\d{6}|");
        regexp.append("\\d{5}|");
        regexp.append("N\\d{1,8}|");
        regexp.append("\\d{1,3}-\\d{1,3}|");
        regexp.append("\\d{1,3}-\\d{1,3}-\\d{1,3}|");
        regexp.append("\\d{3} |");
        regexp.append("\\d{1,2}[\\u4e00-\\u9fa5]{1}\\d{1,2}-\\d{1,2}|");
        regexp.append("\\d{1,2}[\\u4e00-\\u9fa5]{1,9}-\\d{1,2}|");
        regexp.append("\\d{1,3}[\\u4e00-\\u9fa5]{1,5}|");
        regexp.append("\\d{4}|");
        regexp.append("\\d{3}\u53f7|");
        regexp.append("\\d{3}");
        regexp.append(EMPTY);
        return regexp.toString();
    }

    public static HashMap getOptimalMatchingDate(String str) {
        return StringUtils.getOptimalMatching(str, StringUtils.getDateRegExp());
    }

    public static List getMatchAllDate(String str) {
        StringBuffer regexp = new StringBuffer();
        return StringUtils.getMatchAll(str, StringUtils.getDateRegExp());
    }

    public static int getMatchDateCount(String str) {
        Pattern p = null;
        Matcher m = null;
        int count = 0;
        p = Pattern.compile(StringUtils.getDateRegExp());
        m = p.matcher(str);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static int getMatchDeviceIdCount(String str) {
        Pattern p = null;
        Matcher m = null;
        int count = 0;
        p = Pattern.compile(StringUtils.getDeviceIdRegExp());
        m = p.matcher(StringUtils.getFilterDate(str));
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String getOptimalMatchingRegexp(String str, String regexp) {
        Pattern p = null;
        Matcher m = null;
        String[] tmpA1 = regexp.split("\\|", 1000);
        boolean bl = false;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            if (m.find()) {
                String value = m.group();
                regexp = exp;
                bl = true;
            }
            if (bl) break;
        }
        return regexp;
    }

    public static int getOptimalMatchingCount(String str, String regexp) {
        Pattern p = null;
        Matcher m = null;
        String[] tmpA1 = regexp.split("\\|", 10000);
        int count = 0;
        boolean bl = false;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            while (m.find()) {
                String value = m.group();
                ++count;
            }
            if (count > 0) break;
        }
        return count;
    }

    public static Regexp getOptimalMatchingCountAndRegexp(String str, String regexp) {
        Pattern p = null;
        Matcher m = null;
        String[] tmpA1 = regexp.split("\\|", 10000);
        int count = 0;
        Regexp regexp2 = new Regexp();
        boolean bl = false;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            while (m.find()) {
                String value = m.group();
                ++count;
            }
            if (count <= 0) continue;
            regexp2.setRegexp(exp);
            break;
        }
        regexp2.setCount(count);
        return regexp2;
    }

    public static HashMap getOptimalMatchingDeviceId(String str) {
        return StringUtils.getOptimalMatching(str, StringUtils.getDeviceIdRegExp());
    }

    public static List getMatchAllDeviceId(String str) {
        StringBuffer regexp = new StringBuffer();
        return StringUtils.getMatchAll(str, StringUtils.getDeviceIdRegExp());
    }

    public static List getMatchAll(String str, String regexp) {
        String[] tmpA1 = regexp.split("\\|", 100);
        ArrayList ls = new ArrayList();
        HashMap<String, String> tmap = new HashMap<String, String>();
        String value = EMPTY;
        Pattern p = null;
        Matcher m = null;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            while (m.find()) {
                value = m.group();
                tmap = new HashMap();
                tmap.put("regexp", exp);
                tmap.put("value", value);
                str = str.replace(value, EMPTY);
                ls.add(tmap);
            }
        }
        return ls;
    }

    public static String getFilterDate(String str) {
        String value = EMPTY;
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile(StringUtils.getDateRegExp());
        m = p.matcher(str);
        while (m.find()) {
            value = m.group();
            str = str.replace(value, EMPTY);
        }
        return str;
    }

    public static boolean hasSameSubStr(String str1, String str2, boolean includeSelf) {
        String shortStr = str1.length() > str2.length() ? str2 : str1;
        String longStr = str1.length() > str2.length() ? str1 : str2;
        String temp = EMPTY;
        for (int i = 0; i < shortStr.length(); ++i) {
            for (int j = i + 2; j <= shortStr.length(); ++j) {
                boolean flag2;
                temp = shortStr.substring(i, j);
                boolean flag1 = includeSelf && longStr.indexOf(temp) >= 0;
                boolean bl = flag2 = !includeSelf && !temp.equals(shortStr) && longStr.indexOf(temp) >= 0;
                if (!flag1 && !flag2) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getMaxSameSubStr(String str1, String str2, boolean includeSelf) {
        String shortStr = str1.length() > str2.length() ? str2 : str1;
        String longStr = str1.length() > str2.length() ? str1 : str2;
        String temp = EMPTY;
        int subLength = 0;
        ArrayList<String> sameSubs = new ArrayList<String>();
        for (int i = 0; i < shortStr.length(); ++i) {
            for (int j = i + 2; j <= shortStr.length(); ++j) {
                boolean flag2;
                temp = shortStr.substring(i, j);
                boolean flag1 = includeSelf && longStr.indexOf(temp) >= 0;
                boolean bl = flag2 = !includeSelf && !temp.equals(shortStr) && longStr.indexOf(temp) >= 0;
                if (!flag1 && !flag2) continue;
                if (temp.length() > subLength) {
                    subLength = temp.length();
                    sameSubs.clear();
                    sameSubs.add(temp);
                    continue;
                }
                if (temp.length() != subLength) continue;
                sameSubs.add(temp);
            }
        }
        return sameSubs;
    }

    public static List<Object> compareStrWithSub(String str1, String str2, boolean includeSelf) {
        String shortStr = str1.length() > str2.length() ? str2 : str1;
        String longStr = str1.length() > str2.length() ? str1 : str2;
        String temp = EMPTY;
        int subLength = 0;
        boolean hasSame = false;
        ArrayList<String> sameSubs = new ArrayList<String>();
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < shortStr.length(); ++i) {
            for (int j = i + 2; j <= shortStr.length(); ++j) {
                boolean flag2;
                temp = shortStr.substring(i, j);
                boolean flag1 = includeSelf && longStr.indexOf(temp) >= 0;
                boolean bl = flag2 = !includeSelf && !temp.equals(shortStr) && longStr.indexOf(temp) >= 0;
                if (!flag1 && !flag2) continue;
                hasSame = true;
                if (temp.length() > subLength) {
                    subLength = temp.length();
                    sameSubs.clear();
                    sameSubs.add(temp);
                    continue;
                }
                if (temp.length() != subLength) continue;
                sameSubs.add(temp);
            }
        }
        ret.add(hasSame);
        ret.addAll(sameSubs);
        return ret;
    }

    public static String compareStrWithSub(String src, String str1, String str2, boolean includeSelf) {
        String reStr = EMPTY;
        List<Object> lobj = StringUtils.compareStrWithSub(str1, str2, includeSelf);
        if (lobj.size() > 0) {
            boolean bl = Boolean.parseBoolean(lobj.get(0).toString());
            if (bl) {
                String tmpStr = str1.replace(lobj.get(1).toString(), EMPTY);
                reStr = src.replace(tmpStr, EMPTY).replace(str2, EMPTY);
            } else {
                reStr = src.replace(str1, EMPTY).replace(str2, EMPTY);
            }
        }
        return reStr;
    }

    public static JSONArray dataDeal(String str) {
        System.out.println("str:" + str);
        str = StringUtils.replaceMultiToOneSpace(str);
        Pattern p = Pattern.compile("\\d{2}/\\d{2} \\d{2}:\\d{2}");
        Matcher m = p.matcher(str);
        String findedstr = EMPTY;
        String indexs = EMPTY;
        int firstIndex = -1;
        boolean secondIndex = false;
        int lastIndex = 0;
        boolean datePos = false;
        boolean splitFlag = false;
        int dateCount = 0;
        int deviceidCount = 0;
        boolean matcheCount = false;
        String format = EMPTY;
        JSONObject obj = new JSONObject();
        JSONArray jarr = new JSONArray();
        p = Pattern.compile(StringUtils.getDateRegExp());
        m = p.matcher(str);
        if (m.find()) {
            findedstr = m.group();
            String newStr = findedstr.replace("-", "/");
            str = str.replace(findedstr, newStr);
        }
        if ((m = (p = Pattern.compile(StringUtils.getDateRegExp())).matcher(str)).lookingAt()) {
            format = StringUtils.getDateRegExp();
            firstIndex = 0;
        }
        if (StringUtils.isBlank(format) && (m = (p = Pattern.compile(StringUtils.getDeviceIdRegExp())).matcher(str)).lookingAt()) {
            format = StringUtils.getDeviceIdRegExp();
            firstIndex = 0;
        }
        if (StringUtils.isBlank(format)) {
            p = Pattern.compile(StringUtils.getDateRegExp());
            m = p.matcher(str);
            lastIndex = 0;
            while (m.find()) {
                String datetime = m.group();
                lastIndex = m.end();
            }
            if (lastIndex == str.length()) {
                format = StringUtils.getDateRegExp();
            }
        }
        if (StringUtils.isBlank(format)) {
            p = Pattern.compile(StringUtils.getDeviceIdRegExp());
            m = p.matcher(str);
            lastIndex = 0;
            while (m.find()) {
                lastIndex = m.end();
            }
            if (lastIndex == str.length()) {
                format = StringUtils.getDeviceIdRegExp();
            }
        }
        if (dateCount > 0 && StringUtils.isBlank(format)) {
            p = Pattern.compile(StringUtils.getDateRegExp());
            m = p.matcher(str);
            firstIndex = 0;
            if (m.find()) {
                firstIndex = m.start();
                findedstr = m.group();
                str = str.substring(firstIndex) + str.substring(0, firstIndex);
                System.out.println("str===========:" + str);
            }
            return StringUtils.dataDeal(str);
        }
        if (deviceidCount > 0 && StringUtils.isBlank(format)) {
            p = Pattern.compile(StringUtils.getDeviceIdRegExp());
            m = p.matcher(str);
            firstIndex = 0;
            if (m.find()) {
                firstIndex = m.start();
                findedstr = m.group();
                str = str.substring(firstIndex) + str.substring(0, firstIndex);
                System.out.println("str===========:" + str);
            }
            return StringUtils.dataDeal(str);
        }
        if (StringUtils.isBlank(format)) {
            return jarr;
        }
        if (firstIndex == 0) {
            p = Pattern.compile(format);
            m = p.matcher(str);
            while (m.find()) {
                findedstr = m.group();
                indexs = indexs + m.start() + ",";
                lastIndex = m.end();
            }
            indexs = indexs + str.length();
        }
        if (lastIndex == str.length()) {
            indexs = "0,";
            m = p.matcher(str);
            while (m.find()) {
                findedstr = m.group();
            }
            datePos = true;
        }
        String[] tmpArr = indexs.split(",");
        System.out.println("tmpArr:" + tmpArr.length);
        if (tmpArr.length > 2) {
            for (int i = 0; i < tmpArr.length - 1; ++i) {
                String data = str.substring(Integer.parseInt(tmpArr[i]), Integer.parseInt(tmpArr[i + 1]));
                System.out.println("data:" + data);
                obj = StringUtils.singleDataAnalysis(data);
                jarr.add((Object)obj);
            }
        } else if (tmpArr.length == 2) {
            obj = StringUtils.singleDataAnalysis(str);
            jarr.add((Object)obj);
        }
        return jarr;
    }

    public static JSONObject singleDataAnalysis(String data) {
        String date = TimeUtil.getLocalTime();
        String stamp = TimeUtil.getLocalTime();
        String deviceid = "0";
        String eventTypeName = EMPTY;
        String unitTypeName = EMPTY;
        String eventType = "228";
        String unitType = "1";
        String postion = ".";
        Object p = null;
        Object m = null;
        JSONObject obj = new JSONObject();
        String[] dataDictionaryState = new String[]{"\u7535\u6c60\u7535\u538b\u8fc7\u4f4e\u544a\u8b66", "\u6c34\u538b\u4e0d\u8fbe\u6807\u544a\u8b66", "\u6c34\u538b\u6062\u590d\u62a5\u544a", "\u7535\u6c60\u7535\u538b\u6062\u590d", "\u8bbe\u5907\u76d6\u88ab\u6253\u5f00", "\u6c34\u4f4d\u8d85\u4e0a\u9650", "\u6c34\u4f4d\u8d85\u4e0b\u9650", "\u8bbe\u5907\u76d6\u6062\u590d", "\u672a\u5b9a\u4e49\u4e8b\u4ef6", "\u5e94\u7b54\u64a4\u6d88", "\u4e3b\u52a8\u4e0a\u62a5", "\u901a\u4fe1\u6545\u969c", "\u901a\u8baf\u6545\u969c", "\u6062\u590d\u4f9b\u7535", "\u6545\u969c\u6062\u590d", "\u706b\u8b66\u89e3\u9664", "\u6c34\u538b\u8fc7\u4f4e", "\u6c34\u538b\u8fc7\u9ad8", "\u5907\u7535\u6545\u969c", "\u65ad\u7535\u544a\u8b66", "\u5e94\u7b54", "\u5c4f\u853d", "\u53cd\u9988", "\u6284\u8bfb", "\u9000\u5f55", "\u767b\u5f55", "\u590d\u4f4d", "\u9884\u8b66", "\u6545\u969c", "\u62a5\u8b66", "\u6b63\u5e38", "\u56de\u7b54", "\u706b\u8b66", "\u542f\u52a8", "\u505c\u6b62", "\u9694\u79bb", "\u91ca\u653e", "\u6062\u590d", "\u52a8\u4f5c"};
        String[] unitTypes = new String[]{"\u4e3b\u673a\u7cfb\u7edf\u6570\u636e\u91c7\u96c6\u8bbe\u5907", "\u72ec\u7acb\u5f0f\u6570\u636e\u91c7\u96c6\u8bbe\u5907", "\u71c3\u6c14\u6cc4\u6f0f\u62a5\u8b66\u5668", "\u6c34\u4f4d\u9884\u8b66\u8bbe\u5907", "\u6c34\u538b\u9884\u8b66\u8bbe\u5907", "\u5149\u675f\u63a5\u53e3\u6a21\u5757", "\u72ec\u7acb\u5f0f\u70df\u611f", "\u611f\u70df\u63a2\u6d4b\u5668", "\u63a7\u5236\u6a21\u5757", "\u7ea2\u5916\u63a2\u5934", "\u7535\u6e90\u5f3a\u5207", "\u5149\u6805\u6d4b\u6e29", "\u70b9\u578b\u611f\u6e29", "\u70b9\u578b\u611f\u70df", "\u62a5\u8b66\u63a5\u53e3", "\u590d\u5408\u706b\u7130", "\u5149\u675f\u611f\u70df", "\u7d2b\u5916\u706b\u7130", "\u7ebf\u578b\u611f\u6e29", "\u5438\u6c14\u611f\u70df", "\u590d\u5408\u63a2\u6d4b", "\u624b\u52a8\u6309\u94ae", "\u6d88\u9632\u5e7f\u64ad", "\u6d88\u9632\u7535\u8bdd", "\u6d88\u706b\u6813\u6cf5", "\u5377\u5e18\u95e8\u4e2d", "\u5377\u5e18\u95e8\u4e0b", "\u538b\u529b\u5f00\u5173", "\u6c34\u6d41\u6307\u793a", "\u7a7a\u8c03\u673a\u7ec4", "\u67f4\u6cb9\u53d1\u7535", "\u7167\u660e\u914d\u7535", "\u52a8\u529b\u914d\u7535", "\u6c34\u5e55\u7535\u78c1", "\u6c14\u4f53\u542f\u52a8", "\u6c14\u4f53\u505c\u52a8", "\u706b\u707e\u793a\u76d8", "\u5e72\u7c89\u706d\u706b", "\u6d88\u9632\u7535\u6e90", "\u7d27\u6025\u7167\u660e", "\u758f\u5bfc\u6307\u793a", "\u55b7\u6d12\u6307\u793a", "\u9632\u76d7\u6a21\u5757", "\u4fe1\u53f7\u789f\u9600", "\u9632\u6392\u70df\u9600", "\u8bbe\u5907\u505c\u52a8", "\u6025\u542f\u6309\u94ae", "\u6025\u505c\u6309\u94ae", "\u8054\u52a8\u7535\u6e90", "\u591a\u7ebf\u5236\u9501", "\u90e8\u5206\u8bbe\u5907", "\u6545\u969c\u8f93\u51fa", "\u624b\u52a8\u5141\u8bb8", "\u81ea\u52a8\u5141\u8bb8", "\u53ef\u71c3\u6c14\u4f53", "\u5907\u7528\u6307\u793a", "\u5907\u7528\u5de5\u4f5c", "\u8bbe\u5907\u6545\u969c", "\u7d27\u6025\u6c42\u52a9", "\u65f6\u949f\u7535\u6e90", "\u8b66\u62a5\u8f93\u51fa", "\u62a5\u8b66\u4f20\u8f93", "\u73af\u8def\u5f00\u5173", "\u7f06\u5f0f\u611f\u6e29", "\u5438\u6c14\u611f\u70df", "\u5438\u6c14\u706b\u8b66", "\u5438\u6c14\u9884\u8b66", "\u63a2\u6d4b\u5668\u810f", "\u591a\u7ebf\u5236\u76d8", "\u6a21\u62df\u611f\u6e29", "\u6f0f\u7535\u62a5\u8b66", "\u6d88\u9632\u4e3b\u673a", "\u8f93\u5165\u6a21\u5757", "\u5149\u7535\u611f\u70df", "\u672a\u5b9a\u4e49", "\u6d88\u706b\u6813", "\u6d88\u706b\u6813", "\u55b7\u6dcb\u6cf5", "\u7a33\u538b\u6cf5", "\u6392\u70df\u673a", "\u9001\u98ce\u673a", "\u65b0\u98ce\u673a", "\u9632\u706b\u9600", "\u6392\u70df\u9600", "\u9001\u98ce\u9600", "\u7535\u78c1\u9600", "\u9632\u706b\u95e8", "\u6ce1\u6cab\u6cf5", "\u6c34\u5e55\u6cf5", "\u5c42\u53f7\u706f", "\u6cf5\u6545\u969c", "\u96e8\u6dcb\u6cf5", "\u4e0a\u4f4d\u673a", "\u7a7a\u538b\u673a", "\u96e8\u6dcb\u9600", "\u611f\u6e29\u68d2", "\u672a\u5b9a\u4e49", "\u672a\u5b9a\u4e49", "\u8baf\u54cd\u5668", "\u58f0\u5149", "\u7535\u68af", "\u4ece\u673a", "\u603b\u7ebf", "\u56de\u8def", "\u95e8\u706f", "\u95f8\u9600"};
        StringUtils.sortStringArray(dataDictionaryState);
        StringUtils.sortStringArray(unitTypes);
        HashMap hm = StringUtils.getOptimalMatchingDate(data);
        if (hm.size() > 0) {
            date = hm.get("value").toString();
            stamp = TimeUtil.getFullDateTimeString(hm.get("value").toString(), hm.get("regexp").toString()).toString();
        }
        System.out.println("dealData stamp:" + stamp);
        if (StringUtils.isBlank(stamp)) {
            stamp = TimeUtil.getLocalTime();
        }
        for (String item : dataDictionaryState) {
            if (data.indexOf(item.toString()) <= -1) continue;
            eventTypeName = item.toString();
            break;
        }
        System.out.println("eventTypeName:" + eventTypeName);
        for (String it : unitTypes) {
            if (data.indexOf(it.toString()) <= -1) continue;
            unitTypeName = it.toString();
            break;
        }
        System.out.println("unitTypeName:" + unitTypeName);
        String tmpStr = data.replaceAll(date, EMPTY).replaceAll(eventTypeName, EMPTY).replaceAll(unitTypeName, EMPTY);
        hm = StringUtils.getOptimalMatchingDeviceId(StringUtils.getFilterDate(tmpStr));
        if (hm.size() > 0) {
            deviceid = hm.get("value").toString();
        }
        System.out.println("deviceid:" + deviceid);
        if (StringUtils.isBlank(deviceid)) {
            deviceid = "0";
        }
        postion = StringUtils.StringFilterNoStarAndQuestionMark(data.replaceAll(date, EMPTY).replaceAll(deviceid, EMPTY).replaceAll(eventTypeName, EMPTY).replaceAll(unitTypeName, EMPTY).replaceAll(" ", EMPTY));
        System.out.println("postion:" + postion);
        if (StringUtils.isBlank(postion)) {
            postion = unitTypeName;
        }
        obj.put((Object)"stamp", (Object)stamp);
        obj.put((Object)"unitTypeName", (Object)unitTypeName);
        obj.put((Object)"unitType", (Object)unitType);
        obj.put((Object)"postion", (Object)postion);
        obj.put((Object)"eventTypeName", (Object)eventTypeName);
        obj.put((Object)"eventType", (Object)eventType);
        obj.put((Object)"deviceid", (Object)deviceid);
        return obj;
    }

    private static String fullWidth2halfWidth(String fullWidthStr) {
        if (null == fullWidthStr || fullWidthStr.length() <= 0) {
            return EMPTY;
        }
        char[] charArray = fullWidthStr.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char charIntValue = charArray[i];
            if (charIntValue >= '\uff01' && charIntValue <= '\uff5e') {
                charArray[i] = (char)(charIntValue - 65248);
                continue;
            }
            if (charIntValue != '\u3000') continue;
            charArray[i] = 32;
        }
        return new String(charArray);
    }

    public static String toSemiangle(String src) {
        char[] c = src.toCharArray();
        for (int index = 0; index < c.length; ++index) {
            if (c[index] == '\u3000') {
                c[index] = 32;
                continue;
            }
            if (c[index] <= '\uff00' || c[index] >= '\uff5f') continue;
            c[index] = (char)(c[index] - 65248);
        }
        return String.valueOf(c);
    }

    private static String bj2qj(String src) {
        if (src == null) {
            return src;
        }
        StringBuilder buf = new StringBuilder(src.length());
        char[] ca = src.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == ' ') {
                buf.append('\u3000');
                continue;
            }
            if (ca[i] >= '!' && ca[i] <= '~') {
                buf.append((char)(ca[i] + 65248));
                continue;
            }
            buf.append(ca[i]);
        }
        return buf.toString();
    }

    public static String qj2bj(String src) {
        if (src == null) {
            return src;
        }
        StringBuilder buf = new StringBuilder(src.length());
        char[] ca = src.toCharArray();
        for (int i = 0; i < src.length(); ++i) {
            if (ca[i] >= '\uff01' && ca[i] <= '\uff5e') {
                buf.append((char)(ca[i] - 65248));
                continue;
            }
            if (ca[i] == '\u3000') {
                buf.append(' ');
                continue;
            }
            buf.append(ca[i]);
        }
        return buf.toString();
    }

    public static String convertUpper(String moneyString) {
        int dotPoint = moneyString.indexOf(".");
        String moneyStr = dotPoint != -1 ? moneyString.substring(0, moneyString.indexOf(".")) : moneyString;
        StringBuffer fraction = null;
        StringBuffer ms = new StringBuffer();
        for (int i = 0; i < moneyStr.length(); ++i) {
            ms.append(pattern[moneyStr.charAt(i) - 48]);
        }
        int cpCursor = 1;
        for (int j = moneyStr.length() - 1; j > 0; --j) {
            ms.insert(j, cPattern[cpCursor]);
            cpCursor = cpCursor == 8 ? 1 : cpCursor + 1;
        }
        while (ms.indexOf("\u96f6\u62fe") != -1) {
            ms.replace(ms.indexOf("\u96f6\u62fe"), ms.indexOf("\u96f6\u62fe") + 2, ZEOR);
        }
        while (ms.indexOf("\u96f6\u4f70") != -1) {
            ms.replace(ms.indexOf("\u96f6\u4f70"), ms.indexOf("\u96f6\u4f70") + 2, ZEOR);
        }
        while (ms.indexOf("\u96f6\u4edf") != -1) {
            ms.replace(ms.indexOf("\u96f6\u4edf"), ms.indexOf("\u96f6\u4edf") + 2, ZEOR);
        }
        while (ms.indexOf("\u96f6\u4e07") != -1) {
            ms.replace(ms.indexOf("\u96f6\u4e07"), ms.indexOf("\u96f6\u4e07") + 2, "\u4e07");
        }
        while (ms.indexOf("\u96f6\u4ebf") != -1) {
            ms.replace(ms.indexOf("\u96f6\u4ebf"), ms.indexOf("\u96f6\u4ebf") + 2, "\u4ebf");
        }
        while (ms.indexOf("\u96f6\u96f6") != -1) {
            ms.replace(ms.indexOf("\u96f6\u96f6"), ms.indexOf("\u96f6\u96f6") + 2, ZEOR);
        }
        while (ms.indexOf("\u4ebf\u4e07") != -1) {
            ms.replace(ms.indexOf("\u4ebf\u4e07"), ms.indexOf("\u4ebf\u4e07") + 2, "\u4ebf");
        }
        while (ms.lastIndexOf("\u96f6") == ms.length() - 1 && ms.indexOf("\u96f6") == -1) {
            ms.delete(ms.lastIndexOf("\u96f6"), ms.lastIndexOf("\u96f6") + 1);
        }
        dotPoint = moneyString.indexOf(".");
        if (dotPoint != -1) {
            String fs = moneyString.substring(dotPoint + 1, moneyString.length());
            if (fs.indexOf("00") == -1 || fs.indexOf("00") >= 2) {
                int end = fs.length() > 2 ? 2 : fs.length();
                fraction = new StringBuffer(fs.substring(0, end));
                for (int j = 0; j < fraction.length(); ++j) {
                    fraction.replace(j, j + 1, pattern[fraction.charAt(j) - 48]);
                }
                for (int i = fraction.length(); i > 0; --i) {
                    fraction.insert(i, cfPattern[i]);
                }
                fraction.insert(0, "\u5143");
            } else {
                fraction = new StringBuffer("\u5143\u6574");
            }
        } else {
            fraction = new StringBuffer("\u5143\u6574");
        }
        ms.append(fraction);
        return ms.toString();
    }

    public static void main(String[] args) {
        String[] tmpArr;
        String[] tmpA;
        String datetime;
        List<String> lsObj = StringUtils.getMaxSameSubStr("\u70b9\u578b\u611f\u70df", "\u611f\u70df\u6545\u969c", false);
        for (int i = 0; i < lsObj.size(); ++i) {
            System.out.println(lsObj.get(i).toString());
        }
        String s1 = StringUtils.compareStrWithSub("12-13 08:35  111056 \u70b9\u578b\u611f\u70df\u6545\u969c \u996d\u58021 \u697c\u95f7\u9876\u5c42", "\u70b9\u578b\u611f\u70df", "\u611f\u70df\u6545\u969c", true);
        System.out.println("s1=" + s1);
        String[] arrStr = new String[]{"yours", "I", "am", "wsq"};
        StringUtils.sortStringArray(arrStr);
        for (int i = 0; i < arrStr.length; ++i) {
            System.out.println(arrStr[i]);
        }
        String str = EMPTY;
        str = "16\u5e7412\u670812\u65e507\u65f641\u5206 \u6e29\u611f      1\u673a01\u8def187 \u706b\u8b66  1\u680b 1\u5c42\u52a0\u5de5\u95f4\ue810";
        System.out.println("========================1==========================");
        StringUtils.dataDeal(str);
        System.out.println("=========================2=========================");
        str = "{UNIT_STATE_ID=228, UNIT_ID=41208, FLOOR_ID=2887, BUILDING_ID=142}";
        str = "03/07 05:15 09-008 \u6545\u969c\u6062\u590d \u4e00\u5c422\u533a\u70df\u611f";
        str = "03/29 11:49 \u590d\u4f4d 03/29 11:49 \u5907\u7535\u6545\u969c".trim();
        str = "03/07 05:15 09-008 \u6545\u969c\u6062\u590d \u4e00\u5c422\u533a\u70df\u611f 03/07 05:15 \u591a\u7ebf01-2 \u5e94\u7b54 \u55b7\u6dcb\u6cf5".trim();
        Pattern p = Pattern.compile("\\d{2}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}");
        Matcher m = p.matcher(str);
        while (m.find()) {
            String datetime2 = m.group();
            System.out.println("\u4e2d\u6587\u5b57:" + datetime2);
        }
        str = "002-052 \u5149\u7535\u611f\u70df \u901a\u8baf\u6545\u969c 16-03-31 07:27 \u5939\u5c42\u5546\u573a\u70df\u611f 002-053 \u5149\u7535\u611f\u70df \u901a\u8baf\u6545\u969c 16-03-31 07:28 \u5939\u5c42\u5546\u573a\u70df\u611f";
        String date_regexp = "\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}";
        p = Pattern.compile(date_regexp);
        m = p.matcher(str);
        while (m.find()) {
            datetime = m.group();
            System.out.println("\u65f6\u95f4:" + datetime);
            System.out.println("\u65f6\u95f4:" + TimeUtil.getFullDateTimeString(datetime, "YY-MM-DD", "HH:MM"));
        }
        str = "\u706b\u8b6616\u5c42  \u6c34\u6d41\u6307\u793a\u56682016.11.07   19:39:48   0104202";
        str = StringUtils.replaceMultiToOneSpace(str);
        date_regexp = "\\d{4}.\\d{2}.\\d{2} \\d{2}:\\d{2}:\\d{2}";
        p = Pattern.compile(date_regexp);
        m = p.matcher(str);
        while (m.find()) {
            datetime = m.group();
            System.out.println("\u65f6\u95f4:" + datetime);
            System.out.println("\u65f6\u95f4:" + TimeUtil.getFullDateTimeString(datetime, "YYYY.MM.DD", "HH:MM:SS"));
        }
        str = "04-19 02:06  033912 **\u70df** \u53cd\u9988 **\u5c42******";
        str = StringUtils.StringFilterNoStar(str);
        System.out.println("str:" + str);
        System.out.println("str:" + str.indexOf("*"));
        System.out.println("str:" + str.indexOf("#"));
        str = "16/05/12 12:22:13 2\u673a1-2 \u624b\u81ea\u52a8\u8f6c\u6362\u76d2\u624b\u52a8\u542f\u52a8";
        str = "16/05/12 12:22:13 7-116 \u624b\u81ea\u52a8\u8f6c\u6362\u76d2\u624b\u52a8\u542f\u52a8";
        str = "16/05/12 12:22:13 1\u591a\u7ebf-1 \u624b\u81ea\u52a8\u8f6c\u6362\u76d2\u624b\u52a8\u542f\u52a8";
        str = "16/05/12 12:22:13 01\u591a\u7ebf\u63a7\u5236\u76d8\u624b\u81ea\u52a8\u8f6c\u6362\u76d2\u624b\u52a8\u542f\u52a8";
        str = "\u590d\u4f4d 16-06-07 10:38";
        str = "\u706b\u8b66 07-18 23:57 011026   \u70b9\u578b\u611f\u70df**********";
        str = "5\u5c42\u975e\u70e4\u52ff\u6270525023    \u70b9\u578b\u611f\u70df\u706b\u8b66  12\u670826\u65e516:08";
        str = "5\u5c42\u4fe1\u8f69\u996d\u5e97        521076    \u70b9\u578b\u611f\u70df\u6545\u969c  8\u67081\u65e515:22";
        str = "5\u5c42\u4fe1\u8f69521105    \u70b9\u578b\u611f\u70df\u706b\u8b66  8\u67082\u65e52:21";
        str = "\u6a21\u5757\u53cd\u9988\u64a4\u9500 16/09/05 11:55:33 5-164 \u8f93\u5165\u8f93\u51fa 3\u53f7\u697c12\u5c42\u697c\u68af\u95f4\u7535\u52a8\u9001\u98ce\u53e3 --------------------------------";
        str = "99-19 03:43  203055 \u70b9\u578b\u611f\u70df\u706b\u8b66 **\u697c\u4e09\u5c42";
        date_regexp = "\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}|\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}";
        date_regexp = "\\d{2}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}|\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}";
        date_regexp = "\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}";
        p = Pattern.compile(date_regexp);
        m = p.matcher(str);
        while (m.find()) {
            datetime = m.group();
            System.out.println("\u65f6\u95f4==:" + datetime);
        }
        String deviceid = EMPTY;
        String pt = "\\d{2}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}";
        pt = "\\d{1,2}[\u4e00-\u9fa5]{1}\\d{1,2}-\\d{1,2}|\\d{1,3}-\\d{1,3}|\\d{1,2}[\u4e00-\u9fa5]{1,9}-\\d{1,2}|\\d{1,2}[\u4e00-\u9fa5]{1,5}";
        pt = "\\d{6}|\\d{3}-\\d{3}|\\d{2}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}";
        pt = "\\d{3}-\\d{3}|\\d{1}-\\d{3}|\\d{2}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}|\\d{1,2}[\\u4e00-\\u9fa5]{1}\\d{1,2}-\\d{1,2}|\\d{1,3}-\\d{1,3}|\\d{1,2}[\u4e00-\u9fa5]{1,9}-\\d{1,2}|\\d{1,2}[\u4e00-\u9fa5]{1,5}";
        pt = "\\d{1,2}[\u4e00-\u9fa5]{1,5}|\\d{1}-\\d{3}";
        str = "\u5b66\u751f\u63772\u5c42\u6d88\u706b\u681316/10/25 13:51:07 6-22 \u6d88\u94ae\u624b\u52a8\u542f\u52a8";
        p = Pattern.compile("\\d{2}-\\d{2}|\\d{3}-\\d{3}|\\d{2}-\\d{3}|\\d{1}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}|\\d{1,2}[\u4e00-\u9fa5]{1}\\d{1,2}-\\d{1,2}|\\d{1,3}-\\d{1,3}|\\d{1,2}[\u4e00-\u9fa5]{1,9}-\\d{1,2}|\\d{1,2}[\u4e00-\u9fa5]{1,5}|\\d{1}-\\d{2}");
        m = p.matcher(str);
        while (m.find()) {
            deviceid = m.group();
            System.out.println("deviceid:" + deviceid);
        }
        String replaceStr = "\u70b9\u578b\u611f\u70df\u611f\u70df\u706b\u8b66";
        String postion = "\u4e09\u697c\u70b9\u578b\u611f\u70df\u611f\u70df\u706b\u8b66";
        for (int k = 0; k < replaceStr.length(); ++k) {
            postion = postion.replaceAll(replaceStr.substring(k, k + 1), EMPTY);
            System.out.println("postion:" + postion);
        }
        str = "123abc\u4f60\u597defc";
        String reg = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(reg);
        Matcher mat = pat.matcher(str);
        String repickStr = mat.replaceAll(EMPTY);
        System.out.println("\u53bb\u4e2d\u6587\u540e:" + repickStr);
        str = "\u706b\u8b66\u8bb0\u5f55 \u5730\u5740\uff1a065\u53f7 No.001 \u65f6\u95f4\uff1a2016\u5e7411\u670821\u65e515\u65f606\u5206 \u4f4d\u7f6e\uff1a\u53a8\u623f \u7c7b\u578b\uff1a\u611f\u70df\u63a2\u6d4b\u5668";
        reg = "\u5730\u5740\uff1a|No.|\u65f6\u95f4\uff1a|\u4f4d\u7f6e\uff1a|\u7c7b\u578b\uff1a";
        pat = Pattern.compile(reg);
        mat = pat.matcher(str);
        repickStr = mat.replaceAll(EMPTY).replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", " ").replace("\u65f6", ":").replace("\u5206", ":").replace("\u79d2", " ");
        System.out.println("\u53bb\u7279\u5b9a\u5b57\u7b26\u540e:" + repickStr);
        for (String s : tmpA = StringUtils.stringSplit("10/20", "-|\u6708|/")) {
            System.out.println("s:" + s);
        }
        date_regexp = "\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}";
        for (String s : tmpArr = StringUtils.getDateFormatMatcher("\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668", date_regexp)) {
            System.out.println("s:" + s);
        }
        p = Pattern.compile("\\d{3}|\\d{2}:\\d{2}|\\d{2}-\\d{2}");
        str = "\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668";
        m = p.matcher(str);
        while (m.find()) {
            deviceid = m.group();
            System.out.println("deviceid:" + deviceid);
        }
        str = "\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668";
        String regexp = "\\d{2}-\\d{2} \\d{2}:\\d{2}|\\d{2}-\\d{2}|\\d{2}:\\d{2}|\\d{3}";
        String[] tmpA1 = regexp.split("\\|", 100);
        ArrayList ls = new ArrayList();
        HashMap<String, String> tmap = new HashMap<String, String>();
        String value = EMPTY;
        for (String exp : tmpA1) {
            p = Pattern.compile(exp);
            m = p.matcher(str);
            while (m.find()) {
                value = m.group();
                System.out.println("deviceid==:" + value);
                tmap = new HashMap();
                tmap.put("regexp", exp);
                tmap.put("value", value);
                ls.add(tmap);
            }
        }
        for (Object e : ls) {
            HashMap map = (HashMap)e;
            System.out.println("regexp:" + map.get("regexp"));
            System.out.println("value:" + map.get("value"));
        }
        String y = "2016".substring(2);
        System.out.println("y:" + y);
        str = "\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 2016-11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668";
        HashMap hashMap = StringUtils.getOptimalMatchingDate(str);
        for (Object key : hashMap.keySet()) {
            System.out.println("key= " + key + " and value= " + hashMap.get(key));
        }
        System.out.println("==================================================");
        str = "\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 2016-11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668";
        List ls1 = StringUtils.getMatchAllDate(str);
        for (Object obj : ls1) {
            HashMap hashMap2 = (HashMap)obj;
            for (Object key : hashMap2.keySet()) {
                System.out.println("key= " + key + " and value= " + hashMap2.get(key));
            }
            System.out.println();
        }
        str = "\u706b\u8b66\u8bb0\u5f55 065\u53f7 001 2016-11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668 \u706b\u8b66\u8bb0\u5f55 065\u53f7 001 2016-11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668 \u706b\u8b66\u8bb0\u5f55 065\u53f7 001 16-11-21 15:06  \u53a8\u623f \u611f\u70df\u63a2\u6d4b\u5668";
        System.out.println("==================================================");
        p = Pattern.compile(StringUtils.getDateRegExp());
        m = p.matcher(str);
        while (m.find()) {
            value = m.group();
            System.out.println("deviceid==:" + value);
        }
        System.out.println("getMatchAllDate==:" + StringUtils.getMatchAllDate(str));
        System.out.println("getMatchAllDeviceId==:" + StringUtils.getMatchAllDeviceId(str));
        str = "002-013 \u8f93\u51fa\u6a21\u5757 \u901a\u8baf\u6545\u969c 16-11-30 14:30 \u5939\u5c42\u5546\u573a\u5377\u5e18\u95e8 002-023 \u8f93\u51fa\u6a21\u5757 \u901a\u8baf\u6545\u969c 16-11-30 14:30 \u5939\u5c42\u5546\u573a\u9632\u706b\u9600 002-056 \u5149\u7535\u611f\u70df \u901a\u8baf\u6545\u969c 16-11-30 14:30 \u5939\u5c42\u5546\u573a\u70df\u611f 002-070 \u5149\u7535\u611f\u70df \u901a\u8baf\u6545\u969c 16-";
        str = "16\u5e7412\u670806\u65e516\u65f603\u5206 \u70df\u611f              1\u673a03\u8def063 \u706b\u8b66  1\u680b 1\u5c42\u5546\u94fa\ue810\ue810";
        str = "2016/12/06 16:06\u8d1f\u4e8c\u7535\u68af\u5927\u5385\u95e8\u53e3016\u56de\u8def253\u5730\u5740\u8bbe\u5907\u6545\u969c";
        str = "9 2016/12/06 16:06\u8d1f\u4e8c\u7535\u68af\u5927\u5385\u95e8\u53e3016\u56de\u8def253\u5730\u5740\u8bbe\u5907\u6545\u969c";
        str = "92016/12/06 16:06\u8d1f\u4e8c\u7535\u68af\u5927\u5385\u95e8\u53e3016\u56de\u8def253\u5730\u5740\u8bbe\u5907\u6545\u969c";
        System.out.println("========================1==========================");
        StringUtils.dataDeal(str);
        System.out.println("=========================2=========================");
        String t = "\u25a0 \u25a0\uff46\uff46\uff41\uff43\u25cf\u25cf\u25b3\u203b\u25cb\u25cb\u2606\u2116ccc";
        System.out.println(t);
        System.out.println(StringUtils.toSemiangle(t));
        System.out.println(StringUtils.trimToEmpty(" a,b ,c "));
        String s = "nihao\uff48\uff4b\u3000\uff5c\u3000\u3000\u3000\uff4e\uff49\uff48\uff45\uff48\uff45\u3000\uff0c\u3002\u3000\uff17\uff18\u3000\u3000\uff17\u3000";
        s = "\uff2e\uff10\uff11\uff0d\uff15\uff10\uff11\uff18\uff3a\uff15\uff13\uff11\u3000";
        System.out.println(StringUtils.fullWidth2halfWidth(s));
        System.out.println(StringUtils.qj2bj(s));
        System.out.println(StringUtils.bj2qj(s));
        str = "N01-5018Z531 \u706b\u8b66  2016-11-21 15:06  \u53a8\u623f\u611f\u70df\u63a2\u6d4b\u5668";
        str = "\uff12\uff10\uff11\uff16\u5e74\uff11\uff11\u6708\uff12\uff15\u65e5\uff10\uff17\uff1a\uff14\uff15\u7cfb\u7edf\u6545\u969c\uff2f\uff26\uff26\u626c\u58f0\u5668\u8131\u843d";
        str = "\uff12\uff10\uff11\uff16\u5e74\uff11\uff11\u6708\uff12\uff15\u65e5\uff10\uff17\uff1a\uff14\uff15\u4e3b\u97f3\u54cd\u505c\u6b62";
        str = StringUtils.fullWidth2halfWidth(str);
        System.out.println("==================================================");
        System.out.println("str==:" + str);
        p = Pattern.compile(StringUtils.getDateRegExp());
        m = p.matcher(str);
        while (m.find()) {
            value = m.group();
            System.out.println("deviceid==:" + value);
        }
        str = "9 2016/12/06 16:06\u8d1f\u4e8c\u7535\u68af\u5927\u5385\u95e8\u53e3016\u56de\u8def253\u5730\u5740\u8bbe\u5907\u6545\u969c";
        str = "92016/12/06 16:06\u8d1f\u4e8c\u7535\u68af\u5927\u5385\u95e8\u53e3016\u56de\u8def253\u5730\u5740\u8bbe\u5907\u6545\u969c";
        str = "8\u4e8b\u4ef6:\u5668\u4ef6\u6545\u969c\u7f16\u53f7:0002208\u7c7b\u578b:\u76d1\u7ba1\u8f93\u5165\u5730\u70b9:10\u5c42\u4fe1\u53f7\u9600\u65f6\u95f4:2016/12/06 16:12";
        str = "@\u001c&\u5f00\u673a 16-12-06 16:40 ";
        str = "      18:25:06  10,12,2016 N001L08M026                     \u8ddf\u8e2a\u76d1\u89c6    \u4e8c\u5c42\u98ce\u9600\u53cd\u9988                  \u786e\u8ba4\u5de1\u66f4\u76d1\u63a7\u4fe1\u53f7".trim();
        str = "16\u5e7412\u670812\u65e507\u65f641\u5206 \u6e29\u611f      1\u673a01\u8def187 \u706b\u8b66  1\u680b 1\u5c42\u52a0\u5de5\u95f4\ue810";
        System.out.println("========================1==========================");
        StringUtils.dataDeal(str);
        System.out.println("=========================2=========================");
        str = StringUtils.StringFilterSpecificCharacter("8\u4e8b\u4ef6:\u5668\u4ef6\u6545\u969c\u7f16\u53f7:0002208\u7c7b\u578b:\u76d1\u7ba1\u8f93\u5165\u5730\u70b9:10\u5c42\u4fe1\u53f7\u9600\u65f6\u95f4:2016/12/06 16:12");
        str = "00\u673a01\u8def103\u53f7    1\u680b  4\u5c42\ue810\ue810\ue810\ue81010\u670811\u65e511\u65f622\u5206 \u706b\u8b6600\u673a01\u8def100\u53f7    1\u680b  5\u5c42\ue810\ue810\ue810\ue81010\u670811\u65e511\u65f622\u5206 \u706b\u8b6600\u673a01\u8def103\u53f7    1\u680b  4\u5c42\ue810\ue810\ue810\ue81011\u670801\u65e509\u65f656\u5206 \u706b\u8b6600\u673a01\u8def100\u53f7    1\u680b  5\u5c42\ue810";
        System.out.println("str==:" + str);
        System.out.println("getMatchDeviceIdRegexp==:" + StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDeviceIdRegExp()));
        System.out.println("getOptimalMatchingCount==:" + StringUtils.getOptimalMatchingCount(str, StringUtils.getDeviceIdRegExp()));
        String outexp = EMPTY;
        System.out.println("getOptimalMatchingCount==:" + StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp()));
        Regexp bean = new Regexp();
        bean = StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp());
        System.out.println("bean.getCount()==:" + bean.getCount());
        System.out.println("bean.getRegexp()==:" + bean.getRegexp());
    }

    static {
        StringUtils.PADDING[32] = "                                                                ";
        pattern = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        cPattern = new String[]{EMPTY, "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf"};
        cfPattern = new String[]{EMPTY, "\u89d2", "\u5206"};
        ZEOR = "\u96f6";
    }

    public static class Regexp {
        int count = 0;
        String regexp = "";

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }
    }
}

