/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    public static final long MS_ONE_DAY = 86400000L;
    public static final long MS_DAY_FROM = 28800000L;
    private static final String FORMAT_STR = "yyyy-MM-dd HH:mm:ss";

    public static long clearTime(long time) {
        return (time + 28800000L) / 86400000L * 86400000L - 28800000L;
    }

    public static Date clearTime(Date d) {
        return new Date((d.getTime() + 28800000L) / 86400000L * 86400000L - 28800000L);
    }

    public static Date getDate(Date date, Time time) {
        return new Date(TimeUtil.clearTime(date.getTime()) + time.getTime() + 28800000L);
    }

    public static long getDate(long date, long time) {
        return TimeUtil.clearTime(date) + time + 28800000L;
    }

    public static Timestamp getTimestamp() {
        Timestamp d = new Timestamp(System.currentTimeMillis());
        return d;
    }

    public static Timestamp getTimestamp(long stamp) {
        Timestamp d = new Timestamp(stamp);
        return d;
    }

    public static String timeStampToString(long stamp) {
        Timestamp d = new Timestamp(stamp);
        String dateString = "";
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STR);
            dateString = formatter.format(stamp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateString;
    }

    public static Timestamp getTimestamp(Date date, Time time) {
        return new Timestamp(TimeUtil.clearTime(date.getTime()) + time.getTime() + 28800000L);
    }

    public static Timestamp getTimestamp(Timestamp stamp, Time time) {
        return new Timestamp(TimeUtil.clearTime(stamp.getTime()) + time.getTime() + 28800000L);
    }

    public static Timestamp getTimestamp(String dateStr) {
        return TimeUtil.getTimestamp(dateStr, FORMAT_STR);
    }

    public static Timestamp getTimestamp(String dateStr, String fmt) {
        SimpleDateFormat sf = new SimpleDateFormat(fmt);
        Timestamp tm = null;
        try {
            dateStr = dateStr.replace("0A", "10");
            java.util.Date date = sf.parse(dateStr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            tm = new Timestamp(cal.getTimeInMillis());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tm;
    }

    public static Timestamp formatTimeEight(String dateStr, String fmt) {
        SimpleDateFormat sf = new SimpleDateFormat(fmt);
        Timestamp tm = null;
        try {
            dateStr = dateStr.replace("0A", "10");
            java.util.Date date = sf.parse(dateStr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            tm = new Timestamp(cal.getTimeInMillis() + 28800000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tm;
    }

    public static String formatTimeEight(String time) throws Exception {
        java.util.Date d = null;
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd\u00a0HH:mm:ss");
        d = sd.parse(time);
        long rightTime = d.getTime() + 28800000L;
        String newtime = sd.format(rightTime);
        return newtime;
    }

    private static String conversion(int field) {
        String str = field < 10 ? "0" + field : field + "";
        return str;
    }

    private static String AM_MPTime(int field, int isRest) {
        String str = isRest == 1 ? field + 12 + "" : field + "";
        return str;
    }

    public static String getSystemTime() {
        GregorianCalendar date = new GregorianCalendar();
        StringBuffer str = new StringBuffer();
        int year = date.get(1);
        String month = TimeUtil.conversion(date.get(2) + 1);
        String day = TimeUtil.conversion(date.get(5));
        String hour = TimeUtil.AM_MPTime(date.get(10), date.get(9));
        String minute = TimeUtil.conversion(date.get(12));
        String second = TimeUtil.conversion(date.get(13));
        str.append(year);
        str.append(month);
        str.append(day);
        str.append(hour);
        str.append(minute);
        str.append(second);
        return str.toString();
    }

    public static String getLocalTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_STR);
        return sdf.format(new java.util.Date());
    }

    public static String getNoYearTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return sdf.format(new java.util.Date());
    }

    public static long getTimeMillis(String dateTimeString) {
        SimpleDateFormat dateformat = new SimpleDateFormat(FORMAT_STR);
        long time = 0L;
        try {
            time = dateformat.parse(dateTimeString).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static Timestamp getFullDateTimeString(String dateTimeString, String dataTimeFormats) {
        String[] tmpAtr = new String[]{"19990101", "010101"};
        String dateSimeStr = "";
        String regexp = "[`~!@#$%^&*()+|{}':;',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u5e74\u6708\u65e5\u65f6\u5206\u79d2 ]";
        Calendar a = Calendar.getInstance();
        if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            dateSimeStr = dateTimeString + "00\u79d2";
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)).substring(0, 2) + dateTimeString + ":00";
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)).substring(0, 2) + dateTimeString;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = a.get(1) + m + d + h + s + "00";
        } else if ("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = a.get(1) + m + d + h + s + ss;
        } else if ("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = a.get(1) + m + d + h + s + "00";
        } else if ("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = a.get(1) + m + d + h + s + ss;
        } else if ("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = a.get(1) + m + d + h + s + "00";
        } else if ("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = a.get(1) + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)).substring(0, 2) + dateTimeString;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1)).substring(0, 2) + tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = a.get(1) + "/" + dateTimeString + ":00";
        } else if ("\\d{2}\\/\\d{2}\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = a.get(1) + "/" + dateTimeString + ":00";
        } else if ("\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)).substring(0, 2) + dateTimeString + ":00";
        } else if ("\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = a.get(1) + "-" + dateTimeString + ":00";
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = a.get(1) + m + d + h + s + "00";
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = a.get(1) + m + d + h + s + "00";
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = a.get(1) + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = a.get(1) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708 \\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1)).substring(0, 2) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1)).substring(0, 2) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1));
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1)).substring(0, 2) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{2}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[3].trim();
            String m = tmpA[4].trim();
            String d = tmpA[5].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{4}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[3].trim();
            String m = tmpA[4].trim();
            String d = tmpA[5].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        } else if ("\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[5].trim();
            String m = tmpA[4].trim();
            String d = tmpA[3].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(a.get(1)).substring(0, 2) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = y + m + d + h + s + ss;
        }
        dateSimeStr = StringUtils.StringFilterSpecificCharacter(regexp, dateSimeStr);
        return TimeUtil.getTimestamp(dateSimeStr, "yyyyMMddHHmmss");
    }

    public static Timestamp getFullDateTimeString(String dateTimeString, String dataFormats, String timeFormats) {
        String[] timeFormat;
        String[] dayFormats;
        String[] tmpAtr = new String[]{"19990101", "010101"};
        String dateStr = "";
        String timeStr = "";
        if (dateTimeString.indexOf(" ") > 0) {
            tmpAtr = dateTimeString.split(" ");
            dateStr = tmpAtr[0];
            timeStr = tmpAtr[1];
        } else if (dateTimeString.indexOf("\u65e5") > 0) {
            tmpAtr = dateTimeString.split("\u65e5");
            dateStr = tmpAtr[0] + "\u65e5";
            timeStr = tmpAtr[1];
        } else {
            return TimeUtil.getTimestamp("19990101010101", "yyyyMMddHHmmss");
        }
        Calendar a = Calendar.getInstance();
        for (String date_format : dayFormats = dataFormats.split("\\|", 100)) {
            String[] tmp;
            String d;
            String m;
            String y;
            String d2;
            String m2;
            String[] tmpA;
            if ("MMDD".equalsIgnoreCase(date_format = StringUtils.StringFilterNoColon(date_format).toString())) {
                dateStr = a.get(1) + StringUtils.StringFilter(dateStr);
            } else if ("M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u6708|/");
                m2 = tmpA[0];
                m2 = StringUtils.leftAppendZero(m2, 2);
                d2 = StringUtils.removeChinese(tmpA[1]);
                d2 = StringUtils.leftAppendZero(d2, 2);
                dateStr = a.get(1) + StringUtils.StringFilter(m2 + d2);
            } else if ("MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u6708|/");
                m2 = tmpA[0];
                m2 = StringUtils.leftAppendZero(m2, 2);
                d2 = StringUtils.removeChinese(tmpA[1]);
                d2 = StringUtils.leftAppendZero(d2, 2);
                dateStr = a.get(1) + StringUtils.StringFilter(m2 + d2);
            } else if ("YYMMDD".equalsIgnoreCase(date_format)) {
                dateStr = String.valueOf(a.get(1)).substring(0, 2) + StringUtils.StringFilter(dateStr);
            } else if ("YY\u5e74M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u5e74|\u6708|\u65e5|/");
                y = tmpA[0];
                m = tmpA[1];
                d = tmpA[2];
                m = StringUtils.leftAppendZero(m, 2);
                d = StringUtils.leftAppendZero(d, 2);
                dateStr = a.get(1) + StringUtils.StringFilter(y + m + d);
            } else if ("YY\u5e74MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                dateStr = String.valueOf(a.get(1)).substring(0, 2) + StringUtils.StringFilterSpecificCharacter("\u5e74|\u6708|\u65e5", dateStr);
            } else if ("YYYY\u5e74M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u5e74|\u6708|\u65e5|/");
                y = tmpA[0];
                m = tmpA[1];
                d = tmpA[2];
                m = StringUtils.leftAppendZero(m, 2);
                d = StringUtils.leftAppendZero(d, 2);
                dateStr = a.get(1) + StringUtils.StringFilter(y + m + d);
            } else if ("YYYY\u5e74MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                dateStr = StringUtils.StringFilterSpecificCharacter("\u5e74|\u6708|\u65e5", dateStr);
            } else if ("DDMM".equalsIgnoreCase(date_format)) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = dateStr.substring(2, 4) + dateStr.substring(0, 2);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = a.get(1) + tmp[1] + tmp[0];
                }
            } else if ("YYYYMMDD".equalsIgnoreCase(date_format)) {
                dateStr = StringUtils.StringFilter(dateStr);
            } else if ("MMDDYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = dateStr.substring(4, 8) + dateStr.substring(0, 2) + dateStr.substring(2, 4);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = tmp[2] + tmp[0] + tmp[1];
                }
            } else if ("DDMMYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = dateStr.substring(4, 8) + dateStr.substring(2, 4) + dateStr.substring(0, 2);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = tmp[2] + tmp[1] + tmp[0];
                }
            } else if ("YYYYDDMM".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = dateStr.substring(0, 4) + dateStr.substring(6, 8) + dateStr.substring(4, 6);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = tmp[2] + tmp[1] + tmp[0];
                }
            } else {
                dateStr = "19990101";
            }
            if (!dateStr.equals("19990101")) break;
        }
        for (String time_format : timeFormat = timeFormats.split("\\|", 100)) {
            time_format = StringUtils.StringFilter(time_format).toString();
            if (timeStr.indexOf("\u65f6") > 0) {
                String regEx = "\u65f6|\u5206|\u79d2";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(timeStr);
                timeStr = m.replaceAll("").trim();
            }
            if (timeStr.indexOf(":") > 0) {
                tmpAtr = timeStr.split(":");
                timeStr = tmpAtr.length >= 3 ? StringUtils.leftAppendZero(tmpAtr[0], 2) + StringUtils.leftAppendZero(tmpAtr[1], 2) + StringUtils.leftAppendZero(tmpAtr[2], 2) : (tmpAtr.length == 2 ? StringUtils.leftAppendZero(tmpAtr[0], 2) + StringUtils.leftAppendZero(tmpAtr[1], 2) + "00" : (tmpAtr.length == 1 ? StringUtils.leftAppendZero(tmpAtr[0], 2) + StringUtils.leftAppendZero(tmpAtr[1], 2) + StringUtils.leftAppendZero(tmpAtr[2], 2) : "00:00:00"));
            }
            if (!(timeStr = "HHmm".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) + "00" : ("HHmmss".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) : ("HHmi".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) + "00" : ("HHmiss".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) : "010101")))).equals("010101")) break;
        }
        return TimeUtil.getTimestamp(dateStr + timeStr, "yyyyMMddHHmmss");
    }

    public static Long getMillis1() {
        return System.currentTimeMillis();
    }

    public static Long date2Millis(Date date) {
        return date.getTime();
    }

    public static Long calendar2Millis(Calendar calendar) {
        return calendar.getTime().getTime();
    }

    public static Long string2Millis(String dateStr, String formatStr) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr);
            return simpleDateFormat.parse(dateStr).getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Long getMillis2() {
        return Instant.now().toEpochMilli();
    }

    public static Long localDateTime2Millis(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long localDate2Millis(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MIN).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long clock2Millis(Clock clock) {
        return clock.millis();
    }

    public static Long zoneDateTime2Millis(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDateTime().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long string2MillisWithJDK8(String dateStr, String formatStr) {
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(formatStr)).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long DateString2MillisWithJDK8(String dateStr) {
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(FORMAT_STR)).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static boolean isValidDate(String str) {
        try {
            if (str != null && !str.equals("")) {
                if (str.length() == 8) {
                    int vDay;
                    String units4Day;
                    int vUnits4Day;
                    boolean isLeapYear = false;
                    String year = str.substring(0, 4);
                    String month = str.substring(4, 6);
                    String day = str.substring(6, 8);
                    int vYear = Integer.parseInt(year);
                    if (vYear < 1900 || vYear > 2200) {
                        return false;
                    }
                    if (vYear % 4 == 0 && vYear % 100 != 0 || vYear % 400 == 0) {
                        isLeapYear = true;
                    }
                    if (month.startsWith("0")) {
                        String units4Month = month.substring(1, 2);
                        int vUnits4Month = Integer.parseInt(units4Month);
                        if (vUnits4Month == 0) {
                            return false;
                        }
                        if (vUnits4Month == 2) {
                            int vDays4February = Integer.parseInt(day);
                            if (isLeapYear ? vDays4February > 29 : vDays4February > 28) {
                                return false;
                            }
                        }
                    } else {
                        int vMonth = Integer.parseInt(month);
                        if (vMonth != 10 && vMonth != 11 && vMonth != 12) {
                            return false;
                        }
                    }
                    return !(day.startsWith("0") ? (vUnits4Day = Integer.parseInt(units4Day = day.substring(1, 2))) == 0 : (vDay = Integer.parseInt(day)) < 10 || vDay > 31);
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isValidDateTime(String time) {
        return TimeUtil.isValidDateTime(time, FORMAT_STR) || TimeUtil.isValidDateTime(time, "yyyy-MM-ddHH:mm:ss");
    }

    public static boolean isValidDateTime(String time, String dateFormat) {
        try {
            SimpleDateFormat sss = new SimpleDateFormat(dateFormat);
            sss.parse(time.trim());
            String[] ss = time.trim().split("[-: ]");
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            if (dateFormat.equalsIgnoreCase(FORMAT_STR)) {
                year = Integer.valueOf(ss[0]);
                month = Integer.valueOf(ss[1]);
                day = Integer.valueOf(ss[2]);
                hour = Integer.valueOf(ss[3]);
                minute = Integer.valueOf(ss[4]);
                second = Integer.valueOf(ss[5]);
            } else if (dateFormat.equalsIgnoreCase("yyyy-MM-ddHH:mm:ss")) {
                year = Integer.valueOf(ss[0]);
                month = Integer.valueOf(ss[1]);
                day = Integer.valueOf(ss[2].substring(0, 2));
                hour = Integer.valueOf(ss[2].substring(2));
                minute = Integer.valueOf(ss[3]);
                second = Integer.valueOf(ss[4]);
            } else {
                return false;
            }
            if (year < 1 || year > 2099 || month < 1 || month > 12) {
                return false;
            }
            int[] monthLengths = new int[]{0, 31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
            monthLengths[2] = TimeUtil.isLeapYear(year) ? 29 : 28;
            int monthLength = monthLengths[month];
            if (day < 1 || day > monthLength) {
                return false;
            }
            return hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59 && second >= 0 && second <= 59;
        }
        catch (ParseException e) {
            System.out.println("---------------- time:" + time + "  dateFormat:" + dateFormat);
            return false;
        }
        catch (NumberFormatException e) {
            System.out.println("+++++++++++++ time:" + time + "  dateFormat:" + dateFormat);
            return false;
        }
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static void main(String[] args) {
        System.out.println(TimeUtil.isValidDateTime(" 2020-06-08 15:54:41", FORMAT_STR));
    }
}

