/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.web.servlet;

import com.vcarecity.savedb.BatchSaveDB;
import com.vcarecity.savedb.cache.DataCache;
import com.vcarecity.savedb.web.WebServer;
import com.vcarecity.savedb.web.util.JsonUtil;
import com.vcarecity.savedb.writer.OracleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoadInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String method = request.getParameter("method");
        if ("cache".equals(method)) {
            this.loadCacheInfo(request, response);
        } else if ("writer".equals(method)) {
            this.loadWriterInfo(request, response);
        }
    }

    private void loadCacheInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BatchSaveDB batchSave = WebServer.getBatchSave();
        List<DataCache> cacheList = batchSave.getCacheList();
        ArrayList list = new ArrayList();
        for (int i = 0; i < cacheList.size(); ++i) {
            DataCache cache = cacheList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", cache.getName());
            map.put("maxCacheSize", cache.getMaxCacheSize());
            map.put("totalDataSize", cache.getTotalDataSize());
            map.put("currentDataSize", cache.getCurrentDataSize());
            map.put("throwedDataSize", cache.getThrowedDataSize());
            list.add(map);
        }
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
        resMap.put("list", list);
        resMap.put("count", Integer.valueOf(list.size()));
        JsonUtil.responseJsonObject(response, resMap);
    }

    private void loadWriterInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BatchSaveDB batchSave = WebServer.getBatchSave();
        List<OracleWriter> writerList = batchSave.getWriterList();
        ArrayList list = new ArrayList();
        for (int i = 0; i < writerList.size(); ++i) {
            OracleWriter writer = writerList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", writer.getName());
            map.put("totalDataSize", writer.getTotalDataSize());
            list.add(map);
        }
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
        resMap.put("list", list);
        resMap.put("count", Integer.valueOf(list.size()));
        JsonUtil.responseJsonObject(response, resMap);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

