/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class CmdResponseWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    JedisDBUtil jedisUtil = null;
    Unit unitBean = null;

    @Override
    public void init() throws Exception {
        this.log = Logger.getLogger();
        this.unitBean = new Unit();
        this.jedisUtil = JedisDBUtil.getInstance();
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        this.doSave(list);
    }

    public void save2Redis(Object cmdResponse) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("cmdResponse", ((JSONObject)cmdResponse).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doSave(List<Object> list) {
        block26: {
            PreparedStatement pst;
            Connection con;
            block25: {
                con = null;
                pst = null;
                int batchCount = 0;
                String gatewayNo = "";
                String unitNo = "";
                String sn = "";
                String protocolNo = "";
                String functionWord = "";
                String equipmentNo = "";
                String deviceId = "";
                long beginTime = System.currentTimeMillis();
                int pIndex = 0;
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_UPDATE_CMD_RECORD_V4(?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject msg = (JSONObject)list.get(i);
                    if (msg == null) {
                        System.out.println("doSave msg==null list:" + list);
                        continue;
                    }
                    this.log.writeDebugLog("\u6307\u4ee4\u56de\u5e94cmdResponse:" + msg.toString());
                    try {
                        StringBuffer cb = new StringBuffer();
                        cb.append("/0");
                        gatewayNo = msg.getString("gatewayNo");
                        unitNo = msg.getString("unitNo");
                        protocolNo = msg.getString("protocolNo");
                        functionWord = msg.getString("functionWord");
                        equipmentNo = msg.getString("equipmentNo");
                        sn = msg.getString("SN");
                        if (StringUtil.isNotBlank((String)unitNo)) {
                            cb.append("/" + unitNo);
                            deviceId = unitNo;
                        }
                        if (StringUtil.isNotBlank((String)equipmentNo) && !"0".equals(equipmentNo)) {
                            cb.append("/" + equipmentNo);
                            deviceId = equipmentNo;
                        }
                        if (!msg.has("dataItems")) continue;
                        JSONArray dataItems = msg.getJSONArray("dataItems");
                        for (Object object : dataItems) {
                            JSONObject dataItem = (JSONObject)object;
                            JSONObject data = dataItem.getJSONObject("data");
                            if (!data.has("ret")) continue;
                            String ret = data.getString("ret");
                            if ("0".equals(ret) || "0.0".equals(ret)) {
                                pIndex = 1;
                                pst.setString(pIndex++, protocolNo);
                                pst.setInt(pIndex++, Integer.parseInt(functionWord));
                                pst.setString(pIndex++, sn);
                                pst.setString(pIndex++, unitNo);
                                pst.setInt(pIndex++, 0);
                                pst.setString(pIndex++, msg.toString());
                                pst.addBatch();
                                this.jedisUtil.set(1, unitNo, gatewayNo + ",1," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                                this.unitBean.updateUnitOnline(gatewayNo, protocolNo, equipmentNo, unitNo, "1");
                                ++batchCount;
                            }
                            if (batchCount < this.batchSize) continue;
                            pst.executeBatch();
                            con.commit();
                            batchCount = 0;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        this.log.writeErrorLog(msg.toString());
                        e.printStackTrace();
                    }
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
                if (con == null) break block25;
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IOUtil.closeDB(null, pst, con);
            break block26;
            catch (NumberFormatException e) {
                e.printStackTrace();
                break block26;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block26;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
            }
        }
    }
}

