/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.jms.JMSException;
import net.sf.json.JSONObject;

public class HeartBeatWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    Unit unitBean = null;
    JedisDBUtil JedisUtil = null;
    private static int db = 1;

    public HeartBeatWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        this.log = Logger.getLogger();
        this.JedisUtil = JedisDBUtil.getInstance();
        this.unitBean = new Unit();
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        this.doSave(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save2Redis(List<Object> list) {
        long beginTime = System.currentTimeMillis();
        String gatewayNo = "";
        String unitNo = "";
        String protocolNo = "";
        String functionWord = "";
        String equipmentNo = "";
        String deviceId = "";
        Object tm = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                JSONObject msg = (JSONObject)list.get(i);
                if (msg == null) continue;
                this.log.writeDebugLog("\u5fc3\u8df3\u6570\u636e:" + msg.toString());
                gatewayNo = msg.getString("gatewayNo");
                unitNo = msg.getString("unitNo");
                this.JedisUtil.set(db, unitNo, gatewayNo + ",1," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
            }
            long endTime = System.currentTimeMillis();
            long costTime = (endTime - beginTime) / 1000L;
            this.log.writeDebugLog("HeartBeatWriter \u672c\u6b21\u5904\u7406 " + list.size() + " \u6761,\u8017\u65f6: " + costTime + " \u79d2");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doSave(List<Object> list) {
        long beginTime;
        block21: {
            PreparedStatement pst;
            Connection con;
            block20: {
                beginTime = System.currentTimeMillis();
                con = null;
                pst = null;
                int batchCount = 0;
                String gatewayNo = "";
                String unitNo = "";
                String protocolNo = "";
                String functionWord = "";
                String equipmentNo = "";
                String deviceId = "";
                Object tm = null;
                int pIndex = 0;
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_UPDATE_UNIT_ONLINE(?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject msg = (JSONObject)list.get(i);
                    if (msg == null) continue;
                    this.log.writeDebugLog("\u5fc3\u8df3\u6570\u636e:" + msg.toString());
                    try {
                        gatewayNo = msg.getString("gatewayNo");
                        unitNo = msg.getString("unitNo");
                        if ("DEBUG".equalsIgnoreCase(this.log.getLevel()) && !unitNo.equals("4442832E823C")) continue;
                        Object tmpArr = null;
                        Object online = null;
                        this.JedisUtil.set(db, unitNo, gatewayNo + ",1," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                        protocolNo = msg.getString("protocolNo");
                        functionWord = msg.getString("functionWord");
                        equipmentNo = "0";
                        equipmentNo = "HeartBeatWriter";
                        pIndex = 1;
                        pst.setString(pIndex++, gatewayNo);
                        pst.setString(pIndex++, protocolNo);
                        pst.setString(pIndex++, equipmentNo);
                        pst.setString(pIndex++, unitNo);
                        pst.setInt(pIndex++, 1);
                        pst.setLong(pIndex++, this.unitBean.getUnitId(unitNo));
                        pst.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        pst.executeBatch();
                        con.commit();
                        batchCount = 0;
                        continue;
                    }
                    catch (Exception e) {
                        this.log.writeErrorLog(msg.toString());
                        e.printStackTrace();
                    }
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
                if (con == null) break block20;
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IOUtil.closeDB(null, pst, con);
            break block21;
            catch (NumberFormatException e) {
                e.printStackTrace();
                break block21;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block21;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
            }
        }
        long endTime = System.currentTimeMillis();
        long costTime = (endTime - beginTime) / 1000L;
        this.log.writeDebugLog("HeartBeatWriter \u8017\u65f6:" + costTime + "\u79d2");
    }

    public static void main(String[] args) throws JMSException, Exception {
    }
}

