/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.JedisUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.DtuHistory;
import com.vcarecity.savedb.util.HttpRequestUtil;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.jms.JMSException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class IPCDataWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    DtuHistory dtuHistoryBean = null;
    HttpRequestUtil httpRequest = null;

    public IPCDataWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        this.log = Logger.getLogger();
        this.dtuHistoryBean = new DtuHistory();
        this.httpRequest = HttpRequestUtil.getHttpRequest();
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        this.doSave(list);
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("msg", alarmInfo.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doSave(List<Object> list) {
        long beginTime;
        block22: {
            PreparedStatement pst;
            Connection con;
            block21: {
                beginTime = System.currentTimeMillis();
                System.out.println("IPCDataWriter list:" + list.toString());
                con = null;
                pst = null;
                int batchCount = 0;
                String deviceid = "";
                String p2pid = "";
                String algid = "";
                String timestamp = "";
                String image_url = "";
                String appendix = "";
                int pIndex = 0;
                long count = 0L;
                int size = 0;
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_INSERTT_HISTORY_IPCDATA(?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                size = list.size();
                for (Object obj : list) {
                    JSONObject msg = null;
                    if (obj == null) continue;
                    msg = (JSONObject)obj;
                    try {
                        JSONArray rows = msg.getJSONArray("rows");
                        for (Object object : rows) {
                            JSONObject row = (JSONObject)object;
                            this.log.writeDebugLog("row:" + row.toString());
                            deviceid = row.getString("deviceid");
                            p2pid = row.getString("p2pid");
                            algid = row.getString("algid");
                            timestamp = row.getString("timestamp");
                            image_url = row.getString("image_url");
                            appendix = row.getString("appendix");
                            pIndex = 1;
                            pst.setString(pIndex++, deviceid);
                            pst.setString(pIndex++, p2pid);
                            pst.setString(pIndex++, algid);
                            pst.setString(pIndex++, timestamp);
                            pst.setString(pIndex++, image_url);
                            pst.setString(pIndex++, appendix);
                            pst.addBatch();
                            if (++batchCount < this.batchSize) continue;
                            pst.executeBatch();
                            con.commit();
                            batchCount = 0;
                        }
                    }
                    catch (Exception e) {
                        this.log.writeErrorLog(e.getMessage());
                        this.log.writeErrorLog("list.toString():" + list.toString());
                        e.printStackTrace();
                    }
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
                if (con == null) break block21;
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IOUtil.closeDB(null, pst, con);
            break block22;
            catch (NumberFormatException e) {
                e.printStackTrace();
                break block22;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
            }
        }
        long endTime = System.currentTimeMillis();
        long costTime = (endTime - beginTime) / 1000L;
        this.log.writeDebugLog("IPCDataWriter \u8017\u65f6:" + costTime + "\u79d2");
    }

    public static void main(String[] args) throws JMSException, Exception {
        JedisUtil jedisUtil = JedisUtil.getInstance();
    }
}

