/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.DtuHistory;
import com.vcarecity.savedb.decode.Decode;
import com.vcarecity.savedb.util.DigitalTransUtil;
import com.vcarecity.savedb.util.HexUtil;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.PropertiesUtil;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class MsgWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    JedisDBUtil JedisUtil = null;
    Decode decodebean = null;
    private int system_no = 0;

    public MsgWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        this.log = Logger.getLogger();
        this.JedisUtil = JedisDBUtil.getInstance();
        this.system_no = Integer.parseInt(PropertiesUtil.getValue("config/sys.properties", "system_no"));
        this.decodebean = new Decode();
        this.decodebean.AddDecode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            if (list != null) {
                this.doSave(list);
            }
        }
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("msg", alarmInfo.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doSave(List<Object> list) {
        long beginTime;
        block28: {
            PreparedStatement pst;
            Connection con;
            block27: {
                beginTime = System.currentTimeMillis();
                Logger.writeConsleLog("MsgWriter beginTime:" + beginTime);
                con = null;
                pst = null;
                int batchCount = 0;
                String gatewayNo = "";
                String unitNo = "";
                String protocolNo = "";
                String functionWord = "";
                String equipmentNo = "";
                String deviceId = "";
                Object tm = null;
                int pIndex = 0;
                long count = 0L;
                boolean size = false;
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_INSERTT_HISTORY(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                block17: for (Object odata : list) {
                    JSONObject msg = null;
                    if (odata == null) continue;
                    msg = (JSONObject)odata;
                    this.log.writeDebugLog("msg:" + msg.toString());
                    try {
                        StringBuffer cb = new StringBuffer();
                        cb.append("/0");
                        gatewayNo = msg.getString("gatewayNo");
                        unitNo = msg.getString("unitNo");
                        protocolNo = msg.getString("protocolNo");
                        functionWord = msg.getString("functionWord");
                        if (msg.has("equipmentNo")) {
                            equipmentNo = msg.getString("equipmentNo");
                        }
                        if ("DEBUG".equalsIgnoreCase(this.log.getLevel()) && !unitNo.equals("YG861964043825889")) continue;
                        if (StringUtil.isNotBlank((String)unitNo)) {
                            cb.append("/" + unitNo);
                            deviceId = unitNo;
                        }
                        if (StringUtils.isNotBlank(unitNo) && unitNo.length() < 30) {
                            this.JedisUtil.set(1, unitNo, gatewayNo + ",1," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                        }
                        if (StringUtil.isNotBlank((String)equipmentNo) && !"0".equals(equipmentNo)) {
                            cb.append("/" + equipmentNo);
                            deviceId = equipmentNo;
                        }
                        JSONArray dataItems = msg.getJSONArray("dataItems");
                        for (Object object : dataItems) {
                            JSONObject dataItem = (JSONObject)object;
                            int id = Integer.valueOf(dataItem.getString("id"));
                            JSONObject data = dataItem.getJSONObject("data");
                            StringBuffer devicePath = new StringBuffer();
                            devicePath.append(cb.toString());
                            pIndex = 1;
                            pst.setInt(pIndex++, this.system_no);
                            Logger.writeConsleLog("\u6dfb\u52a0\u5f00\u59cb");
                            Decode decode = this.decodebean.getDecode(protocolNo);
                            boolean bl = decode.deCode(pst, gatewayNo, protocolNo, unitNo, equipmentNo, id, pIndex, count, devicePath, dataItem, data, msg);
                            if (!bl) continue;
                            if (id == 1538) {
                                String dataContent = data.getString("dataContent");
                                if (!HexUtil.isHexNumberRex(dataContent)) {
                                    this.log.writeErrorLog("dtu_no:" + unitNo + ",1538_dataContent:" + dataContent);
                                    continue block17;
                                }
                                String cnDataStr = DigitalTransUtil.hexStringToEncodeString(dataContent.trim(), "GBK");
                                new DtuHistory().insertDtuHistory(unitNo, dataContent, cnDataStr);
                            }
                            if (++batchCount < this.batchSize) continue;
                            Logger.writeConsleLog("MsgWriter \u5206\u6279\u6dfb\u52a0\u6267\u884c\u5f00\u59cb\uff0c\u672c\u6b21\u63d0\u4ea4\u8bb0\u5f55\u6570\uff1a" + batchCount);
                            pst.executeBatch();
                            Logger.writeConsleLog("MsgWriter \u5206\u6279\u63d0\u4ea4\u5f00\u59cb");
                            con.commit();
                            pst.clearBatch();
                            Logger.writeConsleLog("MsgWriter \u5206\u6279\u63d0\u4ea4\u7ed3\u675f");
                            batchCount = 0;
                        }
                    }
                    catch (Exception e) {
                        this.log.writeErrorLog(msg.toString());
                        e.printStackTrace();
                    }
                }
                if (batchCount > 0) {
                    Logger.writeConsleLog("MsgWriter \u6dfb\u52a0\u6267\u884c\u5f00\u59cb\uff0c\u672c\u6b21\u63d0\u4ea4\u8bb0\u5f55\u6570\uff1a" + batchCount);
                    pst.executeBatch();
                    Logger.writeConsleLog("MsgWriter \u63d0\u4ea4\u5f00\u59cb");
                    con.commit();
                    pst.clearBatch();
                    Logger.writeConsleLog("MsgWriter \u63d0\u4ea4\u7ed3\u675f");
                }
                if (con == null) break block27;
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            IOUtil.closeDB(null, pst, con);
            break block28;
            catch (NumberFormatException e) {
                e.printStackTrace();
                break block28;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                break block28;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
            }
        }
        long endTime = System.currentTimeMillis();
        long costTime = (endTime - beginTime) / 1000L;
        this.log.writeDebugLog("MsgWriter \u8017\u65f6:" + costTime + "\u79d2,\u5171\u63d0\u4ea4\u6761\u6570\uff1a" + list.size());
        Logger.writeConsleLog("MsgWriter \u8017\u65f6:" + costTime + "\u79d2,\u5171\u63d0\u4ea4\u6761\u6570\uff1a" + list.size());
    }

    public static void main(String[] args) throws JMSException, Exception {
        JedisDBUtil JedisUtil2 = JedisDBUtil.getInstance();
        MsgWriter bean = new MsgWriter();
        String unitDataParsingRule = JedisUtil2.hget(0, "manufacturerModelNo", "MANUFACTURER_MODEL_NO_14");
        System.out.println("unitDataParsingRule:" + unitDataParsingRule);
        HashMap hm = StringUtils.JSONObjectStringToHashMap(unitDataParsingRule);
        String cnDataStr = "\u706b\u8b66:01-069 \u5149\u7535\u611f\u70df 16-04-09 16:47 \u4e00\u5143\u5e97";
        cnDataStr = "04-15 16:04  000701 \u7535\u8bdd\u63d2\u5b54\u91ca\u653e";
        cnDataStr = "05-05 16:58  000000 \u590d\u4f4d \u64cd\u4f5c";
        cnDataStr = "\u6545\u969c 05-24 13:37 000064 \u5907\u7535\u6e90";
        cnDataStr = "\u706b\u8b66 03-17 10:15 081004   \u70b9\u578b\u611f\u6e29\u58f0\u5149\u62a5\u8b66 ";
        cnDataStr = "\u706b\u8b66 07-18 23:57 011026   \u70b9\u578b\u611f\u70df**********";
        cnDataStr = "5\u5c42\u975e\u70e4\u52ff\u6270525023    \u70b9\u578b\u611f\u70df\u706b\u8b66  7\u670826\u65e516:08";
        cnDataStr = "16/09/28 01:25:44 1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "16/09/28 01:25:44  \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f \u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u5149\u7535\u611f\u70df 02-05 \u901a\u8baf\u6545\u969c 16/03/31 07:27:01 \u5939\u5c42\u5546\u573a\u70df\u611f \u5149\u7535\u611f\u70df 02-03 \u901a\u8baf\u6545\u969c 16/03/31 07:28:03 \u5939\u5c42\u5546\u573a\u70df\u611f";
        cnDataStr = "\u706b\u8b6610F  \u5149\u7535\u63a2\u6d4b\u56682016.11.08   15:28:29   0103221";
        cnDataStr = StringUtils.StringFilterSpecificCharacter("8\u4e8b\u4ef6:\u5668\u4ef6\u6545\u969c\u7f16\u53f7:0002208\u7c7b\u578b:\u76d1\u7ba1\u8f93\u5165\u5730\u70b9:10\u5c42\u4fe1\u53f7\u9600\u65f6\u95f4:2016/12/06 16:12");
        cnDataStr = "\u706b\u8b66:002-094 \u5149\u7535\u611f\u70df 16-12-06 19:50 \u5730\u4e0b\u5ba4\u6cf5\u623f\u70df\u611f";
        cnDataStr = "\u706b\u8b66:01-161 \u5149\u7535\u611f\u70df 16-12-06 22:29 \u5927\u5802";
        cnDataStr = "\u590d\u4f4d 16-12-06 22:32 ";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988 16-12-07 04:45 B22-2";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988\u505c\u6b62 16-12-07 05:53 B22-2";
        cnDataStr = "\u706b\u8b66:002-050 \u5149\u7535\u611f\u70df 16-12-07 03:49 \u4e09\u697c\u8d70\u9053\u5de6\u70df\u611f";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988 16-12-07 06:26 B22-2";
        cnDataStr = "12/07 16:04 10-097\u624b\u52a8\u64a4\u6d8810\u5c42\u5e7f\u64ad\u6a21\u5757";
        String hex = "";
        hex = "2020CAB1BCE43A323031362F31312F32392031343A31303A30350D0A2020283030312D30363529303031B6B03034C7F83033B2E320303635BAC50D0A2020B5D8D6B7B6AACAA72120B9E2B5E7CCBDCDB720303033B7D6BBFA0D0A0D0A";
        hex = "31362F31302F32312031373A33303A333420BFAABBFA00";
        hex = "26BBFABAC5A3BA1C2E303120201C26BBD8C2B7A3BA1C2E30370A1C26B5E3BAC5A3BA1C2E303335201C26B7D6C7F8A3BA1C2E303035310A1C26C0E0D0CDA3BAB8D0D1CCCCBDCDB7201C26D7B4CCAC20BBF0BEAF0A1C26CAB1BCE4A3BA1C2E323031362E31322E30382030383A35390AC3E8CAF6A3BA1C26A3B5B2E3A3C1B6B0A3B5A3B1A3B8B7BF0A200A";
        hex = "B9CAD5CFCFFBB3FD39B2E3CEF7B5E7CCDDC7B0CAD22020B9E2B5E7CCBDB2E2C6F7B6AACAA7323031362E31322E303920202030383A32373A30362020203031303331353300";
        hex = "B9CAD5CF2020202020202020202020204946432D333033302020202020B5DA31BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020204E32543837202020202020202031383A31313A313820202020323031362D31322D370D0AB9CAD5CF2020202020202020202020204946432D333033302020202020B5DA33BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020";
        hex = "20202020202031303A34343A3239202031322C31322C32303136204E3030312020202020202020CFFBB7C0B1A8BEAF31BAC5D6F7BBFA2020202020202020202020202020CFB5CDB3B3F5CABCBBAF2020202020202020202020202020202020202020BBF0BEAFB9CAD5CFBCBAC7E5B3FD2020202020202020202020202020202000";
        hex = "31322D31332030383A3335202031313130353620B5E3D0CDB8D0D1CCB9CAD5CF20B7B9CCC33120C2A5C3C6B6A5B2E320";
        hex = "B9CAD5CF202020202020202020202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEACBBA4202020202020204E334C3244313820202020202032333A35303A323420202020323031372D312D330D0AB9CAD5CFB1A8BEAFBDE2B3FD20202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEAC";
        hex = "B1A8BEAF202020202020202020202020B8D0CEC2202020202020202020D6F7C2A5B6FEB2E3CEF7B2CDB3F8B7BF2028D6F7C2A5B6FEB2E3292020202020202020202020202020205A6F6E6520303036202020202020204E324C34443536202020202020393A35373A33352020202020323031372D312D340D0A";
        hex = "B1A8BEAF202020202020202020202020BBF0BEAFBCE0CAD32020202020C9CCD2B5D6D0D0C4D2BBB2E33423CAD6B6AFB1A8BEAFB0B4C5A5B1A8BEAFBCE0CAD32028C9CCD2B5D6205A6F6E6520303031202020202020204E334C314D3238202020202020383A33383A33312020202020323031372D312D350D0AC6F4B6AF202020202020202020202020BCCCB5E7C6F720202020202020C9CCD2B5D6D0D0C4D2BBB2E33141454C312D31BEEDC1B1C8ABBDB5BFD8D6C62028C9CCD2B5D6D0D0C4205A6F6E652030";
        hex = "B9CAD5CF2032372D443031";
        hex = "30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF";
        hex = "30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF20";
        hex = "A3C2CAAED2BBA3B2CCDDA3B1A3B9B2E30A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202031332D3038350A0D1B39BBF0BEAFBAF3D0F8200A0DA3C2CAAED2BBA3B2CCDDA3B1A3B9B2E30A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202031352D3135350A0D1B39BBF0BEAFBAF3D0F8200A0DA3C3A3B6B6B0CAD2CDE20A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202032312D3136390A0D";
        hex = "3030BBFA3031C2B7313033BAC52020202031B6B0202034B2E3D7FAD7FAD7FAD7FA0A3130D4C23131C8D53131CAB13232B7D620BBF0BEAF0A0A3030BBFA3031C2B7313030BAC52020202031B6B0202035B2E3D7FAD7FAD7FAD7FA0A3130D4C23131C8D53131CAB13232B7D620BBF0BEAF0A0A3030BBFA3031C2B7313033BAC52020202031B6B0202034B2E3D7FAD7FAD7FAD7FA0A3131D4C23031C8D53039CAB13536B7D620BBF0BEAF0A0A3030BBFA3031C2B7313030BAC52020202031B6B0202035B2E3D7FA";
        hex = "1B401B31051B361B3931372F30332F30342031333A33343A32340A3030C2A53032B2E33030B7BFBCE40AD7A1D4BAB2BF000000000AD7DFB5C00000000000000AB9CAD5CF3A30363033330AB8D0D1CC0A1B4A011B39";
        hex = "BBF0BEAF2030332D30372031363A33372030393130303520202020B5E3D0CDB8D0D1CCD6C7B3C7BBE1D2C7CAD2D5B9B0E5";
        hex = "323031372E30332E313920202031323A30303A3032202020303130313031362020B9E2B5E7CCBDB2E2C6F72020BBF0BEAF2032B2E33136BAC52020202000";
        hex = "1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401B40323031372E30332E323220202030393A32343A3530202020303130313030310A1C26C6F70DB6FEC7F82D31B2E331B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030311B69001B6C0C1C26";
        hex = "43C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3531202020303132363032380A1C26C6F70DB6FEC7F82D31B2E33238B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030321B69001B6C0C1C2642C7F84232B3B5BFE21C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3531202020303130303033330A1C26C6F70DD2BBC7F82D31B2E33333B7BF2020B8D0CEC2CCBDB2E20D1C2E1B";
        hex = "0DD2BBC7F82D31B2E33534B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030351B69001B6C0C1C2643C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3534202020303130303035350A1C26C6F70DD2BBC7F82D31B2E33535B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030361B69001B6C0C1C2643C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E32";
        hex = "3220202030393A32343A3534202020303131343133300A1C26BEEDC1B1C8ABBDB50DBFE2B7C0BBF0C8FDC7F82D31B2E3313330B7BF20200D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030311B69001B6C0C1C2641C7F8B5D8CFC2B3B51C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3534202020303131323133310A1C26C5C5D1CCB7A70DBFE2B7C0BBF0D2BBC7F82D31B2E3313331B7BF20200D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030321B";
        hex = "69001B6C0C1C2641C7F8B5D8CFC2B3B51C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3537202020303131363138380A1C26B7BFCBCDB7E7BBFA3838BAC52020CBCDB7E7BBFA0D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030331B69001B6C0C1C264231C7F8B3B5BFE231231C2E0D1B6C000D0A1C2E1B401C2E1B401C2E1B401C2E1B401C2E1B40";
        hex = "0D0A2020BBF0BEAF21202020323031372F30342F31322031323A30363A34340D0A2020CFFBB7C0CBA9C5A5202020203031B6B03031C7F83031B2E3303136BAC50D0A";
        hex = "30342D30372030313A3333202032313830393120B5E3D0CDB8D0D1CCBBF0BEAF203220B2E3B0FCD7B0BCE420";
        cnDataStr = DigitalTransUtil.hexStringToEncodeString(hex.trim().replace(" ", ""), "GBK");
        cnDataStr = "17\u5e7406\u670830\u65e512\u65f628\u5206 \u70df\u611f 001\u8def009\u53f7 \u6545\u969c  1\u680b 1\u5c42\ue810\u8d85\u5e02\ue81017\u5e7406\u670830\u65e512\u65f628\u5206 \u70df\u611f 003\u8def130\u53f7 \u6545\u969c  1\u680b 3\u5c42\ue810\u8d85\u5e02";
    }
}

