/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.CommandBuff;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class OnLineCheckResponseWriter
extends SimpleWriter {
    Logger log = Logger.getLogger();
    Unit unitBean = null;

    @Override
    public void init() throws Exception {
        this.unitBean = new Unit();
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
    }

    public void save2Redis(CommandBuff.OnLineCheckResponse info) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("onLineCheckResponse", info.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(List<Object> list) {
        PreparedStatement pst;
        Connection con;
        long beginTime;
        block14: {
            beginTime = System.currentTimeMillis();
            System.out.println("OnLineCheckResponseWriter beginTime:" + beginTime);
            con = null;
            pst = null;
            int batchCount = 0;
            int pIndex = 0;
            String sql = "{call P_UPDATE_UNIT_ONLINE(?,?,?,?,?,?)}";
            try {
                try {
                    con = ConnectionManager.openConnection();
                    con.setAutoCommit(false);
                    pst = con.prepareStatement(sql);
                    for (int i = 0; i < list.size(); ++i) {
                        JSONObject data = (JSONObject)list.get(i);
                        JSONArray units = data.getJSONArray("units");
                        this.log.writeDebugLog("units:" + units);
                        for (Object obj : units) {
                            JSONObject o = (JSONObject)obj;
                            if (o.size() <= 3) continue;
                            pIndex = 1;
                            pst.setString(pIndex++, o.getString("gatewayNo"));
                            pst.setString(pIndex++, o.getString("protocolNo"));
                            pst.setString(pIndex++, o.getString("equipmentNo"));
                            pst.setString(pIndex++, o.getString("unitNo"));
                            pst.setInt(pIndex++, o.getInt("isOnLine"));
                            pst.setLong(pIndex++, this.unitBean.getUnitId(o.getString("unitNo")));
                            pst.addBatch();
                            if (++batchCount < this.batchSize) continue;
                            pst.executeBatch();
                            con.commit();
                            batchCount = 0;
                        }
                    }
                    if (batchCount > 0) {
                        pst.executeBatch();
                        con.commit();
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (con == null) break block14;
            }
            catch (Throwable throwable) {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
                throw throwable;
            }
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        IOUtil.closeDB(null, pst, con);
        long endTime = System.currentTimeMillis();
        long costTime = (endTime - beginTime) / 1000L;
        System.out.println("OnLineCheckResponseWriter \u8017\u65f6:" + costTime + "\u79d2");
    }
}

