/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.sf.json.JSONObject;

public class ProtocolStructureWriter
extends SimpleWriter {
    private static final String sql = "{call P_INSERTT_PROTOCOL_STRUCTURE(?,?)}";

    @Override
    public void init() throws Exception {
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        this.doSave(list);
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("protocolStructure", alarmInfo.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave(List<Object> list) {
        PreparedStatement pst;
        Connection con;
        block12: {
            con = null;
            pst = null;
            int batchCount = 0;
            int pIndex = 0;
            String stamp = "";
            try {
                try {
                    con = ConnectionManager.openConnection();
                    con.setAutoCommit(false);
                    pst = con.prepareStatement(sql);
                    for (int i = 0; i < list.size(); ++i) {
                        JSONObject data = (JSONObject)list.get(i);
                        pIndex = 1;
                        pst.setString(pIndex++, data.getString("protocolNo"));
                        pst.setString(pIndex++, data.getString("function"));
                        pst.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        pst.executeBatch();
                        con.commit();
                        batchCount = 0;
                    }
                    if (batchCount > 0) {
                        pst.executeBatch();
                        con.commit();
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("stamp:" + stamp);
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    System.out.println("stamp:" + stamp);
                    e.printStackTrace();
                }
                if (con == null) break block12;
            }
            catch (Throwable throwable) {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
                throw throwable;
            }
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        IOUtil.closeDB(null, pst, con);
    }
}

