/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.JedisDBUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.data.ConnectionManager;
import com.vcarecity.savedb.data.DtuHistory;
import com.vcarecity.savedb.data.Unit;
import com.vcarecity.savedb.util.HttpRequestUtil;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import net.sf.json.JSONObject;

public class SimpleUpMsgWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    DtuHistory dtuHistoryBean = null;
    HttpRequestUtil httpRequest = null;
    JedisDBUtil JedisUtil = null;
    Unit unitBean = null;
    private static int db = 1;

    public SimpleUpMsgWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        this.log = Logger.getLogger();
        this.dtuHistoryBean = new DtuHistory();
        this.unitBean = new Unit();
        this.httpRequest = HttpRequestUtil.getHttpRequest();
        this.JedisUtil = JedisDBUtil.getInstance();
    }

    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        this.doSave(list);
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("msg", alarmInfo.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave(List<Object> list) {
        PreparedStatement pst;
        Connection con;
        long beginTime;
        block20: {
            beginTime = System.currentTimeMillis();
            con = null;
            pst = null;
            int batchCount = 0;
            int pIndex = 0;
            String dtu_no = "";
            String sql = "{call P_UPDATE_UNIT_ONLINE(?,?,?,?,?,?)}";
            try {
                try {
                    con = ConnectionManager.openConnection();
                    con.setAutoCommit(false);
                    pst = con.prepareStatement(sql);
                    block16: for (int i = 0; i < list.size(); ++i) {
                        JSONObject data = (JSONObject)list.get(i);
                        this.log.writeDebugLog("data:" + data);
                        if (data == null || data.size() <= 2) continue;
                        pIndex = 1;
                        String gatewayNo = String.valueOf(data.getInt("gatewayNo"));
                        String protocolNo = String.valueOf(data.getInt("protocolNo"));
                        String equipmentNo = "SimpleUpMsgWriter";
                        pst.setString(pIndex++, gatewayNo);
                        pst.setString(pIndex++, protocolNo);
                        pst.setString(pIndex++, equipmentNo);
                        int functionWord = data.getInt("functionWord");
                        switch (functionWord) {
                            case -1: {
                                pst.setString(4, null);
                                pst.setInt(5, 0);
                                HashMap hm = this.JedisUtil.kvs(1);
                                if (hm == null) break;
                                byte[][] keys = (byte[][])hm.get("key");
                                byte[][] values = (byte[][])hm.get("value");
                                for (int k = 0; k < values.length; ++k) {
                                    String[] tmpArr;
                                    String key = JedisDBUtil.hexToEncode(keys[k]);
                                    String value = JedisDBUtil.hexToEncode(values[k]);
                                    System.out.println(key + " ----- " + value);
                                    if (value == null || (tmpArr = value.split(",", 100)) == null || tmpArr.length <= 1 || !gatewayNo.equals(tmpArr[1])) continue;
                                    this.JedisUtil.set(db, key, gatewayNo + ",0," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                                }
                                break;
                            }
                            case 0: {
                                pst.setString(pIndex++, null);
                                pst.setInt(pIndex++, 1);
                                pst.setLong(pIndex++, this.unitBean.getUnitId(dtu_no));
                                break;
                            }
                            case 301: {
                                dtu_no = data.getString("data");
                                if (!StringUtils.isNotBlank(dtu_no)) continue block16;
                                dtu_no = dtu_no.toUpperCase();
                                pst.setString(pIndex++, dtu_no);
                                pst.setInt(pIndex++, 0);
                                pst.setLong(pIndex++, this.unitBean.getUnitId(dtu_no));
                                this.JedisUtil.set(db, dtu_no, gatewayNo + ",0," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                                break;
                            }
                            case 302: {
                                dtu_no = data.getString("data");
                                if (!StringUtils.isNotBlank(dtu_no)) continue block16;
                                dtu_no = dtu_no.toUpperCase();
                                pst.setString(pIndex++, dtu_no);
                                pst.setInt(pIndex++, 0);
                                pst.setLong(pIndex++, this.unitBean.getUnitId(dtu_no));
                                this.JedisUtil.set(db, dtu_no, gatewayNo + ",0," + beginTime + "," + TimeUtil.timeStampToString(beginTime));
                                break;
                            }
                            default: {
                                continue block16;
                            }
                        }
                        pst.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        pst.executeBatch();
                        con.commit();
                        batchCount = 0;
                    }
                    if (batchCount > 0) {
                        pst.executeBatch();
                        con.commit();
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (con == null) break block20;
            }
            catch (Throwable throwable) {
                if (con != null) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                IOUtil.closeDB(null, pst, con);
                throw throwable;
            }
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        IOUtil.closeDB(null, pst, con);
        long endTime = System.currentTimeMillis();
        long costTime = (endTime - beginTime) / 1000L;
    }

    public static void main(String[] args) throws JMSException, Exception {
    }
}

