package com.vcarecity.gbtparser.initialize;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import org.reflections.Reflections;

import java.util.*;

/**
 * @author Kerry on 18/08/13
 */

public class AnnotationScanner {


    public static Set<Class<?>> scanner(List<String> packagePrefixList) {
        Set<Class<?>> classSet = new HashSet<>();
        for (String pkg : packagePrefixList) {
            Reflections reflections = new Reflections(pkg);
            Set<Class<?>> typesAnnotatedWith = reflections.getTypesAnnotatedWith(TypeFlagMappingAnnotation.class);
            classSet.addAll(typesAnnotatedWith);
        }
        return classSet;
    }

    public static Set<Class<?>> scanner(Class<?> primarySources) {
        return scanner(Collections.singletonList(primarySources.getPackage().getName()));
    }

    public static Set<Class<?>> scanner(Class<?> primarySources, String... secondSourcePkg) {
        if (secondSourcePkg == null || secondSourcePkg.length == 0) {
            return scanner(Collections.singletonList(primarySources.getPackage().getName()));
        }
        List<String> pkg = new ArrayList<>(Arrays.asList(secondSourcePkg));
        pkg.add(primarySources.getPackage().getName());
        return scanner(pkg);
    }

    public static Set<Class<?>> scanner(Class<?> primarySources, Class<?>... secondSources) {
        if (secondSources == null || secondSources.length == 0) {
            return scanner(Collections.singletonList(primarySources.getPackage().getName()));
        }
        List<String> pkg = new ArrayList<>(secondSources.length + 1);
        pkg.add(primarySources.getPackage().getName());
        for (Class<?> source : secondSources) {
            pkg.add(source.getPackage().getName());
        }
        return scanner(pkg);
    }
}
