package com.vcarecity.gbtparser.service.impl;

import com.vcarecity.gbt.context.AppDataMessageData;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.service.IAppDataParserService;
import com.vcarecity.gbtparser.typeflag.ITypeFlagParser;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static com.vcarecity.gbtparser.GbtApplication.TYPE_FLAG_PARSER;

/**
 * @author Kerry on 18/08/13
 */
@Deprecated
public class AppDataParserServiceImpl implements IAppDataParserService {

    private static Logger logger = LoggerFactory.getLogger(AppDataParserServiceImpl.class);

    @Nullable
    @Override
    public AppDataMessageData parserAppData(byte[] appData) {
        int pos = 0;

        byte[] tf = Arrays.copyOfRange(appData, pos, pos + 1);
        pos += tf.length;
        //类型标志
        int typeFlag = HexUtil.bytesToInt(tf);

        final Class<? extends ITypeFlagParser> currentParserClazz = TYPE_FLAG_PARSER.get(typeFlag);
        if (currentParserClazz == null) {
            logger.warn("parser type flag not found = {}.", typeFlag);
            return null;
        }
        ITypeFlagParser currentParser = null;
        try {
            currentParser = currentParserClazz.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }

        //TODO 这里还要做一些判断
        assert currentParser != null;

        byte[] dc = Arrays.copyOfRange(appData, pos, pos + 1);
        pos += dc.length;

        //数据的个数
        int dataInfoCount = HexUtil.bytesToInt(dc);

        // 不定长数据截取
        byte[][] dataInfo = currentParser.indefiniteLength(pos, dataInfoCount, appData);
        if (dataInfo == null) {
            int singleDataInfoLengthDateTime = currentParser.getSingleDataInfoLength() + currentParser.dateTimeLen();
            dataInfo = new byte[dataInfoCount][];
            int index = 0;

            while (index < dataInfoCount) {
                dataInfo[index++] = Arrays.copyOfRange(appData, pos, pos + singleDataInfoLengthDateTime);
                pos += singleDataInfoLengthDateTime;
            }
        } else {
            for (byte[] temp : dataInfo) {
                pos += temp.length;
            }
        }

        //handler
        List<Map<String, Object>> dataInfoList = new ArrayList<>(dataInfo.length);
        for (byte[] di : dataInfo) {
            Map<String, Object> map = currentParser.parserInfoObjectItem(typeFlag, di);
            dataInfoList.add(map);
        }
        return new AppDataMessageData(typeFlag, dataInfoList);
    }

}