package com.vcarecity.gbtparser.service.impl;

import com.vcarecity.gbt.constant.CmdConstant;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.context.AppDataMessageData;
import com.vcarecity.gbt.context.BaseMessageData;
import com.vcarecity.gbt.util.CheckUtil;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.service.IGbtResponseService;
import com.vcarecity.gbtparser.util.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author Kerry on 18/08/16
 */

public class GbtResponseServiceImpl implements IGbtResponseService<BaseMessageData<AppDataMessageData>> {

    private byte[] getResponse(BaseMessageData<AppDataMessageData> request, int responseCmd) {
        byte[] serialNum = HexUtil.intToByteArray(request.getSerialNum(), 2);
        byte[] version = HexUtil.intToByteArray(request.getVersion(), 2);
        byte[] date;
        if (StringUtils.isEmpty(request.getDate())) {
            date = HexUtil.hexToByteArray(LocalDateTime.now().format(DateTimeFormatter.ofPattern(ConstantKey.GBT_DATE_FORMAT)));
        } else {
            date = HexUtil.hexToByteArray(request.getDate());
        }
        // require
        assert date.length == 6;

        byte[] sourceAddress = HexUtil.hexToByteArray(request.getSourceAddress());
        assert sourceAddress.length == 6;

        byte[] destAddress = HexUtil.hexToByteArray(request.getDestAddress());
        assert destAddress.length == 6;
        byte[] response = HexUtil.concatAll(serialNum, version, date, sourceAddress, destAddress);

        byte[] dataLen = HexUtil.intToByteArray(0, 2);
        byte[] cmdResponseByte = HexUtil.intToByteArray(responseCmd, 1);

        //没有应用数据...
        return mergeAndCalcCRC(response, dataLen, cmdResponseByte);
    }

    private byte[] mergeAndCalcCRC(byte[]... data) {
        byte[] result = HexUtil.concatAll(data);
        byte[] calcCrc = CheckUtil.calcCrc(result);
        return HexUtil.concatAll(result, calcCrc);
    }


    @Nullable
    @Override
    public byte[] getConfirmResponse(BaseMessageData<AppDataMessageData> request) {
        if (request.getCmd() != CmdConstant.CMD_SEND) {
            return null;
        }
        return getResponse(request, CmdConstant.CMD_CONFIRM);
    }

    @Nullable
    @Override
    public byte[] getDenyResponse(BaseMessageData<AppDataMessageData> request) {
        if (request.getCmd() != CmdConstant.CMD_SEND) {
            return null;
        }
        return getResponse(request, CmdConstant.CMD_DENY);
    }

}
