package com.vcarecity.gbtparser.typeflag;

import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.util.HexUtil;

import java.util.Arrays;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 */

public abstract class AbstractTypFlagCalcDateParser implements ITypeFlagParser {

    /**
     * 加时间
     *
     * @param resultMap
     * @param currentPos
     * @param singleInfoObjectByte
     * @return
     */
    protected final Map<String, Object> calcDateTime(Map<String, Object> resultMap, int currentPos, byte[] singleInfoObjectByte) {
        int endTimePos = currentPos + dateTimeLen();
        if (endTimePos > currentPos) {
            if (endTimePos <= singleInfoObjectByte.length) {
                String dateTime = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPos, endTimePos));
                resultMap.put(ConstantKey.DATE_TIME, dateTime);
            }
        }
        return resultMap;
    }
}
