package com.vcarecity.gbtparser.typeflag;

import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 */

public abstract class AbstractTypeFlagConvert implements ITypeFlagConvert {


    @Override
    public byte[] convertInfoObjectItem(int typeFlag, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        if (!map.containsKey(TypeFlagKey.SYSTEM_TYPE)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.SYSTEM_TYPE);
        }
        if (!map.containsKey(TypeFlagKey.SYSTEM_ADDRESS)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.SYSTEM_ADDRESS);
        }
        int systemType = Integer.parseInt(map.get(TypeFlagKey.SYSTEM_TYPE).toString());
        int systemAddress = Integer.parseInt(map.get(TypeFlagKey.SYSTEM_ADDRESS).toString());

        return convertInfoObjectItem(typeFlag, systemType, systemAddress, map);
    }

    /**
     * 组合共同信息
     *
     * @param systemType
     * @param systemAddress
     * @return
     */
    protected byte[] concatSystem(int systemType, int systemAddress, byte[]... data) {
        if (data != null && data.length > 0) {
            byte[] temp = HexUtil.concatAll(data);
            return HexUtil.concatAll(HexUtil.intToByteArray(systemType, 1), HexUtil.intToByteArray(systemAddress, 1), temp);
        }
        return HexUtil.concatAll(HexUtil.intToByteArray(systemType, 1), HexUtil.intToByteArray(systemAddress, 1));
    }

    /**
     * 共同转换,减少代码
     *
     * @param typeFlag
     * @param systemType
     * @param systemAddress
     * @param map
     * @return
     * @throws MissingTypFlagJsonKeyException
     */
    protected abstract byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException;


}
