package com.vcarecity.gbtparser.typeflag;

import com.vcarecity.gbt.util.HexUtil;

import java.util.Arrays;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 */

public abstract class AbstractTypeFlagParser extends AbstractTypFlagCalcDateParser {

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {

        int pos = 0;
        int systemType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        int systemAddress = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        return parserInfoObjectItem(systemType, systemAddress, pos, singleInfoObjectByte);
    }

    /**
     * 转换了一些共同的部分
     *
     * @param systemType
     * @param systemAddress
     * @param currentPosition
     * @param singleInfoObjectByte
     * @return
     */
    protected abstract Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte);

}
