package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 查岗命令
 * <p>
 * 类型值: 91
 * 方向 : 下行
 * <p>
 * 类型标志符(1)
 * 信息对象数目(1) == 1
 * --------------
 * 查岗应答超时设定时间(1) 分钟
 */

@TypeFlagMappingAnnotation(value = "91", direction = false)
public class CheckOrderCmd extends AbstractTypeFlagConvert {

    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    public byte[] convertInfoObjectItem(int typeFlag, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        if (!map.containsKey(TypeFlagKey.TIMEOUT)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.TIMEOUT);
        }
        String string = map.get(TypeFlagKey.TIMEOUT).toString();
        int timeout = Integer.parseInt(string);
        if (timeout <= 0) {
            throw new IllegalArgumentException(string);
        }

        return HexUtil.intToByteArray(timeout, 1);
    }

    /**
     * 没用.
     *
     * @param typeFlag
     * @param systemType
     * @param systemAddress
     * @param map
     * @return
     * @throws MissingTypFlagJsonKeyException
     */
    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return new byte[0];
    }
}
