package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 读建筑消防设施部件配置情况
 * <p>
 * 类型值: 67
 * 方向 : 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象教目(1字节)
 * ----------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 部件地址1(4字节)
 * .................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 部件地址n(4字节)
 */


@TypeFlagMappingAnnotation(value = "67", direction = false)
public class ReadBuildingFirePartConfiguration extends AbstractTypeFlagConvert {
    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        if (!map.containsKey(TypeFlagKey.PART_ADDRESS)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.PART_ADDRESS);
        }
        String partAddress = map.get(TypeFlagKey.PART_ADDRESS).toString();
        return concatSystem(systemType, systemAddress, HexUtil.hexToByteArray(partAddress));
    }
}
