package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 读建筑消防设施部件模拟量值
 * <p>
 * 类型值: 63
 * 方向 : 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ---------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 部件地址1(4字节)
 * ...............
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 部件地址n(4字节)
 */

@TypeFlagMappingAnnotation(value = "63", direction = false)
public class ReadBuildingFirePartSimulatedValue extends AbstractTypeFlagConvert {
    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        if (!map.containsKey(TypeFlagKey.PART_ADDRESS)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.PART_ADDRESS);
        }
        String partAddressStr = map.get(TypeFlagKey.PART_ADDRESS).toString();
        byte[] partAddress = HexUtil.checkByteArrayLen(HexUtil.hexToByteArray(partAddressStr), 4);
        return concatSystem(systemType, systemAddress, partAddress);
    }
}
