package com.vcarecity.gbtparser.typeflag.parser;


import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/13
 * <p>
 * 上传建筑消防设施部件运行状态
 * <p>
 * 类型值 : 2
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象教耳(1字节)
 * -----------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 部件类型1(1字节)
 * 部件地址1(4字节)
 * 部件状舂1(2字节)
 * 部件说明1(3l字节)
 * 状吝1发生时间(6字节)
 * ...................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 部件类型n(1字节)
 * 部件地址n(字节)
 * 部件状杏n(2字节)
 * 部件说明n(31字节)
 * 状志n发生时问(6字节)
 */

@TypeFlagMappingAnnotation("2")
public class UpBuildingFirePartRunningStatus extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 40;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {
        final int partType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final String partAddress = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 4));
        currentPosition += 4;

        final String partStatus = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 2));
        currentPosition += 2;

        final byte[] partDescriptionByte = Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 31);
        final String partDescription = new String(partDescriptionByte, Charset.forName(ConstantKey.GB18030_CHARSET)).trim();
        currentPosition += partDescriptionByte.length;

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.PART_TYPE, partType);
        map.put(TypeFlagKey.PART_ADDRESS, partAddress);
        map.put(TypeFlagKey.PART_STATUS, partStatus);
        map.put(TypeFlagKey.PART_DESCRIPTION, partDescription);

        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }
}
