package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/13
 * <p>
 * 上传建筑消防设施部件模拟量值
 * <p>
 * 类型值 : 3
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ----------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 部件类型1(1字节)
 * 都件地址1(4字节)
 * 模拟量类型1(1字节)
 * 模拟量值1(2字节)
 * 模拟量值1的采样时问(6字节)
 * .......................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 部件类型n(1字节)
 * 部件地址n(4字节)
 * 模拟量类型n(1字节)
 * 模拟量值n(2字节)
 * 模拟量值n的采样时问(6字节)
 */

@TypeFlagMappingAnnotation("3")
public class UpBuildingFirePartSimulatedValue extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 10;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {

        final int partType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final String partAddress = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 4));
        currentPosition += 4;

        final int simulatedType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final int simulatedValue = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 2));
        currentPosition += 2;

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.PART_TYPE, partType);
        map.put(TypeFlagKey.PART_ADDRESS, partAddress);
        map.put(TypeFlagKey.SIMULATED_TYPE, simulatedType);
        map.put(TypeFlagKey.SIMULATED_VALUE, simulatedValue);

        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }
}
