package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传建筑消防设施系统时间
 * <p>
 * 类型值: 8
 * 方向 : 上行
 * <p>
 * <p>
 * 类型标志符(1字节) = 8
 * 信息对象数日(1字节) = 1
 * ----------------------
 * 系统类型(1字节)
 * 系统地址(1字节)
 * 建筑消防设施的系统时间(6宇节)
 */

@TypeFlagMappingAnnotation("8")
public class UpBuildingFireSystemTime extends AbstractTypeFlagParser {

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {
        Map<String, Object> map = new HashMap<>(4);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }

    @Override
    public int getSingleDataInfoLength() {
        return 2;
    }
}
