package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypFlagCalcDateParser;

import java.util.Collections;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传用户信息传输装置系统时间
 * <p>
 * 类型值: 28
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节) = 8
 * 信息对象数日(1字节) = 1
 * ----------------------
 * 建筑消防设施的系统时间(6宇节)
 */

@TypeFlagMappingAnnotation("28")
public class UpUserInfoFireTransportSystemTime extends AbstractTypFlagCalcDateParser {
    @Override
    public int getSingleDataInfoLength() {
        return 0;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        String dateTime = HexUtil.byteArrayToHex(singleInfoObjectByte);
        return Collections.singletonMap(ConstantKey.DATE_TIME, dateTime);
    }
}
