package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypFlagCalcDateParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传用户信息传输装置运行状态
 * <p>
 * 类型值: 21
 * 方向 : 上行
 * <p>
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * -----------------
 * 状态(1字节)
 * 状态发生时问(6字节)
 */

@TypeFlagMappingAnnotation("21")
public class UpUserInfoTransportRunningStatus extends AbstractTypFlagCalcDateParser {
    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        int currentPosition = 0;
        int status = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        Map<String, Object> map = new HashMap<>(4);
        map.put(ConstantKey.STATUS, status);
        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }

    @Override
    public int getSingleDataInfoLength() {
        return 1;
    }
}
