package com.vcarecity.gbtparser;


import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbtparser.initialize.AnnotationScanner;
import com.vcarecity.gbtparser.typeflag.ITypeFlagConvert;
import com.vcarecity.gbtparser.typeflag.ITypeFlagParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Kerry on 18/08/13
 *
 * <pre>
 *     GbtApplication.run(baseClassScannerPackage);
 * </pre>
 */

public class GbtApplication {

    private static Logger logger = LoggerFactory.getLogger(GbtApplication.class);

    /**
     * 功能,类 对应关系
     */
    public static final Map<Integer, Class<? extends ITypeFlagParser>> TYPE_FLAG_PARSER = new ConcurrentHashMap<>(64);

    /**
     * 下发指令的功能
     */
    public static final Map<Integer, Class<? extends ITypeFlagConvert>> TYPE_FLAG_CONVERTER = new ConcurrentHashMap<>(64);

    public static void run() {
        Set<Class<?>> scanner = AnnotationScanner.scanner(GbtApplication.class);
        checkInterface(scanner);
        debug();
    }

    public static void run(String... primaryPackage) {
        Set<Class<?>> scanner = AnnotationScanner.scanner(GbtApplication.class, primaryPackage);
        checkInterface(scanner);
        debug();
    }

    /**
     * 必须调用,传入扫描的开始类
     *
     * @param primarySources
     */
    public static void run(Class<?>... primarySources) {
        Set<Class<?>> scanner = AnnotationScanner.scanner(GbtApplication.class, primarySources);
        checkInterface(scanner);
        debug();
    }

    private static void debug() {
        TYPE_FLAG_PARSER.forEach((k, v) -> logger.debug("{} - {}", k, v));
        TYPE_FLAG_CONVERTER.forEach((k, v) -> logger.debug("{} - {}", k, v));
    }

    private static void checkInterface(Set<Class<?>> scanner) {
        for (Class<?> clazz : scanner) {
            TypeFlagMappingAnnotation annotation = clazz.getAnnotation(TypeFlagMappingAnnotation.class);
            if (annotation.reserved()) {
                continue;
            }
            String id = annotation.value();
            if (id.trim().length() == 0) {
                continue;
            }
            if (ITypeFlagParser.class.isAssignableFrom(clazz)) {
                TYPE_FLAG_PARSER.put(Integer.parseInt(id.trim()), (Class<? extends ITypeFlagParser>) clazz);
            } else if (ITypeFlagConvert.class.isAssignableFrom(clazz)) {
                TYPE_FLAG_CONVERTER.put(Integer.parseInt(id.trim()), (Class<? extends ITypeFlagConvert>) clazz);
            }
        }

    }

}
