package com.vcarecity.gbtparser.result;

import com.vcarecity.gbt.context.AppDataMessageData;
import com.vcarecity.gbt.context.BaseMessageData;
import com.vcarecity.gbt.status.ParserStatus;


/**
 * @author Kerry on 18/08/16
 */

public class ParserResultHelper {


    public static ParserResult<BaseMessageData<AppDataMessageData>> ok(BaseMessageData<AppDataMessageData> message) {
        return new ParserResult<>(ParserStatus.SUCCESS, message);
    }

    public static ParserResult<BaseMessageData<AppDataMessageData>> confirm(BaseMessageData<AppDataMessageData> message) {
        return new ParserResult<>(ParserStatus.CONFIRM, message);
    }

    public static ParserResult<BaseMessageData<AppDataMessageData>> deny(BaseMessageData<AppDataMessageData> message) {
        return new ParserResult<>(ParserStatus.DENY, message);
    }


    public static ParserResult<BaseMessageData<AppDataMessageData>> build(ParserStatus status, BaseMessageData<AppDataMessageData> message) {
        return new ParserResult<>(status, message);
    }


}
