package com.vcarecity.gbtparser.service.impl;

import com.vcarecity.gbt.context.AppDataMessageData;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.service.IAppDataConvertService;
import com.vcarecity.gbtparser.typeflag.ITypeFlagConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

import static com.vcarecity.gbtparser.GbtApplication.TYPE_FLAG_CONVERTER;

/**
 * @author Kerry on 18/08/14
 */


@Deprecated
public class AppDataConvertServiceImpl implements IAppDataConvertService {
    private static Logger logger = LoggerFactory.getLogger(AppDataConvertServiceImpl.class);


    @Override
    public byte[] convertAppData(AppDataMessageData appData) throws MissingTypFlagJsonKeyException {
        int typeFlag = appData.getTypeFlag();

        final Class<? extends ITypeFlagConvert> currentConverterClazz = TYPE_FLAG_CONVERTER.get(typeFlag);
        if (currentConverterClazz == null) {
            logger.warn("converter type flag not found = {}.", typeFlag);
            return null;
        }
        ITypeFlagConvert currentConverter = null;
        try {
            currentConverter = currentConverterClazz.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }

        //TODO 这里还要做一些判断
        assert currentConverter != null;

        final List<Map<String, Object>> dataInfo = appData.getDataInfo();

        byte[] dimension = new byte[0];

        if (dataInfo != null && !dataInfo.isEmpty()) {
            Integer infoObjectCount = currentConverter.getInfoObjectCount();
            if (infoObjectCount == null) {
                infoObjectCount = dataInfo.size();
            }
            byte[][] appBody = new byte[infoObjectCount][];
            int index = 0;
            for (Map<String, Object> map : dataInfo) {
                byte[] temp = currentConverter.convertInfoObjectItem(typeFlag, map);
                if (temp != null && temp.length > 0) {
                    appBody[index++] = temp;
                }
            }
            dimension = HexUtil.concatAll(HexUtil.intToByteArray(index, 1), HexUtil.reduceDimension(appBody));
        }
        return HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1), dimension);
    }
}
