package com.vcarecity.gbtparser.simulation;

import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.util.CheckUtil;
import com.vcarecity.gbt.util.HexUtil;

import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author Kerry on 18/08/17
 * <p>
 * 生成测试数据
 */

@SuppressWarnings("Duplicates")
public class BuildTestByteData {

    private int serialNum = 1;
    private int version = 2;
    private String date;
    private String sourceAddress;
    private String destAddress;


    private static String[] INFO_LIST = new String[]{"说话前后不久的", "配置", "测试开发", "爱你...."};


    public BuildTestByteData(String sourceAddress, String destAddress) {
        this(LocalDateTime.now().format(DateTimeFormatter.ofPattern(ConstantKey.GBT_DATE_FORMAT)), sourceAddress, destAddress);
    }


    public BuildTestByteData(String date, String sourceAddress, String destAddress) {
        this.date = date;
        this.sourceAddress = sourceAddress;
        this.destAddress = destAddress;
    }

    public BuildTestByteData(int serialNum, int version, String date, String sourceAddress, String destAddress) {
        this.serialNum = serialNum;
        this.version = version;
        this.date = date;
        this.sourceAddress = sourceAddress;
        this.destAddress = destAddress;
    }

    private byte[] mergeHead() {
        return HexUtil.concatAll(HexUtil.intToByteArray(serialNum, 2),
                HexUtil.intToByteArray(version, 2),
                HexUtil.hexToByteArray(date),
                HexUtil.hexToByteArray(sourceAddress),
                HexUtil.hexToByteArray(destAddress)
        );
    }

    private byte[] concatAndCalcCrc(int cmd, byte[][] data) {
        byte[] appData = HexUtil.reduceDimension(data);
        byte[] dataLenByte = HexUtil.intToByteArray(appData.length, 2);
        byte[] cmdByte = HexUtil.intToByteArray(cmd, 1);

        byte[] head = mergeHead();
        byte[] body = HexUtil.concatAll(head, dataLenByte, cmdByte, appData);
        byte[] calcCrc = CheckUtil.calcCrc(body);
        return HexUtil.concatAll(body, calcCrc);
    }


    private byte[] concatAndCalcCrc(int cmd, byte[] prefixData, byte[][] data) {
        byte[] tempData = HexUtil.reduceDimension(data);
        byte[] appData = HexUtil.concatAll(prefixData, tempData);
        byte[] dataLenByte = HexUtil.intToByteArray(appData.length, 2);
        byte[] cmdByte = HexUtil.intToByteArray(cmd, 1);

        byte[] head = mergeHead();
        byte[] body = HexUtil.concatAll(head, dataLenByte, cmdByte, appData);
        byte[] calcCrc = CheckUtil.calcCrc(body);
        return HexUtil.concatAll(body, calcCrc);
    }


    private byte[] concatAndCalcCrcByte(int cmd, byte[] prefixData, byte[]... data) {

        assert data != null;
        byte[][] temp = new byte[data.length][];
        for (int i = 0; i < data.length; i++) {
            temp[i] = data[i];
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }


    /**
     * 1. 上传建筑消防设施系统状态
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build1(int cmd, int count) {
        int typeFlag = 1;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));


        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);
            byte[] sysStatus = HexUtil.intToByteArray(i + 64, 2);
            byte[] dateByte = HexUtil.hexToByteArray(this.date);
            temp[i] = HexUtil.concatAll(sysType, sysAddress, sysStatus, dateByte);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 2. 上传建筑消防设施部件运行状态
     *
     * @return
     */
    public byte[] build2(int cmd, int count) {
        int typeFlag = 2;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);
            byte[] partType = HexUtil.intToByteArray(i + 64, 1);
            byte[] partAddress = HexUtil.hexToByteArray("AA00110" + i);
            byte[] partStatus = HexUtil.intToByteArray(i + 64, 2);
            byte[] partDesp = HexUtil.checkByteArrayLen((i + "配置").getBytes(Charset.forName(ConstantKey.GB18030_CHARSET)), 31);
            byte[] dateByte = HexUtil.hexToByteArray(this.date);
            temp[i] = HexUtil.concatAll(sysType, sysAddress, partType, partAddress, partStatus, partDesp, dateByte);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 3. 上传建筑消防设施部件模拟量值
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build3(int cmd, int count) {
        int typeFlag = 3;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);
            byte[] partType = HexUtil.intToByteArray(i + 64, 1);
            byte[] partAddress = HexUtil.hexToByteArray("AA00110" + i);
            byte[] simulateType = HexUtil.intToByteArray(i + 64, 1);
            byte[] simulateValue = HexUtil.intToByteArray(i + 128, 2);
            byte[] dateByte = HexUtil.hexToByteArray(this.date);
            temp[i] = HexUtil.concatAll(sysType, sysAddress, partType, partAddress, simulateType, simulateValue, dateByte);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 4. 上传建筑消防设施操作信息记录
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build4(int cmd, int count) {
        int typeFlag = 4;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);
            byte[] opInfo = HexUtil.intToByteArray(i + 64, 1);
            byte[] opNo = HexUtil.intToByteArray(i + 64, 1);

            byte[] dateByte = HexUtil.hexToByteArray(this.date);
            temp[i] = HexUtil.concatAll(sysType, sysAddress, opInfo, opNo, dateByte);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 5. 上传建筑消防设施软件版本
     *
     * @param cmd
     * @return
     */
    public byte[] build5(int cmd) {
        int typeFlag = 5;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));

        byte[] sysType = HexUtil.intToByteArray(1, 1);
        byte[] sysAddress = HexUtil.intToByteArray(31, 1);
        byte[] manjarVersion = HexUtil.intToByteArray(64, 1);
        byte[] minjarVersion = HexUtil.intToByteArray(64, 1);

        return concatAndCalcCrcByte(cmd, prefixData, sysType, sysAddress, manjarVersion, minjarVersion);

    }


    /**
     * 6. 上传建筑消防设施系统配置情况
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build6(int cmd, int count) {

        assert count <= 3;

        int typeFlag = 6;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);

            byte[] data = INFO_LIST[i].getBytes(Charset.forName(ConstantKey.GB18030_CHARSET));
            byte[] subDataLen = HexUtil.intToByteArray(data.length, 1);

            temp[i] = HexUtil.concatAll(sysType, sysAddress, subDataLen, data);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 7. 上传建筑消防设施部件配置情况
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build7(int cmd, int count) {
        assert count <= 26;
        int typeFlag = 7;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {
            byte[] sysType = HexUtil.intToByteArray(1 + i, 1);
            byte[] sysAddress = HexUtil.intToByteArray(i + 31, 1);
            byte[] partType = HexUtil.intToByteArray(i + 64, 1);
            byte[] partAddress = HexUtil.hexToByteArray("AA00110" + i);

            byte[] partDesp = HexUtil.checkByteArrayLen((i + "配置").getBytes(Charset.forName(ConstantKey.GB18030_CHARSET)), 31);

            temp[i] = HexUtil.concatAll(sysType, sysAddress, partType, partAddress, partDesp);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }

    /**
     * 8. 上传建筑消防设施系统时间
     *
     * @param cmd
     * @return
     */
    public byte[] build8(int cmd) {
        int typeFlag = 8;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));

        byte[] sysType = HexUtil.intToByteArray(1, 1);
        byte[] sysAddress = HexUtil.intToByteArray(31, 1);
        byte[] dateTime = HexUtil.hexToByteArray(date);

        return concatAndCalcCrcByte(cmd, prefixData, sysType, sysAddress, dateTime);
    }

    /**
     * 21. 上传用户信息传输装置运行状态
     *
     * @param cmd
     * @return
     */
    public byte[] build21(int cmd) {
        int typeFlag = 21;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));

        byte[] sysType = HexUtil.intToByteArray(1, 1);
        byte[] sysAddress = HexUtil.intToByteArray(31, 1);
        byte[] status = HexUtil.intToByteArray(31, 1);

        return concatAndCalcCrcByte(cmd, prefixData, sysType, sysAddress, status);
    }

    /**
     * 24. 上传用户信息传输装置操作信息记录
     *
     * @param cmd
     * @param count
     * @return
     */
    public byte[] build24(int cmd, int count) {
        assert count <= 127;
        int typeFlag = 24;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(count, 1));
        byte[][] temp = new byte[count][];
        for (int i = 0; i < count; i++) {

            byte[] opInfo = HexUtil.intToByteArray(i + 64, 1);
            byte[] opNo = HexUtil.intToByteArray(i, 1);

            byte[] dateTime = HexUtil.hexToByteArray(date);

            temp[i] = HexUtil.concatAll(opInfo, opNo, dateTime);
        }
        return concatAndCalcCrc(cmd, prefixData, temp);
    }


    /**
     * 25. 上传用户信息传输装置软件版本
     *
     * @return
     */
    public byte[] build25(int cmd) {
        int typeFlag = 25;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));

        byte[] version = HexUtil.intToByteArray(63, 2);
        return concatAndCalcCrcByte(cmd, prefixData, version);
    }


    /**
     * 26. 上传用户信息传输装置配置情况
     *
     * @param cmd
     * @return
     */
    public byte[] build26(int cmd) {
        int typeFlag = 26;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));
        byte[] array = HexUtil.checkByteArrayLen(INFO_LIST[0].getBytes(Charset.forName(ConstantKey.GB18030_CHARSET)), 31);
        byte[] dataLen = HexUtil.intToByteArray(array.length, 1);
        return concatAndCalcCrcByte(cmd, prefixData, dataLen, array);
    }


    /**
     * 28. 上传用户信息传输装置系统时间
     *
     * @param cmd
     * @return
     */
    public byte[] build28(int cmd) {
        int typeFlag = 28;
        byte[] prefixData = HexUtil.concatAll(HexUtil.intToByteArray(typeFlag, 1),
                HexUtil.intToByteArray(1, 1));
        return concatAndCalcCrcByte(cmd, prefixData, HexUtil.hexToByteArray(this.date));
    }

    @Override
    public String toString() {
        return "{" +
                "serialNum=" + serialNum +
                ", version=" + version +
                ", date='" + date + '\'' +
                ", sourceAddress='" + sourceAddress + '\'' +
                ", destAddress='" + destAddress + '\'' +
                '}';
    }


}
