package com.vcarecity.gbtparser.typeflag;

import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * json object to HEX
 */

public interface ITypeFlagConvert {

    /**
     * 转换
     *
     * @param typeFlag
     * @param map
     * @return
     * @throws MissingTypFlagJsonKeyException
     */
    byte[] convertInfoObjectItem(int typeFlag, Map<String, Object> map) throws MissingTypFlagJsonKeyException;


    /**
     * 默认对象的数据,如果返回 null ,就由JSON数据决定
     *
     * @return
     */
    default Integer getInfoObjectCount() {
        return null;
    }

}
