package com.vcarecity.gbtparser.typeflag;

import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * @author Kerry on 18/08/13
 * <p>
 * hex to json object
 */

public interface ITypeFlagParser {


    /**
     * 获取单个DataInfo的长度, 这里只对定长的数据项生效,不定长数据的截取,请override indefiniteLength(..)方法,
     * 由于大部分数据都是定长,所以强制重写这个方法,不定长数据时,当前方法返回值不生效,随意就可以
     * 这里不包括后面的时间长度
     *
     * @return
     */
    int getSingleDataInfoLength();

    /**
     * 转换单个信息对象
     *
     * @param typeFlag
     * @param singleInfoObjectByte
     * @return
     */
    Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte);

    /**
     * 不定长数据截取
     *
     * @param pos
     * @param dataInfoCount
     * @param appData
     * @return
     */
    @Nullable
    default byte[][] indefiniteLength(int pos, int dataInfoCount, byte[] appData) {
        return null;
    }

    /**
     * 返回时间长度
     * <p>
     * 默认: 6
     * 重写可以返回 0 ,不带时间
     *
     * @return
     */
    default int dateTimeLen() {
        return 6;
    }

}
